/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageDataLeaf;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;

public class PageDataLeafOverflow
extends Record {
    static final int START_LAST = 7;
    static final int START_MORE = 9;
    private final PageDataLeaf leaf;
    private final int type;
    private final int previous;
    private final int next;
    private final int size;
    private final int offset;
    private DataPage data;

    PageDataLeafOverflow(PageDataLeaf pageDataLeaf, int n, int n2, int n3, int n4, int n5, int n6) {
        this.leaf = pageDataLeaf;
        this.setPos(n);
        this.type = n2;
        this.previous = n3;
        this.next = n4;
        this.offset = n5;
        this.size = n6;
    }

    public PageDataLeafOverflow(PageDataLeaf pageDataLeaf, int n, DataPage dataPage, int n2) throws JdbcSQLException {
        this.leaf = pageDataLeaf;
        this.setPos(n);
        this.data = dataPage;
        this.offset = n2;
        this.previous = dataPage.readInt();
        this.type = dataPage.readByte();
        if (this.type == 19) {
            this.size = dataPage.readShortInt();
            this.next = 0;
        } else if (this.type == 3) {
            this.size = pageDataLeaf.getPageStore().getPageSize() - 9;
            this.next = dataPage.readInt();
        } else {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " type:" + this.type);
        }
    }

    int readInto(DataPage dataPage) {
        if (this.type == 19) {
            dataPage.write(this.data.getBytes(), 7, this.size);
            return 0;
        }
        dataPage.write(this.data.getBytes(), 9, this.size);
        return this.next;
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return this.leaf.getByteCount(dataPage);
    }

    public void write(DataPage dataPage) throws SQLException {
        PageStore pageStore = this.leaf.getPageStore();
        DataPage dataPage2 = pageStore.createDataPage();
        DataPage dataPage3 = this.leaf.getDataPage();
        dataPage2.writeInt(this.previous);
        dataPage2.writeByte((byte)this.type);
        if (this.type == 3) {
            dataPage2.writeInt(this.next);
        } else {
            dataPage2.writeShortInt(this.size);
        }
        dataPage2.write(dataPage3.getBytes(), this.offset, this.size);
        pageStore.writePage(this.getPos(), dataPage2);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf overflow prev:" + this.previous + " next:" + this.next;
    }
}

