/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;

public class JdbcStatement
extends TraceObject
implements Statement {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected int updateCount;
    protected int resultSetType;
    protected boolean closedByResultSet;
    private CommandInterface executingCommand;
    private ObjectArray batchCommands;
    private boolean escapeProcessing = true;

    JdbcStatement(JdbcConnection jdbcConnection, int n, int n2, boolean bl) {
        this.conn = jdbcConnection;
        this.session = jdbcConnection.getSession();
        this.setTrace(this.session.getTrace(), 8, n2);
        this.resultSetType = n;
        this.closedByResultSet = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery(" + this.quote(string) + ")");
            }
            this.checkClosed();
            this.closeOldResultSet();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
                boolean bl = this.resultSetType != 1003;
                this.setExecutingStatement(commandInterface);
                try {
                    resultInterface = commandInterface.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                commandInterface.close();
                this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            this.checkClosed();
            this.closeOldResultSet();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    this.updateCount = commandInterface.executeUpdate();
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            return this.updateCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        try {
            boolean bl;
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeCall("execute", string);
            }
            this.checkClosed();
            this.closeOldResultSet();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            CommandInterface commandInterface = this.conn.prepareCommand(string, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    if (commandInterface.isQuery()) {
                        bl = true;
                        boolean bl2 = this.resultSetType != 1003;
                        ResultInterface resultInterface = commandInterface.executeQuery(this.maxRows, bl2);
                        this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl2);
                    } else {
                        bl = false;
                        this.updateCount = commandInterface.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            return bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int n = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, n, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeOldResultSet();
            if (this.conn != null) {
                this.conn = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            this.debugCodeCall("getConnection");
            this.checkClosed();
            return this.conn;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOldResultSet();
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", n);
            this.checkClosed();
            if (n < 0) {
                throw Message.getInvalidValueException("" + n, "maxRows");
            }
            this.maxRows = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n);
            this.checkClosed();
            if (n < 0 || n > 0 && this.maxRows > 0 && n > this.maxRows) {
                throw Message.getInvalidValueException("" + n, "rows");
            }
            if (n == 0) {
                n = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return 1008;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setEscapeProcessing(" + bl + ");");
            }
            this.checkClosed();
            this.escapeProcessing = bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface commandInterface = this.executingCommand;
            try {
                if (commandInterface != null) {
                    commandInterface.cancel();
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            if (n < 0) {
                throw Message.getInvalidValueException("" + n, "seconds");
            }
            this.conn.setQueryTimeout(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            this.checkClosed();
            if (this.escapeProcessing) {
                string = this.conn.translateSQL(string);
            }
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            this.batchCommands.add(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchCommands == null) {
                this.batchCommands = new ObjectArray();
            }
            int[] nArray = new int[this.batchCommands.size()];
            boolean bl = false;
            for (int i = 0; i < this.batchCommands.size(); ++i) {
                String string = (String)this.batchCommands.get(i);
                try {
                    nArray[i] = this.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    this.logAndConvert(sQLException);
                    nArray[i] = -3;
                    bl = true;
                }
            }
            this.batchCommands = null;
            if (bl) {
                throw new BatchUpdateException(nArray);
            }
            return nArray;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "getGeneratedKeys()");
            }
            this.checkClosed();
            ResultInterface resultInterface = this.conn.getGeneratedKeys();
            JdbcResultSet jdbcResultSet = new JdbcResultSet(this.conn, this, resultInterface, n, false, true);
            return jdbcResultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults", n);
            switch (n) {
                case 1: 
                case 3: {
                    if (this.resultSet == null) break;
                    this.resultSet.close();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw Message.getInvalidValueException("" + n, "current");
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + n + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.executeUpdate(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + n + ");");
            }
            return this.execute(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.execute(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.execute(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    boolean checkClosed() throws SQLException {
        if (this.conn == null) {
            throw Message.getSQLException(90007);
        }
        if (this.conn.checkClosed()) {
            this.session = this.conn.getSession();
            this.setTrace(this.session.getTrace());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOldResultSet() throws SQLException {
        try {
            if (!this.closedByResultSet && this.resultSet != null) {
                this.resultSet.closeInternal();
            }
        }
        finally {
            this.resultSet = null;
            this.updateCount = -1;
        }
    }

    protected void setExecutingStatement(CommandInterface commandInterface) {
        this.conn.setExecutingStatement(commandInterface == null ? null : this);
        this.executingCommand = commandInterface;
    }

    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isPoolable() {
        this.debugCodeCall("isPoolable");
        return false;
    }

    public void setPoolable(boolean bl) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPoolable(" + bl + ");");
        }
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

