/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableLink;
import org.h2.table.TableLinkConnection;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private TableLink link;
    private String targetTableName;
    private long rowCount;

    public LinkedIndex(TableLink tableLink, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(tableLink, n, null, indexColumnArray, indexType);
        this.link = tableLink;
        this.targetTableName = this.link.getQualifiedTable();
    }

    public String getCreateSQL() {
        return null;
    }

    public void close(Session session) {
    }

    private boolean isNull(Value value) {
        return value == null || value == ValueNull.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.targetTableName);
        stringBuffer.append(" VALUES(");
        int n = 0;
        for (int i = 0; i < row.getColumnCount(); ++i) {
            object = row.getValue(i);
            if (n > 0) {
                stringBuffer.append(',');
            }
            ++n;
            if (this.isNull((Value)object)) {
                stringBuffer.append("NULL");
                continue;
            }
            stringBuffer.append('?');
        }
        stringBuffer.append(')');
        String string = stringBuffer.toString();
        TableLinkConnection tableLinkConnection = this.link.getConnection();
        synchronized (tableLinkConnection) {
            try {
                object = this.link.getPreparedStatement(string, false);
                int n2 = 0;
                for (int i = 0; i < row.getColumnCount(); ++i) {
                    Value value = row.getValue(i);
                    if (value == null || value == ValueNull.INSTANCE) continue;
                    value.set((PreparedStatement)object, n2 + 1);
                    ++n2;
                }
                object.executeUpdate();
                ++this.rowCount;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; searchRow != null && n < searchRow.getColumnCount(); ++n) {
            object2 = searchRow.getValue(n);
            if (object2 == null) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" AND ");
            }
            object = this.table.getColumn(n);
            stringBuffer.append(((Column)object).getSQL());
            stringBuffer.append(">=");
            this.addParameter(stringBuffer, (Column)object);
        }
        for (n = 0; searchRow2 != null && n < searchRow2.getColumnCount(); ++n) {
            object2 = searchRow2.getValue(n);
            if (object2 == null) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" AND ");
            }
            object = this.table.getColumn(n);
            stringBuffer.append(((Column)object).getSQL());
            stringBuffer.append("<=");
            this.addParameter(stringBuffer, (Column)object);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, " WHERE ");
        }
        stringBuffer.insert(0, "SELECT * FROM " + this.targetTableName + " T");
        String string = stringBuffer.toString();
        object2 = this.link.getConnection();
        synchronized (object2) {
            try {
                Value value;
                int n2;
                object = this.link.getPreparedStatement(string, true);
                int n3 = 0;
                for (n2 = 0; searchRow != null && n2 < searchRow.getColumnCount(); ++n2) {
                    value = searchRow.getValue(n2);
                    if (value == null) continue;
                    value.set((PreparedStatement)object, n3 + 1);
                    ++n3;
                }
                for (n2 = 0; searchRow2 != null && n2 < searchRow2.getColumnCount(); ++n2) {
                    value = searchRow2.getValue(n2);
                    if (value == null) continue;
                    value.set((PreparedStatement)object, n3 + 1);
                    ++n3;
                }
                ResultSet resultSet = object.executeQuery();
                return new LinkedCursor(this.link, resultSet, session, string, (PreparedStatement)object);
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    private void addParameter(StringBuffer stringBuffer, Column column) {
        if (column.getType() == 21 && this.link.isOracle()) {
            stringBuffer.append("CAST(? AS CHAR(");
            stringBuffer.append(column.getPrecision());
            stringBuffer.append("))");
        } else {
            stringBuffer.append("?");
        }
    }

    public double getCost(Session session, int[] nArray) {
        return 100L + this.getCostRangeIndex(nArray, this.rowCount + 1000L);
    }

    public void remove(Session session) {
    }

    public void truncate(Session session) {
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("LINKED");
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("LINKED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) throws SQLException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.targetTableName);
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuffer.append("AND ");
            }
            object2 = this.table.getColumn(i);
            stringBuffer.append(((Column)object2).getSQL());
            object = row.getValue(i);
            if (this.isNull((Value)object)) {
                stringBuffer.append(" IS NULL ");
                continue;
            }
            stringBuffer.append('=');
            this.addParameter(stringBuffer, (Column)object2);
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        object2 = this.link.getConnection();
        synchronized (object2) {
            try {
                int n;
                object = this.link.getPreparedStatement(string, false);
                int n2 = 0;
                for (n = 0; n < row.getColumnCount(); ++n) {
                    Value value = row.getValue(n);
                    if (this.isNull(value)) continue;
                    value.set((PreparedStatement)object, n2 + 1);
                    ++n2;
                }
                n = object.executeUpdate();
                this.rowCount -= (long)n;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Row row, Row row2) throws SQLException {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(this.targetTableName).append(" SET ");
        for (n = 0; n < row2.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.table.getColumn(n).getSQL()).append("=?");
        }
        stringBuffer.append(" WHERE ");
        for (n = 0; n < row.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append("AND ");
            }
            object = this.table.getColumn(n);
            stringBuffer.append(((Column)object).getSQL());
            Value value = row.getValue(n);
            if (this.isNull(value)) {
                stringBuffer.append(" IS NULL ");
                continue;
            }
            stringBuffer.append('=');
            this.addParameter(stringBuffer, (Column)object);
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        object = this.link.getConnection();
        synchronized (object) {
            try {
                int n2;
                int n3 = 1;
                PreparedStatement preparedStatement = this.link.getPreparedStatement(string, false);
                for (n2 = 0; n2 < row2.getColumnCount(); ++n2) {
                    row2.getValue(n2).set(preparedStatement, n3);
                    ++n3;
                }
                for (n2 = 0; n2 < row.getColumnCount(); ++n2) {
                    Value value = row.getValue(n2);
                    if (this.isNull(value)) continue;
                    value.set(preparedStatement, n3);
                    ++n3;
                }
                n2 = preparedStatement.executeUpdate();
                this.rowCount = this.rowCount + (long)n2 - (long)n2;
            }
            catch (SQLException sQLException) {
                throw this.link.wrapException(string, sQLException);
            }
        }
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

