/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.h2.message.TraceSystem;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 5657650728102821923L;

    public synchronized Enumeration keys() {
        Vector<Object> vector = new Vector<Object>(this.keySet());
        Collections.sort(vector);
        return vector.elements();
    }

    public static boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string, "" + bl);
        try {
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return bl;
        }
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, "" + n);
        try {
            return MathUtils.decodeInt(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SortedProperties loadProperties(String string) throws IOException {
        SortedProperties sortedProperties = new SortedProperties();
        if (FileUtils.exists(string)) {
            InputStream inputStream = null;
            try {
                inputStream = FileUtils.openFileInputStream(string);
                sortedProperties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return sortedProperties;
    }
}

