/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.PageScanIndex;
import org.h2.log.SessionState;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.Cache;
import org.h2.util.Cache2Q;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

public class PageStore
implements CacheWriter {
    public static final int PAGE_SIZE_MIN = 128;
    public static final int PAGE_SIZE_MAX = 32768;
    public static final int PAGE_SIZE_DEFAULT = 1024;
    public static final int LOG_COUNT = 2;
    static final int INCREMENT_PAGES = 128;
    private static final int READ_VERSION = 0;
    private static final int WRITE_VERSION = 0;
    private Database database;
    private final Trace trace;
    private String fileName;
    private FileStore file;
    private String accessMode;
    private int cacheSize;
    private Cache cache;
    private int pageSize;
    private int pageSizeShift;
    private int systemRootPageId;
    private int freeListRootPageId;
    private int lastUsedPage;
    private int activeLog;
    private int[] logRootPageIds = new int[2];
    private boolean recoveryRunning;
    private HashMap sessionStates = new HashMap();
    private long fileLength;
    private int pageCount;
    private PageLog[] logs = new PageLog[2];
    private boolean isNew;
    private TableData pageTable;
    private PageScanIndex pageIndex;

    public PageStore(Database database, String string, String string2, int n) {
        this.fileName = string;
        this.accessMode = string2;
        this.database = database;
        this.trace = database.getTrace("pageStore");
        this.trace.setLevel(3);
        this.cacheSize = n;
        String string3 = database.getCacheType();
        this.cache = "TQ".equals(string3) ? new Cache2Q(this, this.cacheSize) : new CacheLRU(this, this.cacheSize);
    }

    public int copyDirect(int n, OutputStream outputStream) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            byte[] byArray = new byte[this.pageSize];
            try {
                if (n >= this.pageCount) {
                    return -1;
                }
                this.file.seek(n * this.pageSize);
                this.file.readFullyDirect(byArray, 0, this.pageSize);
                outputStream.write(byArray, 0, this.pageSize);
                return n + 1;
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.fileName);
            }
        }
    }

    public void open() throws SQLException {
        try {
            if (FileUtils.exists(this.fileName)) {
                this.file = this.database.openFile(this.fileName, this.accessMode, true);
                this.readHeader();
                this.fileLength = this.file.length();
                this.pageCount = (int)(this.fileLength / (long)this.pageSize);
                this.initLogs();
            } else {
                this.isNew = true;
                this.setPageSize(1024);
                this.file = this.database.openFile(this.fileName, this.accessMode, false);
                this.systemRootPageId = 1;
                this.freeListRootPageId = 2;
                this.pageCount = 5;
                this.increaseFileSize(128 - this.pageCount);
                PageFreeList pageFreeList = this.getFreeList();
                for (int i = 0; i < 2; ++i) {
                    this.logRootPageIds[i] = 3 + i;
                }
                this.writeHeader();
                this.initLogs();
                this.openPageIndex();
                this.getLog().openForWriting(0);
                this.switchLogIfPossible();
                this.getLog().flush();
            }
            this.lastUsedPage = this.getFreeList().getLastUsed() + 1;
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    private void openPageIndex() throws SQLException {
        ObjectArray objectArray = new ObjectArray();
        objectArray.add(new Column("HEAD", 4));
        objectArray.add(new Column("TABLE", 4));
        objectArray.add(new Column("COLUMNS", 13));
        int n = this.getSystemRootPageId();
        this.pageTable = this.database.getMainSchema().createTable("PAGE_INDEX", 0, objectArray, true, false, n);
        this.pageIndex = (PageScanIndex)this.pageTable.getScanIndex(this.database.getSystemSession());
    }

    private void initLogs() {
        for (int i = 0; i < 2; ++i) {
            this.logs[i] = new PageLog(this, this.logRootPageIds[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws SQLException {
        this.trace.debug("checkpoint");
        if (this.getLog() == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            this.database.checkPowerOff();
            ObjectArray objectArray = this.cache.getAllChanged();
            CacheObject.sort(objectArray);
            for (int i = 0; i < objectArray.size(); ++i) {
                Record record = (Record)objectArray.get(i);
                this.writeBack(record);
            }
            this.switchLogIfPossible();
        }
        int n = this.getFreeList().getLastUsed() + 1;
        this.trace.debug("pageCount:" + n);
        this.file.setLength(this.pageSize * n);
    }

    private void switchLogIfPossible() throws SQLException {
        this.trace.debug("switchLogIfPossible");
        int n = this.getLog().getId();
        this.getLog().close();
        this.activeLog = (this.activeLog + 1) % 2;
        this.getLog().openForWriting(n + 1);
    }

    private void readHeader() throws SQLException {
        long l = this.file.length();
        if (l < 128L) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.database.notifyFileSize(l);
        this.file.seek(48L);
        DataPage dataPage = DataPage.create((DataHandler)this.database, new byte[80]);
        this.file.readFully(dataPage.getBytes(), 0, 80);
        this.setPageSize(dataPage.readInt());
        int n = dataPage.readByte();
        int n2 = dataPage.readByte();
        if (n2 != 0) {
            throw Message.getSQLException(90048, this.fileName);
        }
        if (n != 0) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, "close");
            }
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
        this.systemRootPageId = dataPage.readInt();
        this.freeListRootPageId = dataPage.readInt();
        for (int i = 0; i < 2; ++i) {
            this.logRootPageIds[i] = dataPage.readInt();
        }
    }

    public void setPageSize(int n) throws SQLException {
        if (n < 128 || n > 32768) {
            throw Message.getSQLException(90030, this.fileName);
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i <= n; i += i) {
            if (n == i) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.pageSize = n;
        this.pageSizeShift = n2;
    }

    private void writeHeader() throws SQLException {
        DataPage dataPage = DataPage.create((DataHandler)this.database, new byte[this.pageSize - 48]);
        dataPage.writeInt(this.pageSize);
        dataPage.writeByte((byte)0);
        dataPage.writeByte((byte)0);
        dataPage.writeInt(this.systemRootPageId);
        dataPage.writeInt(this.freeListRootPageId);
        for (int i = 0; i < 2; ++i) {
            dataPage.writeInt(this.logRootPageIds[i]);
        }
        this.file.seek(48L);
        this.file.write(dataPage.getBytes(), 0, this.pageSize - 48);
    }

    public void close() throws SQLException {
        try {
            this.trace.debug("close");
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "close");
        }
    }

    public void flushLog() throws SQLException {
    }

    public Trace getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBack(CacheObject cacheObject) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            Record record = (Record)cacheObject;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("writeBack " + record);
            }
            record.write(null);
            record.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(Record record, boolean bl, DataPage dataPage) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            if (this.trace.isDebugEnabled() && !record.isChanged()) {
                this.trace.debug("updateRecord " + record.toString());
            }
            record.setChanged(true);
            int n = record.getPos();
            this.getFreeList().allocate(n);
            this.cache.update(n, record);
            if (bl && !this.recoveryRunning) {
                if (dataPage == null) {
                    dataPage = this.readPage(n);
                }
                this.getLog().addUndo(record.getPos(), dataPage);
            }
        }
    }

    public int allocatePage() throws SQLException {
        return this.allocatePage(false);
    }

    private PageFreeList getFreeList() throws SQLException {
        PageFreeList pageFreeList = (PageFreeList)this.cache.find(this.freeListRootPageId);
        if (pageFreeList == null) {
            pageFreeList = new PageFreeList(this, this.freeListRootPageId, 5);
            pageFreeList.read();
            this.cache.put(pageFreeList);
        }
        return pageFreeList;
    }

    public int allocatePage(boolean bl) throws SQLException {
        int n;
        PageFreeList pageFreeList = this.getFreeList();
        while (true) {
            int n2 = n = bl ? pageFreeList.allocateAtEnd(++this.lastUsedPage) : pageFreeList.allocate();
            if (n >= 0) break;
            this.increaseFileSize(128);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("allocated " + n + " atEnd:" + bl);
        }
        if (n > this.pageCount) {
            this.increaseFileSize(128);
        }
        return n;
    }

    private void increaseFileSize(int n) throws SQLException {
        this.pageCount += n;
        long l = this.pageCount * this.pageSize;
        this.file.setLength(l);
        this.fileLength = l;
    }

    public void freePage(int n) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("freePage " + n);
        }
        this.cache.remove(n);
        this.getFreeList().free(n);
        if (this.recoveryRunning) {
            this.writePage(n, this.createDataPage());
        }
    }

    public DataPage createDataPage() {
        return DataPage.create((DataHandler)this.database, new byte[this.pageSize]);
    }

    public Record getRecord(int n) {
        CacheObject cacheObject = this.cache.find(n);
        return (Record)cacheObject;
    }

    public DataPage readPage(int n) throws SQLException {
        DataPage dataPage = this.createDataPage();
        this.readPage(n, dataPage);
        return dataPage;
    }

    public void readPage(int n, DataPage dataPage) throws SQLException {
        if (n >= this.pageCount) {
            throw Message.getSQLException(90030, n + " of " + this.pageCount);
        }
        this.file.seek(n << this.pageSizeShift);
        this.file.readFully(dataPage.getBytes(), 0, this.pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void writePage(int n, DataPage dataPage) throws SQLException {
        this.file.seek(n << this.pageSizeShift);
        this.file.write(dataPage.getBytes(), 0, this.pageSize);
    }

    public void removeRecord(int n) {
        this.cache.remove(n);
    }

    void setFreeListRootPage(int n, boolean bl, int n2) throws SQLException {
        this.freeListRootPageId = n;
        if (!bl) {
            PageFreeList pageFreeList = new PageFreeList(this, n, n2);
            this.updateRecord(pageFreeList, false, null);
        }
    }

    public int getSystemRootPageId() {
        return this.systemRootPageId;
    }

    PageLog getLog() {
        return this.logs[this.activeLog];
    }

    Database getDatabase() {
        return this.database;
    }

    public void recover() throws SQLException {
        this.recover(true);
        this.openPageIndex();
        this.recover(false);
        this.checkpoint();
    }

    private void recover(boolean bl) throws SQLException {
        this.trace.debug("log recover");
        try {
            int n;
            int n2;
            this.recoveryRunning = true;
            int n3 = 0;
            for (n2 = 0; n2 < 2; ++n2) {
                n = this.logs[n2].openForReading();
                if (n <= n3) continue;
                n3 = n;
                this.activeLog = n2;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                n = bl ? Math.abs(this.activeLog - n2) % 2 : (this.activeLog + 1 + n2) % 2;
                this.logs[n].recover(bl);
            }
            if (!bl) {
                this.switchLogIfPossible();
                this.sessionStates = new HashMap();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        finally {
            this.recoveryRunning = false;
        }
        this.trace.debug("log recover done");
    }

    public void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        if (!this.recoveryRunning) {
            this.getLog().logAddOrRemoveRow(session, n, row, bl);
        }
    }

    public void commit(Session session) throws SQLException {
        this.getLog().commit(session);
    }

    private SessionState getOrAddSessionState(int n) {
        Integer n2 = ObjectUtils.getInteger(n);
        SessionState sessionState = (SessionState)this.sessionStates.get(n2);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessionStates.put(n2, sessionState);
            sessionState.sessionId = n;
        }
        return sessionState;
    }

    void setLastCommitForSession(int n, int n2, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        sessionState.lastCommitLog = n2;
        sessionState.lastCommitPos = n3;
        sessionState.inDoubtTransaction = null;
    }

    boolean isSessionCommitted(int n, int n2, int n3) {
        Integer n4 = ObjectUtils.getInteger(n);
        SessionState sessionState = (SessionState)this.sessionStates.get(n4);
        if (sessionState == null) {
            return true;
        }
        return sessionState.isCommitted(n2, n3);
    }

    public int getMetaTableHeadPos() {
        return 0;
    }
}

