/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexModifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.h2.api.CloseListener;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.fulltext.FullText;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.fs.FileSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class FullTextLucene
extends FullText {
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private static final boolean STORE_DOCUMENT_TEXT_IN_INDEX = Boolean.getBoolean("h2.storeDocumentTextInIndex");
    private static final HashMap INDEX_MODIFIERS = new HashMap();
    private static final String FIELD_DATA = "DATA";
    private static final String FIELD_COLUMN_PREFIX = "_";
    private static final String FIELD_QUERY = "QUERY";
    static /* synthetic */ Class class$org$h2$fulltext$FullTextLucene;
    static /* synthetic */ Class class$org$h2$fulltext$FullTextLucene$FullTextTrigger;

    public static void init(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA IF NOT EXISTS FTL");
        statement.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, TABLE))");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR \"" + (class$org$h2$fulltext$FullTextLucene == null ? (class$org$h2$fulltext$FullTextLucene = FullTextLucene.class$("org.h2.fulltext.FullTextLucene")) : class$org$h2$fulltext$FullTextLucene).getName() + ".createIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR \"" + (class$org$h2$fulltext$FullTextLucene == null ? (class$org$h2$fulltext$FullTextLucene = FullTextLucene.class$("org.h2.fulltext.FullTextLucene")) : class$org$h2$fulltext$FullTextLucene).getName() + ".search\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH_DATA FOR \"" + (class$org$h2$fulltext$FullTextLucene == null ? (class$org$h2$fulltext$FullTextLucene = FullTextLucene.class$("org.h2.fulltext.FullTextLucene")) : class$org$h2$fulltext$FullTextLucene).getName() + ".searchData\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR \"" + (class$org$h2$fulltext$FullTextLucene == null ? (class$org$h2$fulltext$FullTextLucene = FullTextLucene.class$("org.h2.fulltext.FullTextLucene")) : class$org$h2$fulltext$FullTextLucene).getName() + ".reindex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR \"" + (class$org$h2$fulltext$FullTextLucene == null ? (class$org$h2$fulltext$FullTextLucene = FullTextLucene.class$("org.h2.fulltext.FullTextLucene")) : class$org$h2$fulltext$FullTextLucene).getName() + ".dropAll\"");
        try {
            FullTextLucene.getIndexModifier(connection);
        }
        catch (Exception exception) {
            throw FullTextLucene.convertException(exception);
        }
    }

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        FullTextLucene.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.execute();
        FullTextLucene.createTrigger(connection, string, string2);
        FullTextLucene.indexExistingRows(connection, string, string2);
    }

    public static void reindex(Connection connection) throws SQLException {
        FullTextLucene.init(connection);
        FullTextLucene.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FTL.INDEXES");
        while (resultSet.next()) {
            String string = resultSet.getString("SCHEMA");
            String string2 = resultSet.getString("TABLE");
            FullTextLucene.createTrigger(connection, string, string2);
            FullTextLucene.indexExistingRows(connection, string, string2);
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("DROP SCHEMA IF EXISTS FTL");
        FullTextLucene.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(connection);
    }

    public static ResultSet search(Connection connection, String string, int n, int n2) throws SQLException {
        return FullTextLucene.search(connection, string, n, n2, false);
    }

    public static ResultSet searchData(Connection connection, String string, int n, int n2) throws SQLException {
        return FullTextLucene.search(connection, string, n, n2, true);
    }

    private static SQLException convertException(Exception exception) {
        SQLException sQLException = new SQLException("FULLTEXT", "Error while indexing document");
        sQLException.initCause(exception);
        return sQLException;
    }

    private static void createTrigger(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        String string3 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + string2);
        statement.execute("DROP TRIGGER IF EXISTS " + string3);
        StringBuffer stringBuffer = new StringBuffer("CREATE TRIGGER IF NOT EXISTS ");
        stringBuffer.append(string3);
        stringBuffer.append(" AFTER INSERT, UPDATE, DELETE ON ");
        stringBuffer.append(StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2));
        stringBuffer.append(" FOR EACH ROW CALL \"");
        stringBuffer.append((class$org$h2$fulltext$FullTextLucene$FullTextTrigger == null ? (class$org$h2$fulltext$FullTextLucene$FullTextTrigger = FullTextLucene.class$("org.h2.fulltext.FullTextLucene$FullTextTrigger")) : class$org$h2$fulltext$FullTextLucene$FullTextTrigger).getName());
        stringBuffer.append("\"");
        statement.execute(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexModifier getIndexModifier(Connection connection) throws SQLException {
        IndexModifier indexModifier;
        String string = FullTextLucene.getIndexPath(connection);
        HashMap hashMap = INDEX_MODIFIERS;
        synchronized (hashMap) {
            indexModifier = (IndexModifier)INDEX_MODIFIERS.get(string);
            if (indexModifier == null) {
                try {
                    boolean bl = !IndexReader.indexExists((String)string);
                    StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
                    indexModifier = new IndexModifier(string, (Analyzer)standardAnalyzer, bl);
                }
                catch (IOException iOException) {
                    throw FullTextLucene.convertException(iOException);
                }
                INDEX_MODIFIERS.put(string, indexModifier);
            }
        }
        return indexModifier;
    }

    private static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL DATABASE_PATH()");
        resultSet.next();
        String string = resultSet.getString(1);
        if (string == null) {
            throw new SQLException("FULLTEXT", "Fulltext search for in-memory databases is not supported.");
        }
        resultSet.close();
        return string;
    }

    private static void indexExistingRows(Connection connection, String string, String string2) throws SQLException {
        FullTextTrigger fullTextTrigger = new FullTextTrigger();
        fullTextTrigger.init(connection, string, null, string2, false, 1);
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
        stringBuffer.append(StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2));
        ResultSet resultSet = connection.createStatement().executeQuery(stringBuffer.toString());
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            fullTextTrigger.fire(connection, null, objectArray);
        }
    }

    private static void removeIndexFiles(Connection connection) throws SQLException {
        String string = FullTextLucene.getIndexPath(connection);
        IndexModifier indexModifier = (IndexModifier)INDEX_MODIFIERS.get(string);
        if (indexModifier != null) {
            INDEX_MODIFIERS.remove(string);
            try {
                indexModifier.flush();
                indexModifier.close();
            }
            catch (IOException iOException) {
                throw FullTextLucene.convertException(iOException);
            }
        }
        FileSystem.getInstance(string).deleteRecursive(string);
    }

    private static ResultSet search(Connection connection, String string, int n, int n2, boolean bl) throws SQLException {
        SimpleResultSet simpleResultSet = FullTextLucene.createResultSet(bl);
        if (connection.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return simpleResultSet;
        }
        String string2 = FullTextLucene.getIndexPath(connection);
        try {
            IndexModifier indexModifier = FullTextLucene.getIndexModifier(connection);
            indexModifier.flush();
            IndexReader indexReader = IndexReader.open((String)string2);
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            QueryParser queryParser = new QueryParser(FIELD_DATA, (Analyzer)standardAnalyzer);
            Query query = queryParser.parse(string);
            Hits hits = indexSearcher.search(query);
            int n3 = hits.length();
            if (n == 0) {
                n = n3;
            }
            for (int i = 0; i < n && i + n2 < n3; ++i) {
                Document document = hits.doc(i + n2);
                String string3 = document.get(FIELD_QUERY);
                if (bl) {
                    int n4 = string3.indexOf(" WHERE ");
                    JdbcConnection jdbcConnection = (JdbcConnection)connection;
                    Session session = (Session)jdbcConnection.getSession();
                    Parser parser = new Parser(session);
                    String string4 = string3.substring(0, n4);
                    ExpressionColumn expressionColumn = (ExpressionColumn)parser.parseExpression(string4);
                    String string5 = expressionColumn.getOriginalTableAliasName();
                    String string6 = expressionColumn.getColumnName();
                    string3 = string3.substring(n4 + " WHERE ".length());
                    Object[][] objectArray = FullTextLucene.parseKey(connection, string3);
                    Object[] objectArray2 = new Object[]{string5, string6, objectArray[0], objectArray[1]};
                    simpleResultSet.addRow(objectArray2);
                    continue;
                }
                simpleResultSet.addRow(new Object[]{string3});
            }
            indexReader.close();
        }
        catch (Exception exception) {
            throw FullTextLucene.convertException(exception);
        }
        return simpleResultSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FullTextTrigger
    implements Trigger,
    CloseListener {
        private String schema;
        private String table;
        private int[] keys;
        private int[] indexColumns;
        private String[] columns;
        private int[] columnTypes;
        private String indexPath;
        private IndexModifier indexModifier;

        public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
            String string4;
            this.schema = string;
            this.table = string3;
            this.indexPath = FullTextLucene.getIndexPath(connection);
            this.indexModifier = FullTextLucene.getIndexModifier(connection);
            ArrayList<String> arrayList = new ArrayList<String>();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[arrayList2.size()];
            this.columns = new String[arrayList2.size()];
            arrayList2.toArray(this.columns);
            resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            int n2 = 0;
            while (resultSet.next()) {
                this.columnTypes[n2] = resultSet.getInt("DATA_TYPE");
                ++n2;
            }
            if (arrayList.size() == 0) {
                resultSet = databaseMetaData.getPrimaryKeys(null, JdbcUtils.escapeMetaDataPattern(string), string3);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("COLUMN_NAME"));
                }
            }
            if (arrayList.size() == 0) {
                throw new SQLException("No primary key for table " + string3);
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (string4 = resultSet.getString(1)) != null) {
                String[] stringArray = StringUtils.arraySplit(string4, ',', true);
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList3.add(stringArray[i]);
                }
            }
            if (arrayList3.size() == 0) {
                arrayList3.addAll(arrayList2);
            }
            this.keys = new int[arrayList.size()];
            FullText.setColumns(this.keys, arrayList, arrayList2);
            this.indexColumns = new int[arrayList3.size()];
            FullText.setColumns(this.indexColumns, arrayList3, arrayList2);
        }

        public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
            if (objectArray != null) {
                this.delete(objectArray);
            }
            if (objectArray2 != null) {
                this.insert(objectArray2);
            }
        }

        public void close() throws SQLException {
            if (this.indexModifier != null) {
                try {
                    this.indexModifier.flush();
                    this.indexModifier.close();
                    INDEX_MODIFIERS.remove(this.indexPath);
                    this.indexModifier = null;
                }
                catch (Exception exception) {
                    throw FullTextLucene.convertException(exception);
                }
            }
        }

        public void remove() {
        }

        private void insert(Object[] objectArray) throws SQLException {
            String string = this.getQuery(objectArray);
            Document document = new Document();
            document.add((Fieldable)new Field(FullTextLucene.FIELD_QUERY, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
            long l = System.currentTimeMillis();
            document.add((Fieldable)new Field("modified", DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.indexColumns.length; ++i) {
                int n = this.indexColumns[i];
                String string2 = this.columns[n];
                String string3 = FullText.asString(objectArray[n], this.columnTypes[n]);
                document.add((Fieldable)new Field(FullTextLucene.FIELD_COLUMN_PREFIX + string2, string3, Field.Store.NO, Field.Index.TOKENIZED));
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            Field.Store store = STORE_DOCUMENT_TEXT_IN_INDEX ? Field.Store.YES : Field.Store.NO;
            document.add((Fieldable)new Field(FullTextLucene.FIELD_DATA, stringBuffer.toString(), store, Field.Index.TOKENIZED));
            try {
                this.indexModifier.addDocument(document);
            }
            catch (IOException iOException) {
                throw FullTextLucene.convertException(iOException);
            }
        }

        private void delete(Object[] objectArray) throws SQLException {
            String string = this.getQuery(objectArray);
            try {
                Term term = new Term(FullTextLucene.FIELD_QUERY, string);
                this.indexModifier.deleteDocuments(term);
            }
            catch (IOException iOException) {
                throw FullTextLucene.convertException(iOException);
            }
        }

        private String getQuery(Object[] objectArray) throws SQLException {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.schema != null) {
                stringBuffer.append(StringUtils.quoteIdentifier(this.schema));
                stringBuffer.append(".");
            }
            stringBuffer.append(StringUtils.quoteIdentifier(this.table));
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < this.keys.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" AND ");
                }
                int n = this.keys[i];
                stringBuffer.append(StringUtils.quoteIdentifier(this.columns[n]));
                Object object = objectArray[n];
                if (object == null) {
                    stringBuffer.append(" IS NULL");
                    continue;
                }
                stringBuffer.append("=");
                stringBuffer.append(FullText.quoteSQL(object, this.columnTypes[n]));
            }
            String string = stringBuffer.toString();
            return string;
        }
    }
}

