/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.util.IntArray;

public class PageFreeList
extends Record {
    private final PageStore store;
    private final DataPage page;
    private final IntArray array = new IntArray();
    private int nextPage;

    PageFreeList(PageStore pageStore, int n, int n2) {
        this.setPos(n);
        this.page = pageStore.createDataPage();
        this.store = pageStore;
        this.nextPage = n2;
    }

    int allocate() throws SQLException {
        int n = this.array.size();
        if (n > 0) {
            int n2 = this.array.get(n - 1);
            this.array.remove(n - 1);
            return n2;
        }
        this.store.updateRecord(this);
        this.store.setFreeListRootPage(this.nextPage, true, 0);
        return this.getPos();
    }

    private int getMaxSize() {
        return (this.store.getPageSize() - 9) / 4;
    }

    void read() throws SQLException {
        int n;
        boolean bl;
        this.store.readPage(this.getPos(), this.page);
        int n2 = this.page.readInt();
        int n3 = this.page.readByte();
        boolean bl2 = bl = (n3 & 0x10) != 0;
        if ((n3 &= 0xFFFFFFEF) != 4 || n2 != 0) {
            throw Message.getSQLException(90030, "type:" + n3 + " parent:" + n2 + " expected type:" + 4);
        }
        if (bl) {
            this.nextPage = 0;
            n = this.page.readInt();
        } else {
            this.nextPage = this.page.readInt();
            n = this.getMaxSize();
        }
        for (int i = 0; i < n; ++i) {
            this.array.add(this.page.readInt());
        }
    }

    void free(int n) throws SQLException {
        this.store.updateRecord(this);
        if (this.array.size() < this.getMaxSize()) {
            this.array.add(n);
        } else {
            this.nextPage = n;
            this.store.setFreeListRootPage(n, false, this.getPos());
        }
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.page.reset();
        this.page.writeInt(0);
        int n = 4;
        if (this.nextPage == 0) {
            n |= 0x10;
        }
        this.page.writeByte((byte)n);
        if (this.nextPage != 0) {
            this.page.writeInt(this.nextPage);
        } else {
            this.page.writeInt(this.array.size());
        }
        for (int i = 0; i < this.array.size(); ++i) {
            this.page.writeInt(this.array.get(i));
        }
    }
}

