/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

public class RuleElement
implements Rule {
    private boolean keyword;
    private String name;
    private Rule link;
    private int type;

    RuleElement(String string, String string2) {
        this.name = string;
        if (string.length() == 1 || string.equals(StringUtils.toUpperEnglish(string))) {
            this.keyword = true;
        }
        this.type = (string2 = StringUtils.toLowerEnglish(string2)).startsWith("function") ? 2 : 1;
    }

    public String toString() {
        return this.name;
    }

    public String random(Bnf bnf, int n) {
        if (this.keyword) {
            return this.name.length() > 1 ? " " + this.name + " " : this.name;
        }
        if (this.link != null) {
            return this.link.random(bnf, n + 1);
        }
        throw new Error(">>>" + this.name + "<<<");
    }

    public String name() {
        return this.name;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap hashMap) {
        if (this.link != null) {
            this.link.setLinks(hashMap);
        }
        if (this.keyword) {
            return;
        }
        for (int i = 0; i < this.name.length() && this.link == null; ++i) {
            String string = StringUtils.toLowerEnglish(this.name.substring(i));
            RuleHead ruleHead = (RuleHead)hashMap.get(string);
            if (ruleHead == null) continue;
            this.link = ruleHead.getRule();
            return;
        }
        if (this.link == null) {
            throw new Error(">>>" + this.name + "<<<");
        }
    }

    public boolean matchRemove(Sentence sentence) {
        if (sentence.shouldStop()) {
            return false;
        }
        String string = sentence.getQuery();
        if (string.length() == 0) {
            return false;
        }
        if (this.keyword) {
            String string2 = sentence.getQueryUpper();
            if (string2.startsWith(this.name)) {
                string = string.substring(this.name.length());
                while (!"_".equals(this.name) && string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
                    string = string.substring(1);
                }
                sentence.setQuery(string);
                return true;
            }
            return false;
        }
        if (!this.link.matchRemove(sentence)) {
            return false;
        }
        if (!(this.name == null || this.name.startsWith("@") || this.link.name() != null && this.link.name().startsWith("@"))) {
            string = sentence.getQuery();
            while (string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
                string = string.substring(1);
            }
            sentence.setQuery(string);
        }
        return true;
    }

    public void addNextTokenList(Sentence sentence) {
        if (sentence.shouldStop()) {
            return;
        }
        if (this.keyword) {
            String string = sentence.getQuery();
            String string2 = string.trim();
            String string3 = sentence.getQueryUpper().trim();
            if ((string2.length() == 0 || this.name.startsWith(string3)) && string2.length() < this.name.length()) {
                sentence.add(this.name, this.name.substring(string2.length()), this.type);
            }
            return;
        }
        this.link.addNextTokenList(sentence);
    }
}

