/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ObjectUtils;
import org.h2.value.Value;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private JdbcConnection conn;

    JdbcArray(SessionInterface sessionInterface, JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(sessionInterface.getTrace(), 15, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + this.quoteMap(map) + ");");
            this.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(long l, int n) throws SQLException {
        try {
            this.debugCode("getArray(" + l + ", " + n + ");");
            this.checkClosed();
            return this.get(l, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + l + ", " + n + ", " + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.get(l, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return this.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.getResultSet(this.get(), 0L);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l + ", " + n + ");");
            this.checkClosed();
            return this.getResultSet(this.get(l, n), l);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + l + ", " + n + ", " + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.getResultSet(this.get(l, n), l);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private ResultSet getResultSet(Object[] objectArray, long l) throws SQLException {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("INDEX", -5, 0, 0);
        simpleResultSet.addColumn("VALUE", 0, 0, 0);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = new Object[]{ObjectUtils.getLong(l + (long)i + 1L), objectArray[i]};
            simpleResultSet.addRow(objectArray2);
        }
        return simpleResultSet;
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }

    private Object[] get() throws SQLException {
        return (Object[])this.value.convertTo(17).getObject();
    }

    private Object[] get(long l, int n) throws SQLException {
        Object[] objectArray = this.get();
        if (n < 0 || n > objectArray.length) {
            throw Message.getInvalidValueException("" + n, "count (1.." + objectArray.length + ")");
        }
        if (l < 1L || l > (long)objectArray.length) {
            throw Message.getInvalidValueException("" + l, "index (1.." + objectArray.length + ")");
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, (int)(l - 1L), objectArray2, 0, n);
        return objectArray2;
    }

    private void checkMap(Map map) throws SQLException {
        if (map != null && map.size() > 0) {
            throw Message.getUnsupportedException();
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

