/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.LogSystem;
import org.h2.log.RedoLogRecord;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DataPageText;
import org.h2.store.FileStore;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.util.BitField;
import org.h2.util.ByteUtils;
import org.h2.util.Cache;
import org.h2.util.Cache2Q;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

public class DiskFile
implements CacheWriter {
    public static final int BLOCK_PAGE_PAGE_SHIFT = 6;
    public static final int BLOCKS_PER_PAGE = 64;
    public static final int BLOCK_SIZE = 128;
    private static final int OFFSET = 48;
    private static final int FREE_PAGE = -1;
    private Database database;
    private String fileName;
    private FileStore file;
    private BitField used;
    private BitField deleted;
    private HashSet potentiallyFreePages;
    private int fileBlockCount;
    private IntArray pageOwners;
    private Cache cache;
    private LogSystem log;
    private DataPage rowBuff;
    private DataPage freeBlock;
    private boolean dataFile;
    private boolean logChanges;
    private int recordOverhead;
    private boolean init;
    private boolean initAlreadyTried;
    private ObjectArray redoBuffer;
    private int redoBufferSize;
    private int readCount;
    private int writeCount;
    private String mode;
    private int nextDeleteId = 1;

    public DiskFile(Database database, String string, String string2, boolean bl, boolean bl2, int n) throws SQLException {
        this.reset();
        this.database = database;
        this.log = database.getLog();
        this.fileName = string;
        this.mode = string2;
        this.dataFile = bl;
        this.logChanges = bl2;
        String string3 = database.getCacheType();
        this.cache = "TQ".equals(string3) ? new Cache2Q(this, n) : new CacheLRU(this, n);
        this.rowBuff = DataPage.create((DataHandler)database, 128);
        this.recordOverhead = 4 * this.rowBuff.getIntLen() + 1 + this.rowBuff.getFillerLength();
        this.freeBlock = DataPage.create((DataHandler)database, 128);
        this.freeBlock.fill(128);
        this.freeBlock.updateChecksum();
        try {
            if (FileUtils.exists(string)) {
                this.file = database.openFile(string, string2, true);
                long l = this.file.length();
                database.notifyFileSize(l);
                int n2 = (int)((l - 48L) / 128L);
                this.setBlockCount(n2);
            } else {
                this.create();
            }
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    private void reset() {
        this.used = new BitField();
        this.deleted = new BitField();
        this.pageOwners = new IntArray();
        this.setBlockCount(this.fileBlockCount);
        this.redoBuffer = new ObjectArray();
        this.potentiallyFreePages = new HashSet();
    }

    private void setBlockCount(int n) {
        this.fileBlockCount = n;
        int n2 = this.getPage(n);
        while (n2 >= this.pageOwners.size()) {
            this.pageOwners.add(-1);
        }
    }

    private void create() throws SQLException {
        this.file = this.database.openFile(this.fileName, this.mode, false);
        DataPage dataPage = DataPage.create((DataHandler)this.database, 48);
        this.file.seek(48L);
        dataPage.fill(48);
        dataPage.updateChecksum();
        this.file.write(dataPage.getBytes(), 0, 48);
    }

    private void freeUnusedPages() throws SQLException {
        int n;
        IntArray intArray = new IntArray();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.pageOwners.size(); ++i) {
            n = this.pageOwners.get(i);
            if (n == -1 || !this.isPageFree(i)) continue;
            hashSet.add(ObjectUtils.getInteger(n));
            intArray.add(i);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            this.database.getStorage(n, this).removePages(intArray);
        }
        for (int i = 0; i < intArray.size(); ++i) {
            n = intArray.get(i);
            this.setPageOwner(n, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSummary() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n2 = (int)((this.file.length() - 48L) / 128L);
                dataOutputStream.writeInt(n2);
                int n3 = 0;
                for (int i = 0; i < n2 / 8; ++i) {
                    n = 0;
                    for (int j = 0; j < 8; ++j) {
                        if (this.used.get(n3)) {
                            n |= 1 << j;
                        }
                        ++n3;
                    }
                    dataOutputStream.write(n);
                }
                dataOutputStream.writeInt(this.pageOwners.size());
                ObjectArray objectArray = new ObjectArray();
                for (n3 = 0; n3 < this.pageOwners.size(); ++n3) {
                    n = this.pageOwners.get(n3);
                    dataOutputStream.writeInt(n);
                    if (n < 0 || n < objectArray.size() && objectArray.get(n) != null) continue;
                    Storage storage = this.database.getStorage(n, this);
                    while (objectArray.size() <= n) {
                        objectArray.add(null);
                    }
                    objectArray.set(n, storage);
                }
                for (n3 = 0; n3 < objectArray.size(); ++n3) {
                    Storage storage = (Storage)objectArray.get(n3);
                    if (storage == null) continue;
                    dataOutputStream.writeInt(n3);
                    dataOutputStream.writeInt(storage.getRecordCount());
                }
                dataOutputStream.writeInt(-1);
                dataOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    boolean isPageFree(int n) {
        for (int i = n * 64; i < (n + 1) * 64; ++i) {
            if (!this.used.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFromSummary(byte[] byArray) {
        Database database = this.database;
        synchronized (database) {
            if (byArray == null || byArray.length == 0) {
                ObjectArray objectArray = this.database.getAllStorages();
                for (int i = 0; i < objectArray.size(); ++i) {
                    Storage storage = (Storage)objectArray.get(i);
                    if (storage == null || storage.getDiskFile() != this) continue;
                    this.database.removeStorage(storage.getId(), this);
                }
                this.reset();
                this.initAlreadyTried = false;
                this.init = false;
                return;
            }
            if (this.database.getRecovery() || this.initAlreadyTried && (!this.dataFile || !SysProperties.CHECK)) {
                return;
            }
            this.initAlreadyTried = true;
            int n = 0;
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n6 = dataInputStream.readInt();
                if (n6 > this.fileBlockCount) {
                    this.database.getTrace("database").info("unexpected size " + n6 + " when initializing summary for " + this.fileName + " expected:" + this.fileBlockCount);
                    return;
                }
                ++n;
                if (this.init) {
                    for (n5 = 0; n5 < n6; n5 += 8) {
                        n4 = dataInputStream.read();
                        if (n4 == this.used.getByte(n5)) continue;
                        throw Message.getInternalError("Redo failure, block: " + n5 + " expected: " + this.used.getByte(n5) + " got: " + n4);
                    }
                } else {
                    for (n5 = 0; n5 < n6; n5 += 8) {
                        n4 = dataInputStream.read();
                        this.used.setByte(n5, n4);
                    }
                }
                ++n;
                n5 = dataInputStream.readInt();
                ObjectArray objectArray = new ObjectArray();
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = dataInputStream.readInt();
                    while (objectArray.size() <= n2) {
                        objectArray.add(null);
                    }
                    if (this.init) {
                        int n7 = this.getPageOwner(n3);
                        if (n7 == -1 || n7 == n2) continue;
                        throw Message.getInternalError("Redo failure, expected page owner: " + n7 + " got: " + n2);
                    }
                    if (n2 >= 0) {
                        Storage storage = this.database.getStorage(n2, this);
                        objectArray.set(n2, storage);
                        storage.addPage(n3);
                    }
                    this.setPageOwner(n3, n2);
                }
                ++n;
                while ((n3 = dataInputStream.readInt()) >= 0) {
                    n2 = dataInputStream.readInt();
                    Storage storage = (Storage)objectArray.get(n3);
                    if (this.init) {
                        int n8;
                        if (storage == null || (n8 = storage.getRecordCount()) == n2) continue;
                        throw Message.getInternalError("Redo failure, expected row count: " + n8 + " got: " + n2);
                    }
                    storage.setRecordCount(n2);
                }
                ++n;
                this.freeUnusedPages();
                this.init = true;
            }
            catch (Throwable throwable) {
                this.database.getTrace("database").error("error initializing summary for " + this.fileName + " size:" + byArray.length + " stage:" + n, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            Object object;
            int n;
            if (this.init) {
                return;
            }
            ObjectArray objectArray = this.database.getAllStorages();
            for (n = 0; n < objectArray.size(); ++n) {
                object = (Storage)objectArray.get(n);
                if (object == null || ((Storage)object).getDiskFile() != this) continue;
                ((Storage)object).setRecordCount(0);
            }
            n = Math.max(16, 2 * this.rowBuff.getIntLen());
            object = new byte[n];
            DataPage dataPage = DataPage.create((DataHandler)this.database, (byte[])object);
            long l = 0L;
            int n2 = 0;
            while (n2 < this.fileBlockCount) {
                long l2 = System.currentTimeMillis();
                if (l2 > l + 10L) {
                    l = l2;
                    this.database.setProgress(0, this.fileName, n2, this.fileBlockCount);
                }
                this.go(n2);
                this.file.readFully((byte[])object, 0, n);
                dataPage.reset();
                int n3 = dataPage.readInt();
                if (SysProperties.CHECK && n3 < 0) {
                    throw Message.getInternalError();
                }
                if (n3 == 0) {
                    this.setUnused(null, n2, 1);
                    ++n2;
                    continue;
                }
                int n4 = dataPage.readInt();
                if (SysProperties.CHECK && n4 < 0) {
                    throw Message.getInternalError();
                }
                Storage storage = this.database.getStorage(n4, this);
                this.setUnused(null, n2, n3);
                this.setBlockOwner(null, storage, n2, n3, true);
                storage.incrementRecordCount();
                n2 += n3;
            }
            this.database.setProgress(0, this.fileName, this.fileBlockCount, this.fileBlockCount);
            this.init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            int n;
            this.database.checkPowerOff();
            ObjectArray objectArray = this.cache.getAllChanged();
            CacheObject.sort(objectArray);
            for (n = 0; n < objectArray.size(); ++n) {
                Record record = (Record)objectArray.get(n);
                this.writeBack(record);
            }
            for (n = 0; n < this.fileBlockCount && (n = this.deleted.nextSetBit(n)) >= 0; ++n) {
                if (!this.deleted.get(n)) continue;
                this.writeDirectDeleted(n, 1);
                this.deleted.clear(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            SQLException sQLException = null;
            if (!this.database.getReadOnly()) {
                try {
                    this.flush();
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                }
            }
            this.cache.clear();
            if (this.file != null) {
                this.file.closeSilently();
                this.file = null;
            }
            if (sQLException != null) {
                throw sQLException;
            }
            this.writeCount = 0;
            this.readCount = 0;
        }
    }

    private void go(int n) throws SQLException {
        this.database.checkPowerOff();
        this.file.seek(this.getFilePos(n));
    }

    private long getFilePos(int n) {
        return (long)n * 128L + 48L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Record getRecordIfStored(Session session, int n, RecordReader recordReader, int n2) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            try {
                int n3 = this.getPageOwner(this.getPage(n));
                if (n3 != n2) {
                    return null;
                }
                this.go(n);
                this.rowBuff.reset();
                byte[] byArray = this.rowBuff.getBytes();
                this.file.readFully(byArray, 0, 128);
                DataPage dataPage = DataPage.create((DataHandler)this.database, byArray);
                dataPage.readInt();
                int n4 = dataPage.readInt();
                if (n4 != n2) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            return this.getRecord(session, n, recordReader, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Record getRecord(Session session, int n, RecordReader recordReader, int n2) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            Object object;
            if (this.file == null) {
                throw Message.getSQLException(90098);
            }
            Record record = (Record)this.cache.get(n);
            if (record != null) {
                return record;
            }
            ++this.readCount;
            this.go(n);
            this.rowBuff.reset();
            byte[] byArray = this.rowBuff.getBytes();
            this.file.readFully(byArray, 0, 128);
            DataPage dataPage = DataPage.create((DataHandler)this.database, byArray);
            int n3 = dataPage.readInt();
            int n4 = dataPage.readInt();
            if (n2 != n4) {
                throw Message.getInternalError("File ID mismatch got=" + n4 + " expected=" + n2 + " pos=" + n + " " + this.logChanges + " " + this + " blockCount:" + n3);
            }
            if (n3 == 0) {
                throw Message.getInternalError("0 blocks to read pos=" + n);
            }
            if (n3 > 1) {
                object = ByteUtils.newBytes(n3 * 128);
                System.arraycopy(byArray, 0, object, 0, 128);
                byArray = object;
                this.file.readFully(byArray, 128, n3 * 128 - 128);
                dataPage = DataPage.create((DataHandler)this.database, byArray);
                dataPage.readInt();
                dataPage.readInt();
            }
            dataPage.check(n3 * 128);
            object = recordReader.read(session, dataPage);
            ((Record)object).setStorageId(n2);
            ((CacheObject)object).setPos(n);
            ((CacheObject)object).setBlockCount(n3);
            this.cache.put((CacheObject)object);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int allocate(Storage storage, int n) throws SQLException {
        this.reuseSpace();
        Database database = this.database;
        synchronized (database) {
            int n2;
            if (this.file == null) {
                throw Message.getSQLException(90098);
            }
            n = this.getPage(n + 64 - 1) * 64;
            int n3 = this.getPage(this.fileBlockCount);
            int n4 = this.getPage(n);
            int n5 = -1;
            boolean bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                bl = true;
                for (int i = n2; i < n2 + n4; ++i) {
                    if (i < n3 && this.getPageOwner(i) == -1) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                n5 = n2 * 64;
                break;
            }
            if (!bl) {
                n2 = this.fileBlockCount;
                n5 = MathUtils.roundUp(n2, 64);
                if (this.rowBuff instanceof DataPageText) {
                    if (n5 > n2) {
                        this.writeDirectDeleted(n2, n5 - n2);
                    }
                    this.writeDirectDeleted(n5, n);
                } else {
                    long l = ((long)n5 + (long)n) * 128L;
                    if ((l = MathUtils.scaleUp50Percent(131072L, l, 8192L, 0x2000000L) + 48L) > this.file.length()) {
                        this.file.setLength(l);
                        this.database.notifyFileSize(l);
                    }
                }
            }
            this.setBlockOwner(null, storage, n5, n, false);
            for (n2 = 0; n2 < n; ++n2) {
                storage.free(n2 + n5, 1);
            }
            return n5;
        }
    }

    private void setBlockOwner(Session session, Storage storage, int n, int n2, boolean bl) throws SQLException {
        if (n + n2 > this.fileBlockCount) {
            this.setBlockCount(n + n2);
        }
        if (!bl) {
            this.setUnused(session, n, n2);
        }
        for (int i = this.getPage(n); i <= this.getPage(n + n2 - 1); ++i) {
            this.setPageOwner(i, storage.getId());
        }
        if (bl) {
            this.used.setRange(n, n2, true);
            this.deleted.setRange(n, n2, false);
        }
    }

    private void setUnused(Session session, int n, int n2) throws SQLException {
        if (n + n2 > this.fileBlockCount) {
            this.setBlockCount(n + n2);
        }
        this.uncommittedDelete(session);
        for (int i = n; i < n + n2; ++i) {
            this.used.clear(i);
            if (i % 64 != 0 || n + n2 < i + 64) continue;
            this.freePage(this.getPage(i));
        }
    }

    private void reuseSpace() throws SQLException {
        if (SysProperties.REUSE_SPACE_QUICKLY && this.potentiallyFreePages.size() >= SysProperties.REUSE_SPACE_AFTER) {
            int n;
            Session[] sessionArray = this.database.getSessions(true);
            int n2 = 0;
            for (int i = 0; i < sessionArray.length; ++i) {
                n = sessionArray[i].getLastUncommittedDelete();
                if (n2 != 0 && (n == 0 || n >= n2)) continue;
                n2 = n;
            }
            Iterator iterator = this.potentiallyFreePages.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                if (n2 != 0) continue;
                if (this.isPageFree(n)) {
                    this.setPageOwner(n, -1);
                }
                iterator.remove();
            }
        }
    }

    void uncommittedDelete(Session session) {
        int n;
        if (session != null && this.logChanges && SysProperties.REUSE_SPACE_QUICKLY && ((n = session.getLastUncommittedDelete()) == 0 || n < this.nextDeleteId)) {
            n = ++this.nextDeleteId;
            session.setLastUncommittedDelete(n);
        }
    }

    void freePage(int n) throws SQLException {
        if (!this.logChanges) {
            this.setPageOwner(n, -1);
        } else if (SysProperties.REUSE_SPACE_QUICKLY) {
            this.potentiallyFreePages.add(ObjectUtils.getInteger(n));
        }
    }

    int getPage(int n) {
        return n >>> 6;
    }

    int getPageOwner(int n) {
        if (n * 64 > this.fileBlockCount || n >= this.pageOwners.size()) {
            return -1;
        }
        return this.pageOwners.get(n);
    }

    public void setPageOwner(int n, int n2) throws SQLException {
        int n3 = this.pageOwners.get(n);
        if (n3 == n2) {
            return;
        }
        if (SysProperties.CHECK && n3 >= 0 && n2 >= 0 && n3 != n2) {
            for (int i = 0; i < 64; ++i) {
                if (!this.used.get(i + n * 64)) continue;
                throw Message.getInternalError("double allocation in file " + this.fileName + " page " + n + " blocks " + 64 * n + "-" + (64 * (n + 1) - 1));
            }
        }
        if (n3 >= 0) {
            this.database.getStorage(n3, this).removePage(n);
            if (!this.logChanges) {
                this.writeDirectDeleted(n * 64, 64);
            }
        }
        if (n2 >= 0) {
            this.database.getStorage(n2, this).addPage(n);
            if (SysProperties.REUSE_SPACE_QUICKLY) {
                this.potentiallyFreePages.remove(ObjectUtils.getInteger(n));
            }
        }
        this.pageOwners.set(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUsed(int n, int n2) {
        Database database = this.database;
        synchronized (database) {
            if (n + n2 > this.fileBlockCount) {
                this.setBlockCount(n + n2);
            }
            this.used.setRange(n, n2, true);
            this.deleted.setRange(n, n2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            try {
                this.cache.clear();
                this.file.close();
                FileUtils.delete(this.fileName);
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.fileName);
            }
            finally {
                this.file = null;
                this.fileName = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBack(CacheObject cacheObject) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            ++this.writeCount;
            Record record = (Record)cacheObject;
            int n = record.getBlockCount();
            record.prepareWrite();
            this.go(record.getPos());
            DataPage dataPage = this.rowBuff;
            dataPage.reset();
            dataPage.checkCapacity(n * 128);
            dataPage.writeInt(n);
            dataPage.writeInt(record.getStorageId());
            record.write(dataPage);
            dataPage.fill(n * 128);
            dataPage.updateChecksum();
            this.file.write(dataPage.getBytes(), 0, dataPage.length());
            record.setChanged(false);
        }
    }

    BitField getUsed() {
        return this.used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRecord(Session session, Record record) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            record.setChanged(true);
            int n = record.getPos();
            Record record2 = (Record)this.cache.update(n, record);
            if (SysProperties.CHECK && record2 != null) {
                if (record2 != record) {
                    this.database.checkPowerOff();
                    throw Message.getInternalError("old != record old=" + record2 + " new=" + record);
                }
                int n2 = record.getBlockCount();
                for (int i = 0; i < n2; ++i) {
                    if (!this.deleted.get(i + n)) continue;
                    throw Message.getInternalError("update marked as deleted: " + (i + n));
                }
            }
            if (this.logChanges) {
                this.log.add(session, this, record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectDeleted(int n, int n2) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.go(n);
            for (int i = 0; i < n2; ++i) {
                this.file.write(this.freeBlock.getBytes(), 0, this.freeBlock.length());
            }
            this.free(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirect(Storage storage, int n, byte[] byArray, int n2) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.go(n);
            this.file.write(byArray, n2, 128);
            this.setBlockOwner(null, storage, n, 1, true);
        }
    }

    public int copyDirect(int n, OutputStream outputStream) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            try {
                if (n < 0) {
                    byte[] byArray = new byte[48];
                    this.file.seek(0L);
                    this.file.readFullyDirect(byArray, 0, 48);
                    outputStream.write(byArray);
                    return 0;
                }
                if (n >= this.fileBlockCount) {
                    return -1;
                }
                int n2 = 128;
                byte[] byArray = new byte[n2];
                DataPage dataPage = DataPage.create((DataHandler)this.database, byArray);
                this.database.setProgress(3, this.fileName, n, this.fileBlockCount);
                this.go(n);
                this.file.readFully(byArray, 0, n2);
                dataPage.reset();
                int n3 = dataPage.readInt();
                if (SysProperties.CHECK && n3 < 0) {
                    throw Message.getInternalError();
                }
                if (n3 == 0) {
                    n3 = 1;
                }
                int n4 = dataPage.readInt();
                if (SysProperties.CHECK && n4 < 0) {
                    throw Message.getInternalError();
                }
                dataPage.checkCapacity(n3 * n2);
                if (n3 > 1) {
                    this.file.readFully(dataPage.getBytes(), n2, n3 * n2 - n2);
                }
                if (this.file.isEncrypted()) {
                    dataPage.reset();
                    this.go(n);
                    this.file.readFullyDirect(dataPage.getBytes(), 0, n3 * n2);
                }
                outputStream.write(dataPage.getBytes(), 0, n3 * n2);
                return n + n3;
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecord(Session session, int n, Record record, int n2) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            if (this.logChanges) {
                this.log.add(session, this, record);
            }
            this.cache.remove(n);
            this.deleted.setRange(n, n2, true);
            this.setUnused(session, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecord(Session session, Record record) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            this.cache.put(record);
            if (this.logChanges) {
                this.log.add(session, this, record);
            }
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(int n, int n2) {
        Database database = this.database;
        synchronized (database) {
            this.used.setRange(n, n2, false);
        }
    }

    int getRecordOverhead() {
        return this.recordOverhead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncateStorage(Session session, Storage storage, IntArray intArray) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            int n = storage.getId();
            ObjectArray objectArray = this.cache.getAllChanged();
            for (int i = 0; i < objectArray.size(); ++i) {
                Record record = (Record)objectArray.get(i);
                if (record.getStorageId() != n) continue;
                record.setChanged(false);
            }
            int[] nArray = new int[intArray.size()];
            intArray.toArray(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                for (int j = 0; j < 64; ++j) {
                    Record record = (Record)this.cache.find(n2 * 64 + j);
                    if (record == null) continue;
                    this.cache.remove(record.getPos());
                }
                this.deleted.setRange(n2 * 64, 64, true);
                this.setUnused(session, n2 * 64, 64);
                if (!this.logChanges) continue;
                this.log.addTruncate(session, this, n, n2 * 64, 64);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Database database = this.database;
        synchronized (database) {
            if (this.file != null) {
                this.file.sync();
            }
        }
    }

    public boolean isDataFile() {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogChanges(boolean bl) {
        Database database = this.database;
        synchronized (database) {
            this.logChanges = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRedoLog(Storage storage, int n, int n2, DataPage dataPage) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            byte[] byArray = null;
            if (dataPage != null) {
                DataPage dataPage2 = this.rowBuff;
                dataPage2.reset();
                dataPage2.writeInt(n2);
                dataPage2.writeInt(storage.getId());
                dataPage2.writeDataPageNoSize(dataPage);
                dataPage2.fill(n2 * 128);
                dataPage2.updateChecksum();
                if (SysProperties.CHECK && dataPage2.length() != 128 * n2) {
                    throw Message.getInternalError("blockCount:" + n2 + " length: " + dataPage2.length() * 128);
                }
                byArray = new byte[dataPage2.length()];
                System.arraycopy(dataPage2.getBytes(), 0, byArray, 0, dataPage2.length());
            }
            for (int i = 0; i < n2; ++i) {
                RedoLogRecord redoLogRecord = new RedoLogRecord();
                redoLogRecord.recordId = n + i;
                redoLogRecord.offset = i * 128;
                redoLogRecord.storage = storage;
                redoLogRecord.data = byArray;
                redoLogRecord.sequenceId = this.redoBuffer.size();
                this.redoBuffer.add(redoLogRecord);
                this.redoBufferSize += redoLogRecord.getSize();
            }
            if (this.redoBufferSize > SysProperties.REDO_BUFFER_SIZE) {
                this.flushRedoLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRedoLog() throws SQLException {
        Database database = this.database;
        synchronized (database) {
            RedoLogRecord redoLogRecord;
            int n;
            if (this.redoBuffer.size() == 0) {
                return;
            }
            this.redoBuffer.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    RedoLogRecord redoLogRecord = (RedoLogRecord)object;
                    RedoLogRecord redoLogRecord2 = (RedoLogRecord)object2;
                    int n = redoLogRecord.recordId - redoLogRecord2.recordId;
                    if (n == 0) {
                        n = redoLogRecord.sequenceId - redoLogRecord2.sequenceId;
                    }
                    return n;
                }
            });
            RedoLogRecord redoLogRecord2 = null;
            for (n = 0; n < this.redoBuffer.size(); ++n) {
                redoLogRecord = (RedoLogRecord)this.redoBuffer.get(n);
                if (redoLogRecord.data != null) continue;
                if (redoLogRecord2 != null && redoLogRecord.recordId != redoLogRecord2.recordId) {
                    this.writeRedoLog(redoLogRecord2);
                }
                redoLogRecord2 = redoLogRecord;
            }
            if (redoLogRecord2 != null) {
                this.writeRedoLog(redoLogRecord2);
            }
            redoLogRecord2 = null;
            for (n = 0; n < this.redoBuffer.size(); ++n) {
                redoLogRecord = (RedoLogRecord)this.redoBuffer.get(n);
                if (redoLogRecord2 != null && redoLogRecord.recordId != redoLogRecord2.recordId && redoLogRecord2.data != null) {
                    this.writeRedoLog(redoLogRecord2);
                }
                redoLogRecord2 = redoLogRecord;
            }
            if (redoLogRecord2 != null && redoLogRecord2.data != null) {
                this.writeRedoLog(redoLogRecord2);
            }
            this.redoBuffer.clear();
            this.redoBufferSize = 0;
        }
    }

    private void writeRedoLog(RedoLogRecord redoLogRecord) throws SQLException {
        if (redoLogRecord.data == null) {
            this.writeDirectDeleted(redoLogRecord.recordId, 1);
        } else {
            this.writeDirect(redoLogRecord.storage, redoLogRecord.recordId, redoLogRecord.data, redoLogRecord.offset);
        }
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void flushLog() throws SQLException {
        if (this.log != null) {
            this.log.flush();
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.fileName;
    }
}

