/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

public class TableLink
extends Table {
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private Connection conn;
    private HashMap prepared = new HashMap();
    private final ObjectArray indexes = new ObjectArray();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private SQLException connectException;

    public TableLink(Schema schema, int n, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) throws SQLException {
        super(schema, n, string, false);
        this.driver = string2;
        this.url = string3;
        this.user = string4;
        this.password = string5;
        this.originalTable = string6;
        this.emitUpdates = bl;
        try {
            this.connect();
        }
        catch (SQLException sQLException) {
            this.connectException = sQLException;
            if (!bl2) {
                throw sQLException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.linkedIndex = new LinkedIndex(this, n, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() throws SQLException {
        Object object;
        int n;
        int n2;
        int n3;
        long l;
        int n4;
        String string;
        Object[] objectArray;
        Object object2;
        this.conn = JdbcUtils.getConnection(this.driver, this.url, this.user, this.password);
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        boolean bl = databaseMetaData.storesLowerCaseIdentifiers();
        boolean bl2 = databaseMetaData.storesMixedCaseIdentifiers();
        boolean bl3 = databaseMetaData.supportsMixedCaseIdentifiers();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, this.originalTable, null);
        int n5 = 0;
        ObjectArray objectArray2 = new ObjectArray();
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        String string2 = null;
        String string3 = null;
        while (resultSet.next()) {
            object2 = resultSet.getString("TABLE_CAT");
            if (string2 == null) {
                string2 = object2;
            }
            objectArray = resultSet.getString("TABLE_SCHEM");
            if (string3 == null) {
                string3 = objectArray;
            }
            if (!StringUtils.equals(string2, (String)object2) || !StringUtils.equals(string3, (String)objectArray)) {
                hashMap.clear();
                objectArray2.clear();
                break;
            }
            string = resultSet.getString("COLUMN_NAME");
            if (bl && string.equals(StringUtils.toLowerEnglish(string))) {
                string = StringUtils.toUpperEnglish(string);
            } else if (bl2 && !bl3) {
                string = StringUtils.toUpperEnglish(string);
            }
            n4 = resultSet.getInt("DATA_TYPE");
            l = resultSet.getInt("COLUMN_SIZE");
            n3 = resultSet.getInt("DECIMAL_DIGITS");
            n2 = MathUtils.convertLongToInt(l);
            n = DataType.convertSQLTypeToValueType(n4);
            object = new Column(string, n, l, n3, n2);
            ((Column)object).setTable(this, n5++);
            objectArray2.add(object);
            hashMap.put(string, (Column)object);
        }
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + "." + this.originalTable : this.originalTable;
        object2 = null;
        try {
            object2 = this.conn.createStatement();
            resultSet = object2.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
            if (objectArray2.size() == 0) {
                objectArray = resultSet.getMetaData();
                n5 = 0;
                while (n5 < objectArray.getColumnCount()) {
                    string = objectArray.getColumnName(n5 + 1);
                    if (bl && string.equals(StringUtils.toLowerEnglish(string))) {
                        string = StringUtils.toUpperEnglish(string);
                    }
                    n4 = objectArray.getColumnType(n5 + 1);
                    l = objectArray.getPrecision(n5 + 1);
                    n3 = objectArray.getScale(n5 + 1);
                    n2 = objectArray.getColumnDisplaySize(n5 + 1);
                    n = DataType.convertSQLTypeToValueType(n4);
                    object = new Column(string, n, l, n3, n2);
                    ((Column)object).setTable(this, n5++);
                    objectArray2.add(object);
                    hashMap.put(string, (Column)object);
                }
            }
        }
        catch (SQLException sQLException) {
            throw Message.getSQLException(42102, new String[]{this.originalTable + "(" + sQLException.toString() + ")"}, sQLException);
        }
        finally {
            JdbcUtils.closeSilently((Statement)object2);
        }
        objectArray = new Column[objectArray2.size()];
        objectArray2.toArray(objectArray);
        this.setColumns((Column[])objectArray);
        int n6 = this.getId();
        this.linkedIndex = new LinkedIndex(this, n6, IndexColumn.wrap((Column[])objectArray), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, null, this.originalTable);
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        String string4 = "";
        if (resultSet != null && resultSet.next()) {
            ObjectArray objectArray3 = new ObjectArray();
            do {
                int n7 = resultSet.getInt("KEY_SEQ");
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                while (objectArray3.size() < n7) {
                    objectArray3.add(null);
                }
                String string5 = resultSet.getString("COLUMN_NAME");
                Column column = (Column)hashMap.get(string5);
                objectArray3.set(n7 - 1, column);
            } while (resultSet.next());
            this.addIndex(objectArray3, IndexType.createPrimaryKey(false, false));
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, null, this.originalTable, false, true);
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        String string6 = null;
        ObjectArray objectArray4 = new ObjectArray();
        IndexType indexType = null;
        while (resultSet != null && resultSet.next()) {
            String string7 = resultSet.getString("INDEX_NAME");
            if (string4.equals(string7)) continue;
            if (string6 != null && !string6.equals(string7)) {
                this.addIndex(objectArray4, indexType);
                string6 = null;
            }
            if (string6 == null) {
                string6 = string7;
                objectArray4.clear();
            }
            n = !resultSet.getBoolean("NON_UNIQUE") ? 1 : 0;
            indexType = n != 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
            object = resultSet.getString("COLUMN_NAME");
            Column column = (Column)hashMap.get(object);
            objectArray4.add(column);
        }
        if (string6 != null) {
            this.addIndex(objectArray4, indexType);
        }
    }

    private void addIndex(ObjectArray objectArray, IndexType indexType) {
        Object[] objectArray2 = new Column[objectArray.size()];
        objectArray.toArray(objectArray2);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap((Column[])objectArray2), indexType);
        this.indexes.add(linkedIndex);
    }

    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE FORCE LINKED TABLE ");
        stringBuffer.append(this.getSQL());
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuffer.append("(");
        stringBuffer.append(StringUtils.quoteStringSQL(this.driver));
        stringBuffer.append(", ");
        stringBuffer.append(StringUtils.quoteStringSQL(this.url));
        stringBuffer.append(", ");
        stringBuffer.append(StringUtils.quoteStringSQL(this.user));
        stringBuffer.append(", ");
        stringBuffer.append(StringUtils.quoteStringSQL(this.password));
        stringBuffer.append(", ");
        stringBuffer.append(StringUtils.quoteStringSQL(this.originalTable));
        stringBuffer.append(")");
        if (this.emitUpdates) {
            stringBuffer.append(" EMIT UPDATES");
        }
        return stringBuffer.toString();
    }

    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    public void removeRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).remove(session, row);
    }

    public void addRow(Session session, Row row) throws SQLException {
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    public long getRowCount(Session session) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement("SELECT COUNT(*) FROM " + this.qualifiedTableName);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        return l;
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        if (this.conn == null) {
            throw this.connectException;
        }
        PreparedStatement preparedStatement = (PreparedStatement)this.prepared.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
            this.prepared.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    public void unlock(Session session) {
    }

    public void checkRename() {
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public String getTableType() {
        return "TABLE LINK";
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.conn = null;
        this.prepared = null;
        this.invalidate();
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = (Index)this.indexes.get(i);
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) throws SQLException {
        boolean bl;
        if (this.emitUpdates) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCancelled();
                Row row = rowList.next();
                Row row2 = rowList.next();
                this.linkedIndex.update(row, row2);
                session.log(this, (short)1, row);
                session.log(this, (short)0, row2);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }
}

