/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap planItems = new HashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] tableFilterArray, int n, Expression expression) {
        this.filters = new TableFilter[n];
        System.arraycopy(tableFilterArray, 0, this.filters, 0, n);
        ObjectArray objectArray = new ObjectArray();
        ObjectArray objectArray2 = new ObjectArray();
        if (expression != null) {
            objectArray.add(expression);
        }
        for (int i = 0; i < n; ++i) {
            TableFilter tableFilter = tableFilterArray[i];
            do {
                objectArray2.add(tableFilter);
                if (tableFilter.getJoinCondition() == null) continue;
                objectArray.add(tableFilter.getJoinCondition());
            } while ((tableFilter = tableFilter.getJoin()) != null);
        }
        this.allConditions = new Expression[objectArray.size()];
        objectArray.toArray(this.allConditions);
        this.allFilters = new TableFilter[objectArray2.size()];
        objectArray2.toArray(this.allFilters);
    }

    public PlanItem getItem(TableFilter tableFilter) {
        return (PlanItem)this.planItems.get(tableFilter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        TableFilter tableFilter;
        int n;
        for (n = 0; n < this.allFilters.length; ++n) {
            tableFilter = this.allFilters[n];
            this.setEvaluatable(tableFilter, true);
            if (n < this.allFilters.length - 1) {
                tableFilter.optimizeFullCondition(false);
            }
            tableFilter.removeUnusableIndexConditions();
        }
        for (n = 0; n < this.allFilters.length; ++n) {
            tableFilter = this.allFilters[n];
            this.setEvaluatable(tableFilter, false);
        }
    }

    public double calculateCost(Session session) throws SQLException {
        int n;
        double d = 1.0;
        boolean bl = false;
        for (n = 0; n < this.allFilters.length; ++n) {
            TableFilter tableFilter = this.allFilters[n];
            PlanItem planItem = tableFilter.getBestPlanItem(session);
            this.planItems.put(tableFilter, planItem);
            d += d * planItem.cost;
            this.setEvaluatable(tableFilter, true);
            Expression expression = tableFilter.getJoinCondition();
            if (expression == null || expression.isEverything(3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            d = Double.POSITIVE_INFINITY;
        }
        for (n = 0; n < this.allFilters.length; ++n) {
            this.setEvaluatable(this.allFilters[n], false);
        }
        return d;
    }

    private void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (int i = 0; i < this.allConditions.length; ++i) {
            this.allConditions[i].setEvaluatable(tableFilter, bl);
        }
    }
}

