/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPageBinary;
import org.h2.store.DataPageText;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public abstract class DataPage {
    static final boolean CHECKSUM = true;
    protected DataHandler handler;
    protected byte[] data;
    protected int pos;

    protected DataPage(DataHandler dataHandler, byte[] byArray) {
        this.handler = dataHandler;
        this.data = byArray;
    }

    public abstract void updateChecksum();

    public abstract void check(int var1) throws SQLException;

    public abstract int getFillerLength();

    public abstract void setInt(int var1, int var2);

    public abstract void writeInt(int var1);

    public abstract int readInt();

    public abstract int getIntLen();

    public abstract int getLongLen(long var1);

    public abstract int getStringLen(String var1);

    public abstract String readString();

    public abstract void writeString(String var1);

    public abstract void fill(int var1);

    public static DataPage create(DataHandler dataHandler, int n) {
        if (dataHandler.getTextStorage()) {
            return new DataPageText(dataHandler, new byte[n]);
        }
        return new DataPageBinary(dataHandler, new byte[n]);
    }

    public static DataPage create(DataHandler dataHandler, byte[] byArray) {
        if (dataHandler.getTextStorage()) {
            return new DataPageText(dataHandler, byArray);
        }
        return new DataPageBinary(dataHandler, byArray);
    }

    public void checkCapacity(int n) {
        if (this.pos + n >= this.data.length) {
            byte[] byArray = new byte[(this.data.length + n) * 2];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void writeDataPageNoSize(DataPage dataPage) {
        this.checkCapacity(dataPage.pos);
        int n = dataPage.pos - this.getFillerLength();
        System.arraycopy(dataPage.data, 0, this.data, this.pos, n);
        this.pos += n;
    }

    public DataPage readDataPageNoSize() {
        int n = this.data.length - this.pos;
        DataPage dataPage = DataPage.create(this.handler, n);
        System.arraycopy(this.data, this.pos, dataPage.data, 0, n);
        dataPage.pos = n;
        return dataPage;
    }

    public void write(byte[] byArray, int n, int n2) {
        this.checkCapacity(n2);
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeValue(Value value) throws SQLException {
        if (SysProperties.CHECK) {
            this.checkCapacity(8);
        }
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 45;
            return;
        }
        int n = this.pos;
        this.data[this.pos++] = (byte)(value.getType() + 97);
        switch (value.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeLong(value.getLong());
                break;
            }
            case 6: {
                String string = value.getString();
                this.writeString(string);
                break;
            }
            case 9: {
                this.writeLong(value.getTimeNoCopy().getTime());
                break;
            }
            case 10: {
                this.writeLong(value.getDateNoCopy().getTime());
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                this.writeLong(timestamp.getTime());
                this.writeInt(timestamp.getNanos());
                break;
            }
            case 12: 
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                this.writeInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.writeLong(Double.doubleToLongBits(value.getDouble()));
                break;
            }
            case 8: {
                this.writeInt(Float.floatToIntBits(value.getFloat()));
                break;
            }
            case 15: 
            case 16: {
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray == null) {
                    int n2 = -2;
                    if (!valueLob.isLinked()) {
                        n2 = -3;
                    }
                    this.writeInt(n2);
                    this.writeInt(valueLob.getTableId());
                    this.writeInt(valueLob.getObjectId());
                    this.writeLong(valueLob.getPrecision());
                    this.writeByte((byte)(valueLob.useCompression() ? 1 : 0));
                    if (n2 != -3) break;
                    this.writeString(valueLob.getFileName());
                    break;
                }
                this.writeInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeInt(valueArray.length);
                for (int i = 0; i < valueArray.length; ++i) {
                    this.writeValue(valueArray[i]);
                }
                break;
            }
            default: {
                throw Message.getInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - n != this.getValueLen(value)) {
            throw Message.getInternalError("value size error: got " + (this.pos - n) + " expected " + this.getValueLen(value));
        }
    }

    public int getValueLen(Value value) throws SQLException {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1 + this.getIntLen();
            }
            case 5: {
                return 1 + this.getLongLen(value.getLong());
            }
            case 7: {
                return 1 + this.getLongLen(Double.doubleToLongBits(value.getDouble()));
            }
            case 8: {
                return 1 + this.getIntLen();
            }
            case 13: 
            case 14: 
            case 21: {
                return 1 + this.getStringLen(value.getString());
            }
            case 6: {
                return 1 + this.getStringLen(value.getString());
            }
            case 12: 
            case 19: {
                int n = value.getBytesNoCopy().length;
                return 1 + this.getIntLen() + n;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                return 1 + this.getLongLen(valueUuid.getHigh()) + this.getLongLen(valueUuid.getLow());
            }
            case 9: {
                return 1 + this.getLongLen(value.getTimeNoCopy().getTime());
            }
            case 10: {
                return 1 + this.getLongLen(value.getDateNoCopy().getTime());
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                return 1 + this.getLongLen(timestamp.getTime()) + this.getIntLen();
            }
            case 15: 
            case 16: {
                int n = 1;
                ValueLob valueLob = (ValueLob)value;
                valueLob.convertToFileIfRequired(this.handler);
                byte[] byArray = valueLob.getSmall();
                if (byArray != null) {
                    n += this.getIntLen() + byArray.length;
                } else {
                    n += this.getIntLen() + this.getIntLen() + this.getIntLen() + this.getLongLen(valueLob.getPrecision()) + 1;
                    if (!valueLob.isLinked()) {
                        n += this.getStringLen(valueLob.getFileName());
                    }
                }
                return n;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n = 1 + this.getIntLen();
                for (int i = 0; i < valueArray.length; ++i) {
                    n += this.getValueLen(valueArray[i]);
                }
                return n;
            }
        }
        throw Message.getInternalError("type=" + value.getType());
    }

    public Value readValue() throws SQLException {
        int n;
        if ((n = this.data[this.pos++]) == 45) {
            return ValueNull.INSTANCE;
        }
        switch (n -= 97) {
            case 1: {
                return ValueBoolean.get(this.readInt() == 1);
            }
            case 2: {
                return ValueByte.get((byte)this.readInt());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 10: {
                return ValueDate.getNoCopy(new Date(this.readLong()));
            }
            case 9: {
                return ValueTime.get(new Time(this.readLong()));
            }
            case 11: {
                Timestamp timestamp = new Timestamp(this.readLong());
                timestamp.setNanos(this.readInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 19: {
                int n2 = this.readInt();
                byte[] byArray = new byte[n2];
                this.read(byArray, 0, n2);
                return ValueJavaObject.getNoCopy(byArray);
            }
            case 12: {
                int n3 = this.readInt();
                byte[] byArray = new byte[n3];
                this.read(byArray, 0, n3);
                return ValueBytes.getNoCopy(byArray);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(this.readLong()));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(this.readInt()));
            }
            case 15: 
            case 16: {
                int n4 = this.readInt();
                if (n4 >= 0) {
                    byte[] byArray = new byte[n4];
                    this.read(byArray, 0, n4);
                    return ValueLob.createSmallLob(n, byArray);
                }
                int n5 = this.readInt();
                int n6 = this.readInt();
                long l = 0L;
                boolean bl = false;
                if (n4 == -2 || n4 == -3) {
                    l = this.readLong();
                    bl = this.readByte() == 1;
                }
                ValueLob valueLob = ValueLob.open(n, this.handler, n5, n6, l, bl);
                if (n4 == -3) {
                    valueLob.setFileName(this.readString(), false);
                }
                return valueLob;
            }
            case 17: {
                int n7 = this.readInt();
                Value[] valueArray = new Value[n7];
                for (int i = 0; i < n7; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
        }
        throw Message.getInternalError("type=" + n);
    }

    public void fillAligned() {
        this.fill(MathUtils.roundUp(this.pos + 2, 16));
    }

    public void setPos(int n) {
        this.pos = n;
    }
}

