/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.constant.ErrorCode;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.InternalException;
import org.h2.message.TraceSystem;
import org.h2.util.Resources;
import org.h2.util.StringUtils;

public class Message {
    private static final Properties MESSAGES = new Properties();

    private Message() {
    }

    public static JdbcSQLException getSQLException(int n, String string) {
        return Message.getSQLException(n, new String[]{string});
    }

    private static String translate(String string, String[] stringArray) {
        String string2 = MESSAGES.getProperty(string);
        if (string2 == null) {
            string2 = "(Message " + string + " not found)";
        }
        if (stringArray != null) {
            Object[] objectArray = stringArray;
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public static JdbcSQLException getSQLException(int n, String[] stringArray, Throwable throwable) {
        String string = ErrorCode.getState(n);
        String string2 = Message.translate(string, stringArray);
        return new JdbcSQLException(string2, null, string, n, throwable, null);
    }

    public static JdbcSQLException getSQLException(int n, String[] stringArray) {
        return Message.getSQLException(n, stringArray, null);
    }

    public static SQLException getSyntaxError(String string, int n) {
        string = StringUtils.addAsterisk(string, n);
        return Message.getSQLException(42000, string);
    }

    public static SQLException getSyntaxError(String string, int n, String string2) {
        string = StringUtils.addAsterisk(string, n);
        return Message.getSQLException(42001, new String[]{string, string2});
    }

    public static JdbcSQLException getSQLException(int n) {
        return Message.getSQLException(n, (String)null);
    }

    public static JdbcSQLException getUnsupportedException() {
        return Message.getSQLException(50100);
    }

    public static JdbcSQLException getInvalidValueException(String string, String string2) {
        return Message.getSQLException(90008, new String[]{string, string2});
    }

    public static RuntimeException getInternalError(String string) {
        RuntimeException runtimeException = new RuntimeException(string);
        TraceSystem.traceThrowable(runtimeException);
        return runtimeException;
    }

    public static Error getInternalError(String string, Exception exception) {
        Error error = new Error(string);
        error.initCause(exception);
        TraceSystem.traceThrowable(error);
        return error;
    }

    public static SQLException addSQL(SQLException sQLException, String string) {
        if (sQLException instanceof JdbcSQLException) {
            JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
            if (jdbcSQLException.getSQL() == null) {
                jdbcSQLException.setSQL(string);
            }
            return jdbcSQLException;
        }
        return new JdbcSQLException(sQLException.getMessage(), string, sQLException.getSQLState(), sQLException.getErrorCode(), sQLException, null);
    }

    public static SQLException convert(Throwable throwable) {
        if (throwable instanceof InternalException) {
            throwable = ((InternalException)throwable).getOriginalCause();
        }
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            Throwable throwable2 = invocationTargetException.getTargetException();
            if (throwable2 instanceof SQLException) {
                return (SQLException)throwable2;
            }
            return Message.getSQLException(90105, null, throwable);
        }
        if (throwable instanceof IOException) {
            return Message.getSQLException(90028, new String[]{throwable.toString()}, throwable);
        }
        return Message.getSQLException(50000, new String[]{throwable.toString()}, throwable);
    }

    public static SQLException convertIOException(IOException iOException, String string) {
        if (string == null) {
            return Message.getSQLException(90028, new String[]{iOException.toString()}, iOException);
        }
        return Message.getSQLException(90031, new String[]{iOException.toString(), string}, iOException);
    }

    public static RuntimeException getInternalError() {
        return Message.getInternalError("Unexpected code path");
    }

    public static InternalException convertToInternal(Exception exception) {
        return new InternalException(exception);
    }

    public static IOException convertToIOException(Throwable throwable) {
        Exception exception;
        if (throwable instanceof JdbcSQLException && ((JdbcSQLException)(exception = (JdbcSQLException)throwable)).getOriginalCause() != null) {
            throwable = ((JdbcSQLException)exception).getOriginalCause();
        }
        exception = new IOException(throwable.toString());
        exception.initCause(throwable);
        return exception;
    }

    static {
        try {
            byte[] byArray;
            String string;
            byte[] byArray2 = Resources.get("/org/h2/res/_messages_en.properties");
            if (byArray2 != null) {
                MESSAGES.load(new ByteArrayInputStream(byArray2));
            }
            if (!"en".equals(string = Locale.getDefault().getLanguage()) && (byArray = Resources.get("/org/h2/res/_messages_" + string + ".properties")) != null) {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(byArray));
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    String string2 = (String)entry.getKey();
                    String string3 = (String)entry.getValue();
                    if (string3 == null || string3.startsWith("#")) continue;
                    String string4 = MESSAGES.getProperty(string2);
                    String string5 = string3 + "\n" + string4;
                    MESSAGES.put(string2, string5);
                }
            }
        }
        catch (IOException iOException) {
            TraceSystem.traceThrowable(iOException);
        }
    }
}

