/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    private final Boolean value;
    private static final ValueBoolean TRUE = new ValueBoolean(true);
    private static final ValueBoolean FALSE = new ValueBoolean(false);

    private ValueBoolean(boolean bl) {
        this.value = Boolean.valueOf("" + bl);
    }

    public int getType() {
        return 1;
    }

    public String getSQL() {
        return this.getString();
    }

    public String getString() {
        return this.value != false ? "TRUE" : "FALSE";
    }

    public Value negate() throws SQLException {
        return this.value != false ? FALSE : TRUE;
    }

    public Boolean getBoolean() {
        return this.value;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        boolean bl = ((ValueBoolean)value).value;
        boolean bl2 = this.value;
        return bl2 == bl ? 0 : (bl2 ? 1 : -1);
    }

    public long getPrecision() {
        return 1L;
    }

    public int hashCode() {
        return this.value != false ? 1 : 0;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBoolean(n, this.value);
    }

    public static ValueBoolean get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public int getDisplaySize() {
        return 5;
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

