/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.store.Record;
import org.h2.store.Storage;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class LogFile {
    private static final int BUFFER_SIZE = 8192;
    public static final int BLOCK_SIZE = 16;
    private LogSystem logSystem;
    private Database database;
    private int id;
    private String fileNamePrefix;
    private String fileName;
    private FileStore file;
    private int bufferPos;
    private byte[] buffer;
    private ObjectArray unwritten;
    private DataPage rowBuff;
    private int pos = -1;
    private int firstUncommittedPos = -1;
    private int firstUnwrittenPos = -1;

    LogFile(LogSystem log, int id, String fileNamePrefix) throws SQLException {
        this.logSystem = log;
        this.database = log.getDatabase();
        this.id = id;
        this.fileNamePrefix = fileNamePrefix;
        this.fileName = this.getFileName();
        this.file = log.getDatabase().openFile(this.fileName, log.getAccessMode(), false);
        this.rowBuff = log.getRowBuffer();
        this.buffer = new byte[8192];
        this.unwritten = new ObjectArray();
        try {
            this.readHeader();
            if (!log.getDatabase().getReadOnly()) {
                this.writeHeader();
            }
            this.firstUncommittedPos = this.pos = this.getBlock();
        }
        catch (SQLException e) {
            this.close(false);
            throw e;
        }
    }

    static LogFile openIfLogFile(LogSystem log, String fileNamePrefix, String fileName) throws SQLException {
        if (!fileName.endsWith(".log.db")) {
            return null;
        }
        if (!FileUtils.fileStartsWith(fileName, fileNamePrefix + ".")) {
            return null;
        }
        String s = fileName.substring(fileNamePrefix.length() + 1, fileName.length() - ".log.db".length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return null;
        }
        int id = Integer.parseInt(s);
        if (!FileUtils.exists(fileName)) {
            return null;
        }
        return new LogFile(log, id, fileNamePrefix);
    }

    public String getFileName() {
        return this.fileNamePrefix + "." + this.id + ".log.db";
    }

    public int getId() {
        return this.id;
    }

    private int getBlock() throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        return (int)(this.file.getFilePointer() / 16L);
    }

    private void writeBuffer(DataPage buff, Record rec) throws SQLException {
        if (this.file == null) {
            throw Message.getSQLException(90098);
        }
        int size = MathUtils.roundUp(buff.length() + buff.getFillerLength(), 16);
        int blockCount = size / 16;
        buff.fill(size);
        buff.setInt(0, blockCount);
        buff.updateChecksum();
        if (rec != null) {
            this.unwritten.add(rec);
        }
        if (buff.length() + this.bufferPos > this.buffer.length) {
            this.flush();
        }
        if (buff.length() >= this.buffer.length) {
            this.file.write(buff.getBytes(), 0, buff.length());
            this.pos = this.getBlock();
            return;
        }
        System.arraycopy(buff.getBytes(), 0, this.buffer, this.bufferPos, buff.length());
        this.bufferPos += buff.length();
        this.pos = this.getBlock() + this.bufferPos / 16;
    }

    void commit(Session session) throws SQLException {
        DataPage buff = this.rowBuff;
        buff.reset();
        buff.writeInt(0);
        buff.writeByte((byte)67);
        buff.writeInt(session.getId());
        this.writeBuffer(buff, null);
        if (this.logSystem.getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void prepareCommit(Session session, String transaction) throws SQLException {
        DataPage buff = this.rowBuff;
        buff.reset();
        buff.writeInt(0);
        buff.writeByte((byte)80);
        buff.writeInt(session.getId());
        buff.writeString(transaction);
        this.writeBuffer(buff, null);
        if (this.logSystem.getFlushOnEachCommit()) {
            this.flush();
        }
    }

    private DataPage readPage() throws SQLException {
        byte[] buff = new byte[16];
        this.file.readFully(buff, 0, 16);
        DataPage s = DataPage.create((DataHandler)this.database, buff);
        int blocks = Math.abs(s.readInt());
        if (blocks > 1) {
            byte[] b2 = new byte[blocks * 16];
            System.arraycopy(buff, 0, b2, 0, 16);
            buff = b2;
            this.file.readFully(buff, 16, blocks * 16 - 16);
            s = DataPage.create((DataHandler)this.database, buff);
            s.check(blocks * 16);
        } else {
            s.reset();
        }
        return s;
    }

    private boolean redoOrUndo(boolean undo, boolean readOnly) throws SQLException {
        int pos = this.getBlock();
        DataPage in = this.readPage();
        int blocks = in.readInt();
        if (blocks < 0) {
            return true;
        }
        if (blocks == 0) {
            this.truncate(pos);
            return false;
        }
        char type = (char)in.readByte();
        int sessionId = in.readInt();
        if (type == 'P') {
            if (undo) {
                throw Message.getInternalError("can't undo prepare commit");
            }
            String transaction = in.readString();
            this.logSystem.setPreparedCommitForSession(this, sessionId, pos, transaction, blocks);
            return true;
        }
        if (type == 'C') {
            if (undo) {
                throw Message.getInternalError("can't undo commit");
            }
            this.logSystem.setLastCommitForSession(sessionId, this.id, pos);
            return true;
        }
        if (type == 'R') {
            if (undo) {
                throw Message.getInternalError("can't undo rollback");
            }
            return true;
        }
        if (type == 'S' && undo) {
            throw Message.getInternalError("can't undo summary");
        }
        if (readOnly && type != 'S') {
            return true;
        }
        if (undo) {
            if (this.logSystem.isSessionCommitted(sessionId, this.id, pos)) {
                this.logSystem.removeSession(sessionId);
                return true;
            }
        } else if (type != 'S' && !readOnly) {
            this.logSystem.addUndoLogRecord(this, pos, sessionId);
        }
        int storageId = in.readInt();
        Storage storage = this.logSystem.getStorageForRecovery(storageId);
        DataPage rec = null;
        int recordId = in.readInt();
        int blockCount = in.readInt();
        if (type != 'T') {
            rec = in.readDataPageNoSize();
        }
        switch (type) {
            case 'S': {
                boolean diskFile;
                int fileType = in.readByte();
                if (fileType == 68) {
                    diskFile = true;
                } else {
                    if (fileType != 73) break;
                    diskFile = false;
                }
                int sumLength = in.readInt();
                byte[] summary = new byte[sumLength];
                if (sumLength > 0) {
                    in.read(summary, 0, sumLength);
                }
                if (diskFile) {
                    this.database.getDataFile().initFromSummary(summary);
                    break;
                }
                this.database.getIndexFile().initFromSummary(summary);
                break;
            }
            case 'T': {
                if (undo) {
                    throw Message.getInternalError("cannot undo truncate");
                }
                this.logSystem.addRedoLog(storage, recordId, blockCount, null);
                storage.setRecordCount(0);
                storage.getDiskFile().setPageOwner(recordId / 64, -1);
                this.logSystem.setLastCommitForSession(sessionId, this.id, pos);
                break;
            }
            case 'I': {
                if (undo) {
                    this.logSystem.addRedoLog(storage, recordId, blockCount, null);
                    storage.setRecordCount(storage.getRecordCount() - 1);
                    break;
                }
                this.logSystem.getOrAddSessionState(sessionId);
                this.logSystem.addRedoLog(storage, recordId, blockCount, rec);
                storage.setRecordCount(storage.getRecordCount() + 1);
                break;
            }
            case 'D': {
                if (undo) {
                    this.logSystem.addRedoLog(storage, recordId, blockCount, rec);
                    storage.setRecordCount(storage.getRecordCount() + 1);
                    break;
                }
                this.logSystem.getOrAddSessionState(sessionId);
                this.logSystem.addRedoLog(storage, recordId, blockCount, null);
                storage.setRecordCount(storage.getRecordCount() - 1);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + type);
            }
        }
        return true;
    }

    public void redoAllGoEnd() throws SQLException {
        boolean readOnly = this.logSystem.getDatabase().getReadOnly();
        long length = this.file.length();
        if (length <= 48L) {
            return;
        }
        try {
            boolean more;
            int max = (int)(length / 16L);
            do {
                this.pos = this.getBlock();
                this.database.setProgress(2, this.fileName, this.pos, max);
            } while ((long)this.pos * 16L < length && (more = this.redoOrUndo(false, readOnly)));
            this.database.setProgress(2, this.fileName, max, max);
        }
        catch (SQLException e) {
            this.database.getTrace("log").debug("Stop reading log file: " + e.getMessage(), e);
        }
        catch (OutOfMemoryError e) {
            throw Message.convert(e);
        }
        catch (Throwable e) {
            this.database.getTrace("log").error("Error reading log file (non-fatal)", e);
        }
        this.go(this.pos);
    }

    void go(int pos) throws SQLException {
        this.file.seek((long)pos * 16L);
    }

    void undo(int pos) throws SQLException {
        this.go(pos);
        this.redoOrUndo(true, false);
    }

    void flush() throws SQLException {
        if (this.bufferPos > 0) {
            if (this.file == null) {
                throw Message.getSQLException(90098);
            }
            this.file.write(this.buffer, 0, this.bufferPos);
            this.pos = this.getBlock();
            for (int i = 0; i < this.unwritten.size(); ++i) {
                Record r = (Record)this.unwritten.get(i);
                r.setLogWritten(this.id, this.pos);
            }
            this.unwritten.clear();
            this.bufferPos = 0;
            long min = (long)this.pos * 16L;
            min = MathUtils.scaleUp50Percent(131072L, min, 8192L, 0x2000000L);
            if (min > this.file.length()) {
                this.file.setLength(min);
            }
        }
    }

    void close(boolean delete) throws SQLException {
        SQLException closeException = null;
        try {
            this.flush();
        }
        catch (SQLException e) {
            closeException = e;
        }
        if (this.file != null) {
            block7: {
                try {
                    this.file.close();
                    this.file = null;
                    if (delete) {
                        this.database.deleteLogFileLater(this.fileName);
                    }
                }
                catch (IOException e) {
                    if (closeException != null) break block7;
                    closeException = Message.convertIOException(e, this.fileName);
                }
            }
            this.file = null;
            this.fileNamePrefix = null;
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    void addSummary(boolean dataFile, byte[] summary) throws SQLException {
        DataPage buff = DataPage.create((DataHandler)this.database, 256);
        buff.writeInt(0);
        buff.writeByte((byte)83);
        buff.writeInt(0);
        buff.writeInt(0);
        buff.writeInt(0);
        buff.writeInt(0);
        buff.writeByte((byte)(dataFile ? 68 : 73));
        if (summary == null) {
            buff.writeInt(0);
        } else {
            buff.checkCapacity(summary.length);
            buff.writeInt(summary.length);
            buff.write(summary, 0, summary.length);
        }
        this.writeBuffer(buff, null);
    }

    void addTruncate(Session session, int storageId, int recordId, int blockCount) throws SQLException {
        DataPage buff = this.rowBuff;
        buff.reset();
        buff.writeInt(0);
        buff.writeByte((byte)84);
        buff.writeInt(session.getId());
        buff.writeInt(storageId);
        buff.writeInt(recordId);
        buff.writeInt(blockCount);
        this.writeBuffer(buff, null);
    }

    void add(Session session, int storageId, Record record) throws SQLException {
        record.prepareWrite();
        DataPage buff = this.rowBuff;
        buff.reset();
        buff.writeInt(0);
        if (record.getDeleted()) {
            buff.writeByte((byte)68);
        } else {
            buff.writeByte((byte)73);
        }
        buff.writeInt(session.getId());
        buff.writeInt(storageId);
        buff.writeInt(record.getPos());
        int blockCount = record.getBlockCount();
        buff.writeInt(blockCount);
        buff.checkCapacity(128 * blockCount);
        record.write(buff);
        this.writeBuffer(buff, record);
    }

    void setFirstUncommittedPos(int firstUncommittedPos) throws SQLException {
        this.firstUncommittedPos = firstUncommittedPos;
        int pos = this.getBlock();
        this.writeHeader();
        this.go(pos);
    }

    int getFirstUncommittedPos() {
        return this.firstUncommittedPos;
    }

    private void writeHeader() throws SQLException {
        this.file.seek(48L);
        DataPage buff = this.getHeader();
        this.file.write(buff.getBytes(), 0, buff.length());
    }

    void truncate(int pos) throws SQLException {
        this.go(pos);
        this.file.setLength((long)pos * 16L);
    }

    private DataPage getHeader() {
        DataPage buff = this.rowBuff;
        buff.reset();
        buff.writeInt(this.id);
        buff.writeInt(this.firstUncommittedPos);
        buff.writeInt(this.firstUnwrittenPos);
        buff.fill(48);
        return buff;
    }

    private void readHeader() throws SQLException {
        DataPage buff = this.getHeader();
        int len = buff.length();
        buff.reset();
        if (this.file.length() < (long)(48 + len)) {
            return;
        }
        this.file.readFully(buff.getBytes(), 0, len);
        this.id = buff.readInt();
        this.firstUncommittedPos = buff.readInt();
        this.firstUnwrittenPos = buff.readInt();
    }

    int getPos() {
        return this.pos;
    }

    public long getFileSize() throws SQLException {
        return this.file.getFilePointer();
    }

    public void sync() {
        if (this.file != null) {
            this.file.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePreparedCommit(boolean commit, int pos, int sessionId, int blocks) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            int posNow = this.getBlock();
            DataPage buff = this.rowBuff;
            buff.reset();
            buff.writeInt(blocks);
            if (commit) {
                buff.writeByte((byte)67);
            } else {
                buff.writeByte((byte)82);
            }
            buff.writeInt(sessionId);
            buff.fill(blocks * 16);
            buff.updateChecksum();
            this.go(pos);
            this.file.write(buff.getBytes(), 0, 16 * blocks);
            this.go(posNow);
        }
    }
}

