/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class BtreeLeaf
extends BtreePage {
    private boolean writePos;
    private int cachedRealByteCount;

    BtreeLeaf(BtreeIndex index, Session session, DataPage s) throws SQLException {
        super(index);
        boolean bl = this.writePos = s.readByte() == 80;
        if (this.writePos) {
            int size = s.readInt();
            this.pageData = new ObjectArray(size);
            for (int i = 0; i < size; ++i) {
                Row r = index.getRow(session, s.readInt());
                this.pageData.add(r);
            }
        } else {
            this.pageData = index.readRowArray(s);
        }
    }

    BtreeLeaf(BtreeIndex index, ObjectArray pageData) {
        super(index);
        this.pageData = pageData;
    }

    public int add(Row newRow, Session session) throws SQLException {
        SearchRow row;
        int l = 0;
        int r = this.pageData.size();
        while (l < r) {
            int i = l + r >>> 1;
            row = (SearchRow)this.pageData.get(i);
            int comp = this.index.compareRows(row, newRow);
            if (comp == 0) {
                if (this.index.indexType.isUnique() && !this.index.isNull(newRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                comp = this.index.compareKeys(row, newRow);
            }
            if (comp > 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        this.index.deletePage(session, this);
        int at = l;
        row = this.index.getSearchRow(newRow);
        this.pageData.add(at, row);
        this.updateRealByteCount(true, newRow);
        int splitPoint = this.getSplitPoint();
        if (splitPoint == 0) {
            this.index.updatePage(session, this);
        }
        return splitPoint;
    }

    public SearchRow remove(Session session, Row oldRow) throws SQLException {
        int l = 0;
        int r = this.pageData.size();
        if (r == 0) {
            // empty if block
        }
        while (l < r) {
            int i = l + r >>> 1;
            SearchRow row = (SearchRow)this.pageData.get(i);
            if (SysProperties.CHECK && row == null) {
                throw Message.getInternalError("btree corrupt");
            }
            int comp = this.index.compareRows(row, oldRow);
            if (comp == 0) {
                comp = this.index.compareKeys(row, oldRow);
            }
            if (comp == 0) {
                this.index.deletePage(session, this);
                if (this.pageData.size() == 1 && !this.root) {
                    return oldRow;
                }
                this.pageData.remove(i);
                this.updateRealByteCount(false, row);
                this.index.updatePage(session, this);
                if (i > 0) {
                    return null;
                }
                if (this.pageData.size() == 0) {
                    return null;
                }
                return this.getData(0);
            }
            if (comp > 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        throw Message.getSQLException(90112, this.index.getSQL());
    }

    public BtreePage split(Session session, int splitPoint) throws SQLException {
        ObjectArray data = new ObjectArray();
        int max = this.pageData.size();
        for (int i = splitPoint; i < max; ++i) {
            data.add(this.getData(splitPoint));
            this.pageData.remove(splitPoint);
        }
        this.cachedRealByteCount = 0;
        BtreeLeaf n2 = new BtreeLeaf(this.index, data);
        this.index.updatePage(session, this);
        this.index.addPage(session, n2);
        return n2;
    }

    public boolean findFirst(BtreeCursor cursor, SearchRow compare, boolean bigger) throws SQLException {
        int l = 0;
        int r = this.pageData.size();
        if (r == 0) {
            // empty if block
        }
        while (l < r) {
            int i = l + r >>> 1;
            SearchRow row = (SearchRow)this.pageData.get(i);
            int comp = this.index.compareRows(row, compare);
            if (comp > 0 || !bigger && comp == 0) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        if (l >= this.pageData.size()) {
            return false;
        }
        cursor.push(this, l);
        SearchRow row = (SearchRow)this.pageData.get(l);
        cursor.setCurrentRow(row);
        return true;
    }

    public void next(BtreeCursor cursor, int i) throws SQLException {
        if (++i < this.pageData.size()) {
            SearchRow r = (SearchRow)this.pageData.get(i);
            cursor.setCurrentRow(r);
            cursor.setStackPosition(i);
            return;
        }
        cursor.pop();
        this.nextUpper(cursor);
    }

    public void first(BtreeCursor cursor) throws SQLException {
        if (this.pageData.size() == 0) {
            this.nextUpper(cursor);
            return;
        }
        cursor.push(this, 0);
        SearchRow row = (SearchRow)this.pageData.get(0);
        cursor.setCurrentRow(row);
    }

    private void nextUpper(BtreeCursor cursor) throws SQLException {
        BtreePosition upper = cursor.pop();
        if (upper == null) {
            cursor.setCurrentRow(null);
        } else {
            cursor.push(upper.page, upper.position);
            upper.page.next(cursor, upper.position);
        }
    }

    public void prepareWrite() throws SQLException {
        this.writePos = this.getRealByteCount() >= 1024;
    }

    public void write(DataPage buff) throws SQLException {
        buff.writeByte((byte)76);
        int len = this.pageData.size();
        if (this.writePos) {
            buff.writeByte((byte)80);
        } else {
            buff.writeByte((byte)68);
        }
        buff.writeInt(len);
        Column[] columns = this.index.getColumns();
        for (int i = 0; i < len; ++i) {
            SearchRow row = (SearchRow)this.pageData.get(i);
            buff.writeInt(row.getPos());
            if (this.writePos) continue;
            for (int j = 0; j < columns.length; ++j) {
                Value v = row.getValue(columns[j].getColumnId());
                buff.writeValue(v);
            }
        }
    }

    private void updateRealByteCount(boolean add, SearchRow row) throws SQLException {
        if (this.cachedRealByteCount == 0) {
            return;
        }
        DataPage dummy = this.index.getDatabase().getDataPage();
        this.cachedRealByteCount += this.getRowSize(dummy, row) + dummy.getIntLen();
        if (this.cachedRealByteCount + this.index.getRecordOverhead() >= 1024) {
            this.cachedRealByteCount = 0;
        }
    }

    public int getRealByteCount() throws SQLException {
        if (this.cachedRealByteCount > 0) {
            return this.cachedRealByteCount;
        }
        DataPage dummy = this.index.getDatabase().getDataPage();
        int len = this.pageData.size();
        int size = 2 + dummy.getIntLen() * (len + 1);
        for (int i = 0; i < len; ++i) {
            SearchRow row = (SearchRow)this.pageData.get(i);
            size += this.getRowSize(dummy, row);
        }
        this.cachedRealByteCount = size += this.index.getRecordOverhead();
        return size;
    }

    SearchRow getLast(Session session) throws SQLException {
        if (this.pageData.size() == 0) {
            return null;
        }
        return (SearchRow)this.pageData.get(this.pageData.size() - 1);
    }

    SearchRow getFirst(Session session) throws SQLException {
        if (this.pageData.size() == 0) {
            return null;
        }
        return (SearchRow)this.pageData.get(0);
    }
}

