/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringCache;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueStringBase;

public class ValueString
extends ValueStringBase {
    private static final ValueString EMPTY = new ValueString("");

    protected ValueString(String value) {
        super(value);
    }

    public int getType() {
        return 13;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueStringBase v = (ValueStringBase)o;
        return mode.compareString(this.value, v.value, false);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Value convertPrecision(long precision) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return ValueString.get(this.value.substring(0, p));
    }

    public static ValueString get(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        ValueString obj = new ValueString(StringCache.get(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueString)Value.cache(obj);
    }
}

