/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class FunctionAlias
extends DbObjectBase {
    private boolean hasConnectionParam;
    private String className;
    private String methodName;
    private Method javaMethod;
    private int paramCount;
    private int dataType;
    static /* synthetic */ Class class$java$sql$Connection;

    public FunctionAlias(Database db, int id, String name, String javaClassMethod, boolean force) throws SQLException {
        block3: {
            super(db, id, name, "function");
            int paren = javaClassMethod.indexOf(40);
            int lastDot = javaClassMethod.lastIndexOf(46, paren < 0 ? javaClassMethod.length() : paren);
            if (lastDot < 0) {
                throw Message.getSQLException(42000, javaClassMethod);
            }
            this.className = javaClassMethod.substring(0, lastDot);
            this.methodName = javaClassMethod.substring(lastDot + 1);
            try {
                this.load();
            }
            catch (SQLException e) {
                if (force) break block3;
                throw e;
            }
        }
    }

    private synchronized void load() throws SQLException {
        Class<?> paramClass;
        if (this.javaMethod != null) {
            return;
        }
        Class javaClass = this.database.loadUserClass(this.className);
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers())) continue;
            if (m.getName().equals(this.methodName)) {
                this.javaMethod = m;
                break;
            }
            if (!this.getMethodSignature(m).equals(this.methodName)) continue;
            this.javaMethod = m;
            break;
        }
        if (this.javaMethod == null) {
            throw Message.getSQLException(90087, this.methodName + " (" + this.className + ")");
        }
        Class<?>[] paramClasses = this.javaMethod.getParameterTypes();
        this.paramCount = paramClasses.length;
        if (this.paramCount > 0 && (class$java$sql$Connection == null ? (class$java$sql$Connection = FunctionAlias.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(paramClass = paramClasses[0])) {
            this.hasConnectionParam = true;
            --this.paramCount;
        }
        Class<?> returnClass = this.javaMethod.getReturnType();
        this.dataType = DataType.getTypeFromClass(returnClass);
    }

    private String getMethodSignature(Method m) {
        StringBuffer buff = new StringBuffer();
        buff.append(m.getName());
        buff.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> p;
            if (i > 0) {
                buff.append(", ");
            }
            if ((p = params[i]).isArray()) {
                buff.append(p.getComponentType().getName());
                buff.append("[]");
                continue;
            }
            buff.append(p.getName());
        }
        buff.append(')');
        return buff.toString();
    }

    public Class[] getColumnClasses() throws SQLException {
        this.load();
        return this.javaMethod.getParameterTypes();
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE FORCE ALIAS ");
        buff.append(this.getSQL());
        buff.append(" FOR ");
        buff.append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        return buff.toString();
    }

    public int getType() {
        return 9;
    }

    public synchronized void removeChildrenAndResources(Session session) throws SQLException {
        this.methodName = null;
        this.className = null;
        this.javaMethod = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value getValue(Session session, Expression[] args) throws SQLException {
        return this.getValue(session, args, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Value getValue(Session session, Expression[] args, boolean columnList) throws SQLException {
        this.load();
        Class<?>[] paramClasses = this.javaMethod.getParameterTypes();
        Object[] params = new Object[paramClasses.length];
        int p = 0;
        if (this.hasConnectionParam && params.length > 0) {
            params[p++] = session.createConnection(columnList);
        }
        for (int a = 0; a < args.length && p < params.length; ++a, ++p) {
            Class<?> paramClass = paramClasses[p];
            int type = DataType.getTypeFromClass(paramClass);
            Value v = args[a].getValue(session);
            Object o = (v = v.convertTo(type)).getObject();
            if (o == null) {
                if (paramClass.isPrimitive()) {
                    if (!columnList) return ValueNull.INSTANCE;
                    o = DataType.getDefaultForPrimitiveType(paramClass);
                }
            } else if (!paramClass.isAssignableFrom(o.getClass()) && !paramClass.isPrimitive()) {
                o = DataType.convertTo(session, session.createConnection(false), v, paramClass);
            }
            params[p] = o;
        }
        boolean old = session.getAutoCommit();
        try {
            Object returnValue;
            block13: {
                session.setAutoCommit(false);
                try {
                    returnValue = this.javaMethod.invoke(null, params);
                    if (returnValue != null) break block13;
                    ValueNull type = ValueNull.INSTANCE;
                    return type;
                }
                catch (Exception e) {
                    throw Message.convert(e);
                }
            }
            Value ret = DataType.convertToValue(session, returnValue, this.dataType);
            Value value = ret.convertTo(this.dataType);
            return value;
        }
        finally {
            session.setAutoCommit(old);
        }
    }

    public int getParameterCount() throws SQLException {
        this.load();
        return this.paramCount;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public boolean hasConnectionParam() {
        return this.hasConnectionParam;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

