/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;

public class AlterTableAddConstraint
extends SchemaCommand {
    public static final int CHECK = 0;
    public static final int UNIQUE = 1;
    public static final int REFERENTIAL = 2;
    public static final int PRIMARY_KEY = 3;
    private int type;
    private String constraintName;
    private String tableName;
    private IndexColumn[] indexColumns;
    private int deleteAction;
    private int updateAction;
    private Schema refSchema;
    private String refTableName;
    private IndexColumn[] refIndexColumns;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;
    private String comment;
    private boolean checkExisting;
    private boolean primaryKeyHash;

    public AlterTableAddConstraint(Session session, Schema schema) {
        super(session, schema);
    }

    private String generateConstraintName(DbObject obj, int id) throws SQLException {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName(obj);
        }
        return this.constraintName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        try {
            int n = this.tryUpdate();
            return n;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int tryUpdate() throws SQLException {
        void var3_28;
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        if (this.getSchema().findConstraint(this.constraintName) != null) {
            throw Message.getSQLException(90045, this.constraintName);
        }
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 3: {
                IndexColumn.mapColumns(this.indexColumns, table);
                this.index = table.findPrimaryKey();
                ObjectArray constraints = table.getConstraints();
                for (int i = 0; constraints != null && i < constraints.size(); ++i) {
                    Constraint c = (Constraint)constraints.get(i);
                    if (!"PRIMARY KEY".equals(c.getConstraintType())) continue;
                    throw Message.getSQLException(90017);
                }
                if (this.index != null) {
                    IndexColumn[] pkCols = this.index.getIndexColumns();
                    if (pkCols.length != this.indexColumns.length) {
                        throw Message.getSQLException(90017);
                    }
                    for (int i = 0; i < pkCols.length; ++i) {
                        if (pkCols[i].column == this.indexColumns[i].column) continue;
                        throw Message.getSQLException(90017);
                    }
                }
                if (this.index == null) {
                    IndexType indexType = IndexType.createPrimaryKey(table.isPersistent(), this.primaryKeyHash);
                    String indexName = this.getSchema().getUniqueIndexName(table, "PRIMARY_KEY_");
                    int id = this.getObjectId(true, false);
                    try {
                        this.index = table.addIndex(this.session, indexName, id, this.indexColumns, indexType, -1, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName(indexName);
                    }
                }
                this.index.getIndexType().setBelongsToConstraint(true);
                int constraintId = this.getObjectId(true, true);
                String name = this.generateConstraintName(table, constraintId);
                ConstraintUnique pk = new ConstraintUnique(this.getSchema(), constraintId, name, table, true);
                pk.setColumns(this.indexColumns);
                pk.setIndex(this.index, true);
                Constraint constraint = pk;
                break;
            }
            case 1: {
                IndexColumn.mapColumns(this.indexColumns, table);
                boolean isOwner = false;
                if (this.index != null && this.canUseUniqueIndex(this.index, table, this.indexColumns)) {
                    isOwner = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = this.getUniqueIndex(table, this.indexColumns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, true);
                        isOwner = true;
                    }
                }
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(table, id);
                ConstraintUnique unique = new ConstraintUnique(this.getSchema(), id, name, table, false);
                unique.setColumns(this.indexColumns);
                unique.setIndex(this.index, isOwner);
                Constraint constraint = unique;
                break;
            }
            case 0: {
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(table, id);
                ConstraintCheck check = new ConstraintCheck(this.getSchema(), id, name, table);
                TableFilter filter = new TableFilter(this.session, table, null, false, null);
                this.checkExpression.mapColumns(filter, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                check.setExpression(this.checkExpression);
                check.setTableFilter(filter);
                Constraint constraint = check;
                if (!this.checkExisting) break;
                check.checkExistingData(this.session);
                break;
            }
            case 2: {
                Table refTable = this.refSchema.getTableOrView(this.session, this.refTableName);
                this.session.getUser().checkRight(refTable, 15);
                boolean isOwner = false;
                IndexColumn.mapColumns(this.indexColumns, table);
                if (this.index != null && this.canUseIndex(this.index, table, this.indexColumns)) {
                    isOwner = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = this.getIndex(table, this.indexColumns);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, false);
                        isOwner = true;
                    }
                }
                if (this.refIndexColumns == null) {
                    Index refIdx = refTable.getPrimaryKey();
                    this.refIndexColumns = refIdx.getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.refIndexColumns, refTable);
                }
                if (this.refIndexColumns.length != this.indexColumns.length) {
                    throw Message.getSQLException(21002);
                }
                boolean isRefOwner = false;
                if (this.refIndex != null && this.refIndex.getTable() == refTable) {
                    isRefOwner = true;
                    this.refIndex.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.refIndex = null;
                }
                if (this.refIndex == null) {
                    this.refIndex = this.getUniqueIndex(refTable, this.refIndexColumns);
                    if (this.refIndex == null) {
                        this.refIndex = this.createIndex(refTable, this.refIndexColumns, true);
                        isRefOwner = true;
                    }
                }
                int id = this.getObjectId(true, true);
                String name = this.generateConstraintName(table, id);
                ConstraintReferential ref = new ConstraintReferential(this.getSchema(), id, name, table);
                ref.setColumns(this.indexColumns);
                ref.setIndex(this.index, isOwner);
                ref.setRefTable(refTable);
                ref.setRefColumns(this.refIndexColumns);
                ref.setRefIndex(this.refIndex, isRefOwner);
                if (this.checkExisting) {
                    ref.checkExistingData(this.session);
                }
                Constraint constraint = ref;
                refTable.addConstraint(constraint);
                ref.setDeleteAction(this.session, this.deleteAction);
                ref.setUpdateAction(this.session, this.updateAction);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        var3_28.setComment(this.comment);
        db.addSchemaObject(this.session, (SchemaObject)var3_28);
        table.addConstraint((Constraint)var3_28);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index createIndex(Table t, IndexColumn[] cols, boolean unique) throws SQLException {
        Index idx;
        int indexId = this.getObjectId(true, false);
        IndexType indexType = unique ? IndexType.createUnique(t.isPersistent(), false) : IndexType.createNonUnique(t.isPersistent());
        indexType.setBelongsToConstraint(true);
        String prefix = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String indexName = this.getSchema().getUniqueIndexName(t, prefix + "_INDEX_");
        try {
            idx = t.addIndex(this.session, indexName, indexId, cols, indexType, -1, null);
        }
        finally {
            this.getSchema().freeUniqueName(indexName);
        }
        return idx;
    }

    public void setDeleteAction(int action) {
        this.deleteAction = action;
    }

    public void setUpdateAction(int action) {
        this.updateAction = action;
    }

    private Index getUniqueIndex(Table t, IndexColumn[] cols) {
        ObjectArray list = t.getIndexes();
        for (int i = 0; i < list.size(); ++i) {
            Index index = (Index)list.get(i);
            if (!this.canUseUniqueIndex(index, t, cols)) continue;
            return index;
        }
        return null;
    }

    private Index getIndex(Table t, IndexColumn[] cols) {
        ObjectArray list = t.getIndexes();
        for (int i = 0; i < list.size(); ++i) {
            Index index = (Index)list.get(i);
            if (!this.canUseIndex(index, t, cols)) continue;
            return index;
        }
        return null;
    }

    private boolean canUseUniqueIndex(Index index, Table table, IndexColumn[] cols) {
        if (index.getTable() != table || !index.getIndexType().isUnique()) {
            return false;
        }
        if (index.getIndexType().belongsToConstraint()) {
            return false;
        }
        Column[] indexCols = index.getColumns();
        if (indexCols.length > cols.length) {
            return false;
        }
        HashSet<Column> set = new HashSet<Column>();
        for (int i = 0; i < cols.length; ++i) {
            set.add(cols[i].column);
        }
        for (int j = 0; j < indexCols.length; ++j) {
            if (set.contains(indexCols[j])) continue;
            return false;
        }
        return true;
    }

    private boolean canUseIndex(Index index, Table table, IndexColumn[] cols) {
        if (index.getTable() != table || index.getCreateSQL() == null) {
            return false;
        }
        if (index.getIndexType().belongsToConstraint()) {
            return false;
        }
        Column[] indexCols = index.getColumns();
        if (indexCols.length < cols.length) {
            return false;
        }
        for (int j = 0; j < cols.length; ++j) {
            int idx = index.getColumnIndex(cols[j].column);
            if (idx >= 0 && idx < cols.length) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIndexColumns(IndexColumn[] indexColumns) {
        this.indexColumns = indexColumns;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public void setRefTableName(Schema refSchema, String ref) {
        this.refSchema = refSchema;
        this.refTableName = ref;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumns) {
        this.refIndexColumns = indexColumns;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index refIndex) {
        this.refIndex = refIndex;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCheckExisting(boolean b) {
        this.checkExisting = b;
    }

    public void setPrimaryKeyHash(boolean b) {
        this.primaryKeyHash = b;
    }

    public boolean getPrimaryKeyHash() {
        return this.primaryKeyHash;
    }
}

