/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.Collator;
import java.util.HashSet;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterSequence;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateUserDataType;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropUserDataType;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.ExplainPlan;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.Query;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionExists;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.FunctionCall;
import org.h2.expression.JavaAggregate;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SequenceValue;
import org.h2.expression.Subquery;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.ByteUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringCache;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class Parser {
    private static final int CHAR_END = -1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DECIMAL = 8;
    private static final int KEYWORD = 1;
    private static final int IDENTIFIER = 2;
    private static final int PARAMETER = 3;
    private static final int END = 4;
    private static final int VALUE = 5;
    private static final int EQUAL = 6;
    private static final int BIGGER_EQUAL = 7;
    private static final int BIGGER = 8;
    private static final int SMALLER = 9;
    private static final int SMALLER_EQUAL = 10;
    private static final int NOT_EQUAL = 11;
    private static final int AT = 12;
    private static final int MINUS = 17;
    private static final int PLUS = 18;
    private static final int STRING_CONCAT = 22;
    private static final int OPEN = 31;
    private static final int CLOSE = 32;
    private static final int NULL = 34;
    private static final int TRUE = 40;
    private static final int FALSE = 41;
    private static final int CURRENT_TIMESTAMP = 42;
    private static final int CURRENT_DATE = 43;
    private static final int CURRENT_TIME = 44;
    private static final int ROWNUM = 45;
    private final Database database;
    private final Session session;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String sqlCommand;
    private String originalSQL;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private Prepared prepared;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ObjectArray parameters;
    private String schemaName;
    private ObjectArray expected;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private ObjectArray indexedParameterList;

    public Parser(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    public Prepared prepare(String sql) throws SQLException {
        try {
            Prepared p = this.parse(sql);
            p.prepare();
            return p;
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public Prepared parseOnly(String sql) throws SQLException {
        try {
            return this.parse(sql);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public Command prepareCommand(String sql) throws SQLException {
        try {
            Prepared p = this.parse(sql);
            p.prepare();
            Command c = new CommandContainer(this, sql, p);
            p.setCommand(c);
            if (this.isToken(";")) {
                String remaining = this.originalSQL.substring(this.parseIndex);
                if (remaining.trim().length() != 0) {
                    CommandList list = new CommandList(this, sql, c, remaining);
                    c = list;
                }
            } else if (this.currentTokenType != 4) {
                throw this.getSyntaxError();
            }
            return c;
        }
        catch (Exception e) {
            throw Message.addSQL(Message.convert(e), this.originalSQL);
        }
    }

    private Prepared parse(String sql) throws SQLException {
        Prepared p;
        try {
            p = this.parse(sql, false);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 42000) {
                p = this.parse(sql, true);
            }
            throw Message.addSQL(e, sql);
        }
        p.setPrepareAlways(this.recompileAlways);
        p.setParameterList(this.parameters);
        return p;
    }

    private Prepared parse(String sql, boolean withExpectedList) throws SQLException {
        this.initialize(sql);
        this.expected = withExpectedList ? new ObjectArray() : null;
        this.parameters = new ObjectArray();
        this.currentSelect = null;
        this.currentPrepared = null;
        this.prepared = null;
        this.recompileAlways = false;
        this.indexedParameterList = null;
        this.read();
        return this.parsePrepared();
    }

    private Prepared parsePrepared() throws SQLException {
        int start = this.lastParseIndex;
        Prepared c = null;
        String token = this.currentToken;
        if (token.length() == 0) {
            c = new NoOperation(this.session);
        } else {
            char first = token.charAt(0);
            switch (first) {
                case '(': {
                    c = this.parseSelect();
                    break;
                }
                case 'A': {
                    if (this.readIf("ALTER")) {
                        c = this.parseAlter();
                        break;
                    }
                    if (!this.readIf("ANALYZE")) break;
                    c = this.parseAnalyze();
                    break;
                }
                case 'B': {
                    if (this.readIf("BACKUP")) {
                        c = this.parseBackup();
                        break;
                    }
                    if (!this.readIf("BEGIN")) break;
                    c = this.parseBegin();
                    break;
                }
                case 'C': {
                    if (this.readIf("COMMIT")) {
                        c = this.parseCommit();
                        break;
                    }
                    if (this.readIf("CREATE")) {
                        c = this.parseCreate();
                        break;
                    }
                    if (this.readIf("CALL")) {
                        c = this.parserCall();
                        break;
                    }
                    if (this.readIf("CHECKPOINT")) {
                        c = this.parseCheckpoint();
                        break;
                    }
                    if (!this.readIf("COMMENT")) break;
                    c = this.parseComment();
                    break;
                }
                case 'D': {
                    if (this.readIf("DELETE")) {
                        c = this.parseDelete();
                        break;
                    }
                    if (this.readIf("DROP")) {
                        c = this.parseDrop();
                        break;
                    }
                    if (this.readIf("DECLARE")) {
                        c = this.parseCreate();
                        break;
                    }
                    if (!this.readIf("DEALLOCATE")) break;
                    c = this.parseDeallocate();
                    break;
                }
                case 'E': {
                    if (this.readIf("EXPLAIN")) {
                        c = this.parseExplain();
                        break;
                    }
                    if (!this.readIf("EXECUTE")) break;
                    c = this.parseExecute();
                    break;
                }
                case 'F': {
                    if (!this.isToken("FROM")) break;
                    c = this.parseSelect();
                    break;
                }
                case 'G': {
                    if (!this.readIf("GRANT")) break;
                    c = this.parseGrantRevoke(0);
                    break;
                }
                case 'H': {
                    if (!this.readIf("HELP")) break;
                    c = this.parseHelp();
                    break;
                }
                case 'I': {
                    if (!this.readIf("INSERT")) break;
                    c = this.parseInsert();
                    break;
                }
                case 'M': {
                    if (!this.readIf("MERGE")) break;
                    c = this.parseMerge();
                    break;
                }
                case 'P': {
                    if (!this.readIf("PREPARE")) break;
                    c = this.parsePrepare();
                    break;
                }
                case 'R': {
                    if (this.readIf("ROLLBACK")) {
                        c = this.parseRollback();
                        break;
                    }
                    if (this.readIf("REVOKE")) {
                        c = this.parseGrantRevoke(1);
                        break;
                    }
                    if (this.readIf("RUNSCRIPT")) {
                        c = this.parseRunScript();
                        break;
                    }
                    if (!this.readIf("RELEASE")) break;
                    c = this.parseReleaseSavepoint();
                    break;
                }
                case 'S': {
                    if (this.isToken("SELECT")) {
                        c = this.parseSelect();
                        break;
                    }
                    if (this.readIf("SET")) {
                        c = this.parseSet();
                        break;
                    }
                    if (this.readIf("SAVEPOINT")) {
                        c = this.parseSavepoint();
                        break;
                    }
                    if (this.readIf("SCRIPT")) {
                        c = this.parseScript();
                        break;
                    }
                    if (!this.readIf("SHUTDOWN")) break;
                    c = this.parseShutdown();
                    break;
                }
                case 'T': {
                    if (!this.readIf("TRUNCATE")) break;
                    c = this.parseTruncate();
                    break;
                }
                case 'U': {
                    if (!this.readIf("UPDATE")) break;
                    c = this.parseUpdate();
                    break;
                }
                case 'V': {
                    if (!this.readIf("VALUES")) break;
                    c = this.parserCall();
                    break;
                }
                case 'W': {
                    if (!this.readIf("WITH")) break;
                    c = this.parserWith();
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (this.indexedParameterList != null) {
                for (int i = 0; i < this.indexedParameterList.size(); ++i) {
                    if (this.indexedParameterList.get(i) != null) continue;
                    this.indexedParameterList.set(i, new Parameter(i));
                }
                this.parameters = this.indexedParameterList;
            }
            if (this.readIf("{")) {
                do {
                    int index;
                    if ((index = (int)this.readLong() - 1) < 0 || index >= this.parameters.size()) {
                        throw this.getSyntaxError();
                    }
                    Parameter p = (Parameter)this.parameters.get(index);
                    if (p == null) {
                        throw this.getSyntaxError();
                    }
                    this.read(":");
                    Expression expr = this.readExpression();
                    expr = expr.optimize(this.session);
                    p.setValue(expr.getValue(this.session));
                    ++index;
                } while (this.readIf(","));
                this.read("}");
                int len = this.parameters.size();
                for (int i = 0; i < len; ++i) {
                    Parameter p = (Parameter)this.parameters.get(i);
                    p.checkSet();
                }
                this.parameters.clear();
            }
        }
        if (c == null) {
            throw this.getSyntaxError();
        }
        this.setSQL(c, null, start);
        return c;
    }

    private SQLException getSyntaxError() {
        if (this.expected == null || this.expected.size() == 0) {
            return Message.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.expected.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.expected.get(i));
        }
        return Message.getSyntaxError(this.sqlCommand, this.parseIndex, buff.toString());
    }

    private Prepared parseBackup() throws SQLException {
        BackupCommand command = new BackupCommand(this.session);
        this.read("TO");
        command.setFileName(this.readString());
        return command;
    }

    private Prepared parseAnalyze() throws SQLException {
        Analyze command = new Analyze(this.session);
        if (this.readIf("SAMPLE_SIZE")) {
            command.setTop(this.getPositiveInt());
        }
        return command;
    }

    private TransactionCommand parseBegin() throws SQLException {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand command = new TransactionCommand(this.session, 14);
        return command;
    }

    private TransactionCommand parseCommit() throws SQLException {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command = new TransactionCommand(this.session, 10);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        TransactionCommand command = new TransactionCommand(this.session, 3);
        this.readIf("WORK");
        return command;
    }

    private TransactionCommand parseShutdown() throws SQLException {
        int type = 12;
        if (this.readIf("IMMEDIATELY")) {
            type = 13;
        } else if (!this.readIf("COMPACT")) {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, type);
    }

    private TransactionCommand parseRollback() throws SQLException {
        TransactionCommand command;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command2 = new TransactionCommand(this.session, 11);
            command2.setTransactionName(this.readUniqueIdentifier());
            return command2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            command = new TransactionCommand(this.session, 7);
            command.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            command = new TransactionCommand(this.session, 4);
        }
        return command;
    }

    private Prepared parsePrepare() throws SQLException {
        if (this.readIf("COMMIT")) {
            TransactionCommand command = new TransactionCommand(this.session, 9);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        String procedureName = this.readAliasIdentifier();
        if (this.readIf("(")) {
            ObjectArray list = new ObjectArray();
            int i = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + i);
                list.add(column);
                if (this.readIf(")")) break;
                this.read(",");
                ++i;
            }
        }
        this.read("AS");
        Prepared prep = this.parsePrepared();
        PrepareProcedure command = new PrepareProcedure(this.session);
        command.setProcedureName(procedureName);
        command.setPrepared(prep);
        return command;
    }

    private TransactionCommand parseSavepoint() throws SQLException {
        TransactionCommand command = new TransactionCommand(this.session, 6);
        command.setSavepointName(this.readUniqueIdentifier());
        return command;
    }

    private Prepared parseReleaseSavepoint() throws SQLException {
        NoOperation command = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return command;
    }

    private Schema getSchema() throws SQLException {
        if (this.schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(this.schemaName);
        if (schema == null) {
            if ("SESSION".equals(this.schemaName)) {
                schema = this.database.getSchema(this.session.getCurrentSchemaName());
            } else {
                throw Message.getSQLException(90079, this.schemaName);
            }
        }
        return schema;
    }

    private Column readTableColumn(TableFilter filter) throws SQLException {
        String tableAlias = null;
        String columnName = this.readColumnIdentifier();
        if (this.readIf(".")) {
            tableAlias = columnName;
            columnName = this.readColumnIdentifier();
            if (this.readIf(".")) {
                String schemaName = tableAlias;
                tableAlias = columnName;
                columnName = this.readColumnIdentifier();
                if (this.readIf(".")) {
                    String catalogName = schemaName;
                    schemaName = tableAlias;
                    tableAlias = columnName;
                    columnName = this.readColumnIdentifier();
                    if (!catalogName.equals(this.database.getShortName())) {
                        throw Message.getSQLException(90013, catalogName);
                    }
                }
                if (!schemaName.equals(filter.getTable().getSchema().getName())) {
                    throw Message.getSQLException(90079, schemaName);
                }
            }
            if (!tableAlias.equals(filter.getTableAlias())) {
                throw Message.getSQLException(42102, tableAlias);
            }
        }
        return filter.getTable().getColumn(columnName);
    }

    private Update parseUpdate() throws SQLException {
        Update command = new Update(this.session);
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        TableFilter filter = this.readSimpleTableFilter();
        command.setTableFilter(filter);
        this.read("SET");
        if (this.readIf("(")) {
            ObjectArray columns = new ObjectArray();
            do {
                Column column = this.readTableColumn(filter);
                columns.add(column);
            } while (this.readIf(","));
            this.read(")");
            this.read("=");
            Expression expression = this.readExpression();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                Function f = Function.getFunction(this.database, "ARRAY_GET");
                f.setParameter(0, expression);
                f.setParameter(1, ValueExpression.get(ValueInt.get(i + 1)));
                f.doneWithParameters();
                command.setAssignment(column, f);
            }
        } else {
            do {
                Column column = this.readTableColumn(filter);
                this.read("=");
                Expression expression = this.readExpression();
                command.setAssignment(column, expression);
            } while (this.readIf(","));
        }
        if (this.readIf("WHERE")) {
            Expression condition = this.readExpression();
            command.setCondition(condition);
        }
        this.setSQL(command, "UPDATE", start);
        return command;
    }

    private TableFilter readSimpleTableFilter() throws SQLException {
        Table table = this.readTableOrView();
        String alias = null;
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (this.currentTokenType == 2 && !"SET".equals(this.currentToken)) {
            alias = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect);
    }

    private Delete parseDelete() throws SQLException {
        Delete command = new Delete(this.session);
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        this.readIf("FROM");
        TableFilter filter = this.readSimpleTableFilter();
        command.setTableFilter(filter);
        if (this.readIf("WHERE")) {
            Expression condition = this.readExpression();
            command.setCondition(condition);
        }
        this.setSQL(command, "DELETE", start);
        return command;
    }

    private IndexColumn[] parseIndexColumnList() throws SQLException {
        ObjectArray columns = new ObjectArray();
        do {
            IndexColumn column = new IndexColumn();
            column.columnName = this.readColumnIdentifier();
            columns.add(column);
            if (!this.readIf("ASC") && this.readIf("DESC")) {
                column.sortType = 1;
            }
            if (!this.readIf("NULLS")) continue;
            if (this.readIf("FIRST")) {
                column.sortType |= 2;
                continue;
            }
            this.read("LAST");
            column.sortType |= 4;
        } while (this.readIf(","));
        this.read(")");
        Object[] cols = new IndexColumn[columns.size()];
        columns.toArray(cols);
        return cols;
    }

    private String[] parseColumnList() throws SQLException {
        ObjectArray columns = new ObjectArray();
        do {
            String columnName = this.readColumnIdentifier();
            columns.add(columnName);
        } while (this.readIf(","));
        this.read(")");
        Object[] cols = new String[columns.size()];
        columns.toArray(cols);
        return cols;
    }

    private Column[] parseColumnList(Table table) throws SQLException {
        ObjectArray columns = new ObjectArray();
        HashSet<Column> set = new HashSet<Column>();
        if (!this.readIf(")")) {
            do {
                Column column;
                if (!set.add(column = table.getColumn(this.readColumnIdentifier()))) {
                    throw Message.getSQLException(42121, column.getSQL());
                }
                columns.add(column);
            } while (this.readIf(","));
            this.read(")");
        }
        Object[] cols = new Column[columns.size()];
        columns.toArray(cols);
        return cols;
    }

    private Prepared parseHelp() throws SQLException {
        StringBuffer buff = new StringBuffer("SELECT * FROM INFORMATION_SCHEMA.HELP");
        int i = 0;
        while (this.currentTokenType != 4) {
            String s = this.currentToken;
            this.read();
            if (i == 0) {
                buff.append(" WHERE ");
            } else {
                buff.append(" AND ");
            }
            ++i;
            buff.append("UPPER(TOPIC) LIKE ");
            buff.append(StringUtils.quoteStringSQL("%" + s + "%"));
        }
        return this.session.prepare(buff.toString());
    }

    private Merge parseMerge() throws SQLException {
        Merge command = new Merge(this.session);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        if (this.readIf("(")) {
            Column[] columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("KEY")) {
            this.read("(");
            Column[] keys = this.parseColumnList(table);
            command.setKeys(keys);
        }
        if (this.readIf("VALUES")) {
            do {
                ObjectArray values = new ObjectArray();
                this.read("(");
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            values.add(null);
                            continue;
                        }
                        values.add(this.readExpression());
                    } while (this.readIf(","));
                    this.read(")");
                }
                Object[] expr = new Expression[values.size()];
                values.toArray(expr);
                command.addRow((Expression[])expr);
            } while (this.readIf(","));
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    private Insert parseInsert() throws SQLException {
        Insert command = new Insert(this.session);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        if (this.readIf("(")) {
            Column[] columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("DEFAULT")) {
            this.read("VALUES");
            Expression[] expr = new Expression[]{};
            command.addRow(expr);
        } else if (this.readIf("VALUES")) {
            do {
                ObjectArray values = new ObjectArray();
                this.read("(");
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            values.add(null);
                            continue;
                        }
                        values.add(this.readExpression());
                    } while (this.readIf(","));
                    this.read(")");
                }
                Object[] expr = new Expression[values.size()];
                values.toArray(expr);
                command.addRow((Expression[])expr);
            } while (this.readIf(","));
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter(boolean fromOuter) throws SQLException {
        Table table;
        String alias;
        block10: {
            alias = null;
            Schema mainSchema = this.database.getSchema("PUBLIC");
            if (this.readIf("(")) {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    int start = this.lastParseIndex;
                    int paramIndex = this.parameters.size();
                    Query query = this.parseSelectUnion();
                    this.read(")");
                    query = this.parseSelectUnionExtension(query, start);
                    ObjectArray params = new ObjectArray();
                    for (int i = paramIndex; i < this.parameters.size(); ++i) {
                        params.add(this.parameters.get(i));
                    }
                    query.setParameterList(params);
                    query.init();
                    Session s = this.prepared != null && this.prepared instanceof CreateView ? this.database.getSystemSession() : this.session;
                    table = TableView.createTempView(s, this.session.getUser(), query);
                    alias = table.getName();
                    break block10;
                } else {
                    TableFilter top = this.readTableFilter(fromOuter);
                    top = this.readJoin(top, this.currentSelect, fromOuter);
                    this.read(")");
                    alias = this.readFromAlias(null);
                    if (alias != null) {
                        top.setAlias(alias);
                    }
                    return top;
                }
            }
            String tableName = this.readIdentifierWithSchema(null);
            if (this.readIf("(")) {
                if (tableName.equals("SYSTEM_RANGE")) {
                    long min = this.readLong();
                    this.read(",");
                    long max = this.readLong();
                    this.read(")");
                    table = new RangeTable(mainSchema, min, max);
                } else {
                    Expression func = this.readFunction(tableName);
                    if (!(func instanceof FunctionCall)) {
                        throw this.getSyntaxError();
                    }
                    table = new FunctionTable(mainSchema, this.session, (FunctionCall)((Object)func));
                }
            } else {
                table = "DUAL".equals(tableName) ? new RangeTable(mainSchema, 1L, 1L) : this.readTableOrView(tableName);
            }
        }
        alias = this.readFromAlias(alias);
        return new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect);
    }

    String readFromAlias(String alias) throws SQLException {
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || this.isToken("LEFT") || this.isToken("RIGHT") || this.isToken("FULL"))) {
            alias = this.readAliasIdentifier();
        }
        return alias;
    }

    private Prepared parseTruncate() throws SQLException {
        this.read("TABLE");
        Table table = this.readTableOrView();
        TruncateTable command = new TruncateTable(this.session);
        command.setTable(table);
        return command;
    }

    private boolean readIfExists(boolean ifExists) throws SQLException {
        if (this.readIf("IF")) {
            this.read("EXISTS");
            ifExists = true;
        }
        return ifExists;
    }

    private Prepared parseComment() throws SQLException {
        int type = 0;
        this.read("ON");
        boolean column = false;
        if (this.readIf("TABLE") || this.readIf("VIEW")) {
            type = 0;
        } else if (this.readIf("COLUMN")) {
            column = true;
            type = 0;
        } else if (this.readIf("CONSTANT")) {
            type = 11;
        } else if (this.readIf("CONSTRAINT")) {
            type = 5;
        } else if (this.readIf("ALIAS")) {
            type = 9;
        } else if (this.readIf("INDEX")) {
            type = 1;
        } else if (this.readIf("ROLE")) {
            type = 7;
        } else if (this.readIf("SCHEMA")) {
            type = 10;
        } else if (this.readIf("SEQUENCE")) {
            type = 3;
        } else if (this.readIf("TRIGGER")) {
            type = 4;
        } else if (this.readIf("USER")) {
            type = 2;
        } else if (this.readIf("DOMAIN")) {
            type = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment command = new SetComment(this.session);
        String objectName = this.readIdentifierWithSchema();
        if (column) {
            String columnName = objectName;
            objectName = this.schemaName;
            this.schemaName = this.session.getCurrentSchemaName();
            if (this.readIf(".")) {
                this.schemaName = objectName;
                objectName = columnName;
                columnName = this.readUniqueIdentifier();
            }
            command.setColumn(true);
            command.setColumnName(columnName);
        }
        command.setSchemaName(this.schemaName);
        command.setObjectName(objectName);
        command.setObjectType(type);
        this.read("IS");
        command.setCommentExpression(this.readExpression());
        return command;
    }

    private Prepared parseDrop() throws SQLException {
        if (this.readIf("TABLE")) {
            boolean ifExists = this.readIfExists(false);
            String tableName = this.readIdentifierWithSchema();
            DropTable command = new DropTable(this.session, this.getSchema());
            command.setTableName(tableName);
            while (this.readIf(",")) {
                tableName = this.readIdentifierWithSchema();
                DropTable next = new DropTable(this.session, this.getSchema());
                next.setTableName(tableName);
                command.addNextDropTable(next);
            }
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf("CASCADE")) {
                this.readIf("CONSTRAINTS");
            }
            return command;
        }
        if (this.readIf("INDEX")) {
            boolean ifExists = this.readIfExists(false);
            String indexName = this.readIdentifierWithSchema();
            DropIndex command = new DropIndex(this.session, this.getSchema());
            command.setIndexName(indexName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("USER")) {
            boolean ifExists = this.readIfExists(false);
            DropUser command = new DropUser(this.session);
            command.setUserName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            this.readIf("CASCADE");
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SEQUENCE")) {
            boolean ifExists = this.readIfExists(false);
            String sequenceName = this.readIdentifierWithSchema();
            DropSequence command = new DropSequence(this.session, this.getSchema());
            command.setSequenceName(sequenceName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("CONSTANT")) {
            boolean ifExists = this.readIfExists(false);
            String constantName = this.readIdentifierWithSchema();
            DropConstant command = new DropConstant(this.session, this.getSchema());
            command.setConstantName(constantName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("TRIGGER")) {
            boolean ifExists = this.readIfExists(false);
            String triggerName = this.readIdentifierWithSchema();
            DropTrigger command = new DropTrigger(this.session, this.getSchema());
            command.setTriggerName(triggerName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("VIEW")) {
            boolean ifExists = this.readIfExists(false);
            String viewName = this.readIdentifierWithSchema();
            DropView command = new DropView(this.session, this.getSchema());
            command.setViewName(viewName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ROLE")) {
            boolean ifExists = this.readIfExists(false);
            DropRole command = new DropRole(this.session);
            command.setRoleName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALIAS")) {
            boolean ifExists = this.readIfExists(false);
            DropFunctionAlias command = new DropFunctionAlias(this.session);
            command.setAliasName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SCHEMA")) {
            boolean ifExists = this.readIfExists(false);
            DropSchema command = new DropSchema(this.session);
            command.setSchemaName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALL")) {
            this.read("OBJECTS");
            DropDatabase command = new DropDatabase(this.session);
            command.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                command.setDeleteFiles(true);
            }
            return command;
        }
        if (this.readIf("DOMAIN")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        throw this.getSyntaxError();
    }

    DropUserDataType parseDropUserDataType() throws SQLException {
        boolean ifExists = this.readIfExists(false);
        DropUserDataType command = new DropUserDataType(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    DropAggregate parseDropAggregate() throws SQLException {
        boolean ifExists = this.readIfExists(false);
        DropAggregate command = new DropAggregate(this.session);
        command.setName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    private TableFilter readJoin(TableFilter top, Select command, boolean fromOuter) throws SQLException {
        TableFilter last = top;
        while (true) {
            TableFilter join;
            Expression on;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                TableFilter newTop = this.readTableFilter(fromOuter);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                newTop.addJoin(top, true, on);
                top = newTop;
                last = newTop;
                continue;
            }
            if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                join = this.readTableFilter(true);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, true, on);
                last = join;
                continue;
            }
            if (this.readIf("FULL")) {
                throw this.getSyntaxError();
            }
            if (this.readIf("INNER")) {
                this.read("JOIN");
                join = this.readTableFilter(fromOuter);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, fromOuter, on);
                last = join;
                continue;
            }
            if (this.readIf("JOIN")) {
                join = this.readTableFilter(fromOuter);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, fromOuter, on);
                last = join;
                continue;
            }
            if (this.readIf("CROSS")) {
                this.read("JOIN");
                join = this.readTableFilter(fromOuter);
                top.addJoin(join, fromOuter, null);
                last = join;
                continue;
            }
            if (!this.readIf("NATURAL")) break;
            this.read("JOIN");
            join = this.readTableFilter(fromOuter);
            Column[] tableCols = last.getTable().getColumns();
            Column[] joinCols = join.getTable().getColumns();
            String tableSchema = last.getTable().getSchema().getName();
            String joinSchema = join.getTable().getSchema().getName();
            Condition on2 = null;
            for (int t = 0; t < tableCols.length; ++t) {
                String tableColumnName = tableCols[t].getName();
                for (int j = 0; j < joinCols.length; ++j) {
                    String joinColumnName = joinCols[j].getName();
                    if (!tableColumnName.equals(joinColumnName)) continue;
                    ExpressionColumn tableExpr = new ExpressionColumn(this.database, tableSchema, last.getTableAlias(), tableColumnName);
                    ExpressionColumn joinExpr = new ExpressionColumn(this.database, joinSchema, join.getTableAlias(), joinColumnName);
                    Comparison equal = new Comparison(this.session, 0, tableExpr, joinExpr);
                    on2 = on2 == null ? equal : new ConditionAndOr(0, on2, equal);
                }
            }
            top.addJoin(join, fromOuter, on2);
            last = join;
        }
        return top;
    }

    private Prepared parseExecute() throws SQLException {
        ExecuteProcedure command = new ExecuteProcedure(this.session);
        String procedureName = this.readAliasIdentifier();
        Procedure p = this.session.getProcedure(procedureName);
        if (p == null) {
            throw Message.getSQLException(90077, procedureName);
        }
        command.setProcedure(p);
        if (this.readIf("(")) {
            int i = 0;
            while (true) {
                command.setExpression(i, this.readExpression());
                if (this.readIf(")")) break;
                this.read(",");
                ++i;
            }
        }
        return command;
    }

    private DeallocateProcedure parseDeallocate() throws SQLException {
        this.readIf("PLAN");
        String procedureName = this.readAliasIdentifier();
        DeallocateProcedure command = new DeallocateProcedure(this.session);
        command.setProcedureName(procedureName);
        return command;
    }

    private ExplainPlan parseExplain() throws SQLException {
        ExplainPlan command = new ExplainPlan(this.session);
        this.readIf("PLAN");
        this.readIf("FOR");
        if (this.isToken("SELECT") || this.isToken("FROM") || this.isToken("(")) {
            command.setCommand(this.parseSelect());
        } else if (this.readIf("DELETE")) {
            command.setCommand(this.parseDelete());
        } else if (this.readIf("UPDATE")) {
            command.setCommand(this.parseUpdate());
        } else if (this.readIf("INSERT")) {
            command.setCommand(this.parseInsert());
        } else if (this.readIf("MERGE")) {
            command.setCommand(this.parseMerge());
        } else {
            throw this.getSyntaxError();
        }
        return command;
    }

    private Query parseSelect() throws SQLException {
        int paramIndex = this.parameters.size();
        Query command = this.parseSelectUnion();
        ObjectArray params = new ObjectArray();
        for (int i = paramIndex; i < this.parameters.size(); ++i) {
            params.add(this.parameters.get(i));
        }
        command.setParameterList(params);
        command.init();
        return command;
    }

    private Query parseSelectUnion() throws SQLException {
        int start = this.lastParseIndex;
        Query command = this.parseSelectSub();
        return this.parseSelectUnionExtension(command, start);
    }

    private Query parseSelectUnionExtension(Query command, int start) throws SQLException {
        while (true) {
            SelectUnion union;
            if (this.readIf("UNION")) {
                union = new SelectUnion(this.session, command);
                if (this.readIf("ALL")) {
                    union.setUnionType(1);
                } else {
                    this.readIf("DISTINCT");
                    union.setUnionType(0);
                }
                union.setRight(this.parseSelectSub());
                command = union;
                continue;
            }
            if (this.readIf("MINUS") || this.readIf("EXCEPT")) {
                union = new SelectUnion(this.session, command);
                union.setUnionType(2);
                union.setRight(this.parseSelectSub());
                command = union;
                continue;
            }
            if (!this.readIf("INTERSECT")) break;
            union = new SelectUnion(this.session, command);
            union.setUnionType(3);
            union.setRight(this.parseSelectSub());
            command = union;
        }
        if (this.readIf("ORDER")) {
            this.read("BY");
            Select oldSelect = this.currentSelect;
            if (command instanceof Select) {
                this.currentSelect = (Select)command;
            }
            ObjectArray orderList = new ObjectArray();
            do {
                boolean canBeNumber = true;
                if (this.readIf("=")) {
                    canBeNumber = false;
                }
                SelectOrderBy order = new SelectOrderBy();
                Expression expr = this.readExpression();
                if (canBeNumber && expr instanceof ValueExpression && expr.getType() == 4) {
                    order.columnIndexExpr = expr;
                } else if (expr instanceof Parameter) {
                    this.recompileAlways = true;
                    order.columnIndexExpr = expr;
                } else {
                    order.expression = expr;
                }
                if (this.readIf("DESC")) {
                    order.descending = true;
                } else {
                    this.readIf("ASC");
                }
                if (this.readIf("NULLS")) {
                    if (this.readIf("FIRST")) {
                        order.nullsFirst = true;
                    } else {
                        this.read("LAST");
                        order.nullsLast = true;
                    }
                }
                orderList.add(order);
            } while (this.readIf(","));
            command.setOrder(orderList);
            this.currentSelect = oldSelect;
        }
        if (this.readIf("LIMIT")) {
            Expression offset;
            Expression limit = this.readExpression().optimize(this.session);
            command.setLimit(limit);
            if (this.readIf("OFFSET")) {
                offset = this.readExpression().optimize(this.session);
                command.setOffset(offset);
            } else if (this.readIf(",")) {
                offset = limit;
                limit = this.readExpression().optimize(this.session);
                command.setOffset(offset);
                command.setLimit(limit);
            }
            if (this.readIf("SAMPLE_SIZE")) {
                command.setSampleSize(this.getPositiveInt());
            }
        }
        if (this.readIf("FOR")) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(","));
                } else if (!this.readIf("NOWAIT") && this.readIf("WITH")) {
                    this.read("RR");
                }
                command.setForUpdate(true);
            } else if (this.readIf("READ")) {
                this.read("ONLY");
                if (this.readIf("WITH")) {
                    this.read("RS");
                }
            }
        }
        this.setSQL(command, null, start);
        return command;
    }

    private Query parseSelectSub() throws SQLException {
        if (this.readIf("(")) {
            Query command = this.parseSelectUnion();
            this.read(")");
            return command;
        }
        Select select = this.parseSelectSimple();
        return select;
    }

    private void parseSelectSimpleFromPart(Select command) throws SQLException {
        do {
            TableFilter filter = this.readTableFilter(false);
            this.parseJoinTableFilter(filter, command);
        } while (this.readIf(","));
    }

    private void parseJoinTableFilter(TableFilter top, Select command) throws SQLException {
        TableFilter join;
        top = this.readJoin(top, command, top.isJoinOuter());
        command.addTableFilter(top, true);
        boolean isOuter = false;
        while ((join = top.getJoin()) != null) {
            if (isOuter |= join.isJoinOuter()) {
                command.addTableFilter(join, false);
            } else {
                Expression on = join.getJoinCondition();
                if (on != null) {
                    command.addCondition(on);
                }
                join.removeJoinCondition();
                top.removeJoin();
                command.addTableFilter(join, true);
            }
            top = join;
        }
    }

    private void parseSelectSimpleSelectPart(Select command) throws SQLException {
        if (this.readIf("TOP")) {
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        } else if (this.readIf("LIMIT")) {
            Expression offset = this.readTerm().optimize(this.session);
            command.setOffset(offset);
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        }
        if (this.readIf("DISTINCT")) {
            command.setDistinct(true);
        } else {
            this.readIf("ALL");
        }
        ObjectArray expressions = new ObjectArray();
        do {
            if (this.readIf("*")) {
                expressions.add(new Wildcard(null, null));
                continue;
            }
            Expression expr = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String alias = this.readAliasIdentifier();
                expr = new Alias(expr, alias);
            }
            expressions.add(expr);
        } while (this.readIf(","));
        command.setExpressions(expressions);
    }

    /*
     * WARNING - void declaration
     */
    private Select parseSelectSimple() throws SQLException {
        Expression condition;
        void var1_1;
        boolean fromFirst;
        if (this.readIf("SELECT")) {
            fromFirst = false;
        } else if (this.readIf("FROM")) {
            fromFirst = true;
        } else {
            throw this.getSyntaxError();
        }
        Select command = new Select(this.session);
        int start = this.lastParseIndex;
        Select oldSelect = this.currentSelect;
        this.currentSelect = command;
        this.currentPrepared = command;
        if (var1_1 != false) {
            this.parseSelectSimpleFromPart(command);
            this.read("SELECT");
            this.parseSelectSimpleSelectPart(command);
        } else {
            this.parseSelectSimpleSelectPart(command);
            if (!this.readIf("FROM")) {
                Schema main = this.database.findSchema("PUBLIC");
                RangeTable dual = new RangeTable(main, 1L, 1L);
                TableFilter filter = new TableFilter(this.session, dual, null, this.rightsChecked, this.currentSelect);
                command.addTableFilter(filter, true);
            } else {
                this.parseSelectSimpleFromPart(command);
            }
        }
        if (this.readIf("WHERE")) {
            condition = this.readExpression();
            command.addCondition(condition);
        }
        this.currentSelect = oldSelect;
        if (this.readIf("GROUP")) {
            this.read("BY");
            command.setGroupQuery();
            ObjectArray list = new ObjectArray();
            do {
                Expression expr = this.readExpression();
                list.add(expr);
            } while (this.readIf(","));
            command.setGroupBy(list);
        }
        this.currentSelect = command;
        if (this.readIf("HAVING")) {
            command.setGroupQuery();
            condition = this.readExpression();
            command.setHaving(condition);
        }
        command.setParameterList(this.parameters);
        this.currentSelect = oldSelect;
        this.setSQL(command, "SELECT", start);
        return command;
    }

    private void setSQL(Prepared command, String start, int startIndex) {
        String sql = this.originalSQL.substring(startIndex, this.lastParseIndex).trim();
        if (start != null) {
            sql = start + " " + sql;
        }
        command.setSQL(sql);
    }

    private Expression readExpression() throws SQLException {
        Expression r = this.readAnd();
        while (this.readIf("OR")) {
            r = new ConditionAndOr(1, r, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws SQLException {
        Expression r = this.readCondition();
        while (this.readIf("AND")) {
            r = new ConditionAndOr(0, r, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws SQLException {
        if (this.readIf("NOT")) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf("EXISTS")) {
            this.read("(");
            Query query = this.parseSelect();
            this.read(")");
            return new ConditionExists(query);
        }
        Expression r = this.readConcat();
        while (true) {
            int backup = this.parseIndex;
            boolean not = false;
            if (this.readIf("NOT")) {
                not = true;
                if (this.isToken("NULL")) {
                    this.parseIndex = backup;
                    this.currentToken = "NOT";
                    break;
                }
            }
            if (this.readIf("LIKE")) {
                Expression b = this.readConcat();
                Expression esc = null;
                if (this.readIf("ESCAPE")) {
                    esc = this.readConcat();
                }
                this.recompileAlways = true;
                r = new CompareLike(this.database.getCompareMode(), r, b, esc, false);
            } else if (this.readIf("REGEXP")) {
                Expression b = this.readConcat();
                r = new CompareLike(this.database.getCompareMode(), r, b, null, true);
            } else if (this.readIf("IS")) {
                int type = this.readIf("NOT") ? 7 : 6;
                this.read("NULL");
                r = new Comparison(this.session, type, r, null);
            } else if (this.readIf("IN")) {
                if (SysProperties.OPTIMIZE_IN) {
                    this.recompileAlways = true;
                }
                this.read("(");
                if (this.readIf(")")) {
                    r = ValueExpression.get(ValueBoolean.get(false));
                } else {
                    if (this.isToken("SELECT") || this.isToken("FROM")) {
                        Query query = this.parseSelect();
                        r = new ConditionInSelect(this.database, r, query, false, 0);
                    } else {
                        Expression last;
                        ObjectArray v = new ObjectArray();
                        do {
                            last = this.readExpression();
                            v.add(last);
                        } while (this.readIf(","));
                        if (v.size() == 1 && last instanceof Subquery) {
                            Subquery s = (Subquery)last;
                            Query q = s.getQuery();
                            r = new ConditionInSelect(this.database, r, q, false, 0);
                        } else {
                            r = new ConditionIn(this.database, r, v);
                        }
                    }
                    this.read(")");
                }
            } else if (this.readIf("BETWEEN")) {
                Expression low = this.readConcat();
                this.read("AND");
                Expression high = this.readConcat();
                Comparison condLow = new Comparison(this.session, 3, low, r);
                Comparison condHigh = new Comparison(this.session, 1, high, r);
                r = new ConditionAndOr(0, condLow, condHigh);
            } else {
                Query query;
                int compareType = this.getCompareType(this.currentTokenType);
                if (compareType < 0) break;
                this.read();
                if (this.readIf("ALL")) {
                    this.read("(");
                    query = this.parseSelect();
                    r = new ConditionInSelect(this.database, r, query, true, compareType);
                    this.read(")");
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read("(");
                    query = this.parseSelect();
                    r = new ConditionInSelect(this.database, r, query, false, compareType);
                    this.read(")");
                } else {
                    Expression right = this.readConcat();
                    if (this.readIf("(") && this.readIf("+") && this.readIf(")")) {
                        if (r instanceof ExpressionColumn && right instanceof ExpressionColumn) {
                            ExpressionColumn leftCol = (ExpressionColumn)r;
                            ExpressionColumn rightCol = (ExpressionColumn)right;
                            ObjectArray filters = this.currentSelect.getTopFilters();
                            for (int i = 0; filters != null && i < filters.size(); ++i) {
                                TableFilter f = (TableFilter)filters.get(i);
                                leftCol.mapColumns(f, 0);
                                rightCol.mapColumns(f, 0);
                            }
                            TableFilter leftFilter = leftCol.getTableFilter();
                            TableFilter rightFilter = rightCol.getTableFilter();
                            r = new Comparison(this.session, compareType, r, right);
                            if (leftFilter != null && rightFilter != null) {
                                filters.remove(filters.indexOf(rightFilter));
                                leftFilter.addJoin(rightFilter, true, r);
                                r = ValueExpression.get(ValueBoolean.get(true));
                            }
                        }
                    } else {
                        r = new Comparison(this.session, compareType, r, right);
                    }
                }
            }
            if (!not) continue;
            r = new ConditionNot(r);
        }
        return r;
    }

    private Expression readConcat() throws SQLException {
        Expression r = this.readSum();
        while (true) {
            Function function;
            if (this.readIf("||")) {
                r = new Operation(0, r, this.readSum());
                continue;
            }
            if (this.readIf("~")) {
                if (this.readIf("*")) {
                    function = Function.getFunction(this.database, "CAST");
                    function.setDataType(new Column("X", 14));
                    function.setParameter(0, r);
                    r = function;
                }
                r = new CompareLike(this.database.getCompareMode(), r, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf("!~")) break;
            if (this.readIf("*")) {
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, r);
                r = function;
            }
            r = new ConditionNot(new CompareLike(this.database.getCompareMode(), r, this.readSum(), null, true));
        }
        return r;
    }

    private Expression readSum() throws SQLException {
        Expression r = this.readFactor();
        while (true) {
            if (this.readIf("+")) {
                r = new Operation(1, r, this.readFactor());
                continue;
            }
            if (!this.readIf("-")) break;
            r = new Operation(2, r, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws SQLException {
        Expression r = this.readTerm();
        while (true) {
            if (this.readIf("*")) {
                r = new Operation(3, r, this.readTerm());
                continue;
            }
            if (!this.readIf("/")) break;
            r = new Operation(4, r, this.readTerm());
        }
        return r;
    }

    private Expression readAggregate(int aggregateType) throws SQLException {
        Aggregate r;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        this.currentSelect.setGroupQuery();
        if (aggregateType == 1) {
            if (this.readIf("*")) {
                r = new Aggregate(this.database, 0, null, this.currentSelect, false);
            } else {
                boolean distinct = this.readIf("DISTINCT");
                Expression on = this.readExpression();
                r = on instanceof Wildcard && !distinct ? new Aggregate(this.database, 0, null, this.currentSelect, false) : new Aggregate(this.database, 1, on, this.currentSelect, distinct);
            }
        } else if (aggregateType == 6) {
            boolean distinct = this.readIf("DISTINCT");
            Aggregate agg = new Aggregate(this.database, 6, this.readExpression(), this.currentSelect, distinct);
            if (this.readIf("ORDER")) {
                this.read("BY");
                agg.setOrder(this.parseSimpleOrderList());
            }
            if (this.readIf("SEPARATOR")) {
                agg.setSeparator(this.readExpression());
            }
            r = agg;
        } else {
            boolean distinct = this.readIf("DISTINCT");
            r = new Aggregate(this.database, aggregateType, this.readExpression(), this.currentSelect, distinct);
        }
        this.read(")");
        return r;
    }

    private ObjectArray parseSimpleOrderList() throws SQLException {
        ObjectArray orderList = new ObjectArray();
        do {
            Expression expr;
            SelectOrderBy order = new SelectOrderBy();
            order.expression = expr = this.readExpression();
            if (this.readIf("DESC")) {
                order.descending = true;
            } else {
                this.readIf("ASC");
            }
            orderList.add(order);
        } while (this.readIf(","));
        return orderList;
    }

    private JavaFunction readJavaFunction(String name) throws SQLException {
        FunctionAlias functionAlias = this.database.findFunctionAlias(name);
        if (functionAlias == null) {
            throw Message.getSQLException(90022, name);
        }
        int paramCount = functionAlias.getParameterCount();
        Expression[] args = new Expression[paramCount];
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.read(",");
            }
            args[i] = this.readExpression();
        }
        this.read(")");
        JavaFunction func = new JavaFunction(functionAlias, args);
        return func;
    }

    private JavaAggregate readJavaAggregate(UserAggregate aggregate) throws SQLException {
        ObjectArray params = new ObjectArray();
        do {
            params.add(this.readExpression());
        } while (this.readIf(","));
        this.read(")");
        Object[] list = new Expression[params.size()];
        params.toArray(list);
        JavaAggregate agg = new JavaAggregate(aggregate, (Expression[])list, this.currentSelect);
        this.currentSelect.setGroupQuery();
        return agg;
    }

    private Expression readFunction(String name) throws SQLException {
        int agg = Aggregate.getAggregateType(name);
        if (agg >= 0) {
            return this.readAggregate(agg);
        }
        Function function = Function.getFunction(this.database, name);
        if (function == null) {
            UserAggregate aggregate = this.database.findAggregate(name);
            if (aggregate != null) {
                return this.readJavaAggregate(aggregate);
            }
            return this.readJavaFunction(name);
        }
        switch (function.getFunctionType()) {
            case 203: {
                function.setParameter(0, this.readExpression());
                this.read("AS");
                Column type = this.parseColumn(null);
                function.setDataType(type);
                this.read(")");
                break;
            }
            case 202: {
                function.setParameter(0, this.readExpression());
                this.read(",");
                Column type = this.parseColumn(null);
                function.setDataType(type);
                this.read(")");
                break;
            }
            case 120: {
                function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read("FROM");
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 73: {
                function.setParameter(0, this.readExpression());
                if (!this.readIf(",")) {
                    this.read("FROM");
                }
                function.setParameter(1, this.readExpression());
                if (this.readIf("FOR") || this.readIf(",")) {
                    function.setParameter(2, this.readExpression());
                }
                this.read(")");
                break;
            }
            case 77: {
                function.setParameter(0, this.readConcat());
                if (!this.readIf(",")) {
                    this.read("IN");
                }
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 78: {
                Expression space = null;
                if (this.readIf("LEADING")) {
                    function = Function.getFunction(this.database, "LTRIM");
                    if (!this.readIf("FROM")) {
                        space = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("TRAILING")) {
                    function = Function.getFunction(this.database, "RTRIM");
                    if (!this.readIf("FROM")) {
                        space = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("BOTH") && !this.readIf("FROM")) {
                    space = this.readExpression();
                    this.read("FROM");
                }
                Expression p0 = this.readExpression();
                if (this.readIf(",")) {
                    space = this.readExpression();
                } else if (this.readIf("FROM")) {
                    space = p0;
                    p0 = this.readExpression();
                }
                function.setParameter(0, p0);
                if (space != null) {
                    function.setParameter(1, space);
                }
                this.read(")");
                break;
            }
            case 219: {
                int i = 0;
                ObjectArray columns = new ObjectArray();
                do {
                    String columnName = this.readAliasIdentifier();
                    Column column = this.parseColumn(columnName);
                    columns.add(column);
                    this.read("=");
                    function.setParameter(i, this.readExpression());
                    ++i;
                } while (this.readIf(","));
                this.read(")");
                function.setColumns(columns);
                break;
            }
            default: {
                if (this.readIf(")")) break;
                int i = 0;
                do {
                    function.setParameter(i++, this.readExpression());
                } while (this.readIf(","));
                this.read(")");
            }
        }
        function.doneWithParameters();
        return function;
    }

    private Function readFunctionWithoutParameters(String name) throws SQLException {
        if (this.readIf("(")) {
            this.read(")");
        }
        Function function = Function.getFunction(this.database, name);
        function.doneWithParameters();
        return function;
    }

    private Expression readWildcardOrSequenceValue(String schemaName, String objectName) throws SQLException {
        Sequence sequence;
        if (this.readIf("*")) {
            return new Wildcard(schemaName, objectName);
        }
        if (schemaName == null) {
            schemaName = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.database.getSchema(schemaName).findSequence(objectName);
            if (sequence2 != null) {
                return new SequenceValue(sequence2);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.database.getSchema(schemaName).findSequence(objectName)) != null) {
            Function function = Function.getFunction(this.database, "CURRVAL");
            function.setParameter(0, ValueExpression.get(ValueString.get(schemaName)));
            function.setParameter(1, ValueExpression.get(ValueString.get(objectName)));
            function.doneWithParameters();
            return function;
        }
        return null;
    }

    private Expression readTermObjectDot(String objectName) throws SQLException {
        Expression expr = this.readWildcardOrSequenceValue(null, objectName);
        if (expr != null) {
            return expr;
        }
        String name = this.readColumnIdentifier();
        if (this.readIf(".")) {
            String schemaName = objectName;
            expr = this.readWildcardOrSequenceValue(schemaName, objectName = name);
            if (expr != null) {
                return expr;
            }
            name = this.readColumnIdentifier();
            if (this.readIf(".")) {
                String databaseName = schemaName;
                if (!this.database.getShortName().equals(databaseName)) {
                    throw Message.getSQLException(90013, databaseName);
                }
                schemaName = objectName;
                expr = this.readWildcardOrSequenceValue(schemaName, objectName = name);
                if (expr != null) {
                    return expr;
                }
                name = this.readColumnIdentifier();
                return new ExpressionColumn(this.database, schemaName, objectName, name);
            }
            return new ExpressionColumn(this.database, schemaName, objectName, name);
        }
        return new ExpressionColumn(this.database, null, objectName, name);
    }

    private Expression readTerm() throws SQLException {
        Function function;
        Expression r;
        switch (this.currentTokenType) {
            case 12: {
                this.read();
                r = new Variable(this.session, this.readAliasIdentifier());
                break;
            }
            case 3: {
                boolean indexed = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
                this.read();
                if (indexed && this.currentTokenType == 5 && this.currentValue.getType() == 4) {
                    int index;
                    if (this.indexedParameterList == null) {
                        if (this.parameters == null) {
                            throw this.getSyntaxError();
                        }
                        if (this.parameters.size() > 0) {
                            throw Message.getSQLException(90123);
                        }
                        this.indexedParameterList = new ObjectArray();
                    }
                    if ((index = this.currentValue.getInt() - 1) < 0 || index >= 100000) {
                        throw Message.getInvalidValueException("" + index, "Parameter Index");
                    }
                    if (this.indexedParameterList.size() <= index) {
                        this.indexedParameterList.setSize(index + 1);
                    }
                    if ((r = (Parameter)this.indexedParameterList.get(index)) == null) {
                        r = new Parameter(index);
                        this.indexedParameterList.set(index, r);
                    }
                    this.read();
                } else {
                    if (this.indexedParameterList != null) {
                        throw Message.getSQLException(90123);
                    }
                    r = new Parameter(this.parameters.size());
                }
                this.parameters.add(r);
                break;
            }
            case 1: {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    Query query = this.parseSelect();
                    r = new Subquery(query);
                    break;
                }
                throw this.getSyntaxError();
            }
            case 2: {
                String name = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf("(")) {
                        r = this.readFunction(name);
                        break;
                    }
                    if (this.readIf(".")) {
                        r = this.readTermObjectDot(name);
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name);
                    break;
                }
                this.read();
                if ("X".equals(name) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    this.read();
                    byte[] buffer = ByteUtils.convertStringToBytes(this.currentValue.getString());
                    r = ValueExpression.get(ValueBytes.getNoCopy(buffer));
                    break;
                }
                if (this.readIf(".")) {
                    r = this.readTermObjectDot(name);
                    break;
                }
                if ("CASE".equals(name)) {
                    if (this.isToken("WHEN")) {
                        r = this.readWhen(null);
                        break;
                    }
                    Expression left = this.readExpression();
                    r = this.readWhen(left);
                    break;
                }
                if (this.readIf("(")) {
                    r = this.readFunction(name);
                    break;
                }
                if ("CURRENT_USER".equals(name)) {
                    r = this.readFunctionWithoutParameters("USER");
                    break;
                }
                if ("CURRENT".equals(name)) {
                    if (this.readIf("TIMESTAMP")) {
                        r = this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
                        break;
                    }
                    if (this.readIf("TIME")) {
                        r = this.readFunctionWithoutParameters("CURRENT_TIME");
                        break;
                    }
                    if (this.readIf("DATE")) {
                        r = this.readFunctionWithoutParameters("CURRENT_DATE");
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name);
                    break;
                }
                if ("NEXT".equals(name) && this.readIf("VALUE")) {
                    this.read("FOR");
                    Sequence sequence = this.readSequence();
                    r = new SequenceValue(sequence);
                    break;
                }
                if ("DATE".equals(name) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String date = this.currentValue.getString();
                    this.read();
                    r = ValueExpression.get(ValueDate.get(ValueDate.parseDate(date)));
                    break;
                }
                if ("TIME".equals(name) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String time = this.currentValue.getString();
                    this.read();
                    r = ValueExpression.get(ValueTime.get(ValueTime.parseTime(time)));
                    break;
                }
                if ("TIMESTAMP".equals(name) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String timestamp = this.currentValue.getString();
                    this.read();
                    r = ValueExpression.get(ValueTimestamp.getNoCopy(ValueTimestamp.parseTimestamp(timestamp)));
                    break;
                }
                if ("E".equals(name) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String text = this.currentValue.getString();
                    this.read();
                    r = ValueExpression.get(ValueString.get(text));
                    break;
                }
                r = new ExpressionColumn(this.database, null, null, name);
                break;
            }
            case 17: {
                this.read();
                if (this.currentTokenType == 5) {
                    r = ValueExpression.get(this.currentValue.negate());
                    if (r.getType() == 5 && r.getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        r = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                    }
                    this.read();
                    break;
                }
                r = new Operation(5, this.readTerm(), null);
                break;
            }
            case 18: {
                this.read();
                r = this.readTerm();
                break;
            }
            case 31: {
                this.read();
                r = this.readExpression();
                if (this.readIf(",")) {
                    ObjectArray list = new ObjectArray();
                    list.add(r);
                    do {
                        r = this.readExpression();
                        list.add(r);
                    } while (this.readIf(","));
                    Object[] array = new Expression[list.size()];
                    list.toArray(array);
                    r = new ExpressionList((Expression[])array);
                }
                this.read(")");
                break;
            }
            case 40: {
                this.read();
                r = ValueExpression.get(ValueBoolean.get(true));
                break;
            }
            case 41: {
                this.read();
                r = ValueExpression.get(ValueBoolean.get(false));
                break;
            }
            case 44: {
                this.read();
                r = this.readFunctionWithoutParameters("CURRENT_TIME");
                break;
            }
            case 43: {
                this.read();
                r = this.readFunctionWithoutParameters("CURRENT_DATE");
                break;
            }
            case 42: {
                Function function2 = Function.getFunction(this.database, "CURRENT_TIMESTAMP");
                this.read();
                if (this.readIf("(") && !this.readIf(")")) {
                    function2.setParameter(0, this.readExpression());
                    this.read(")");
                }
                function2.doneWithParameters();
                r = function2;
                break;
            }
            case 45: {
                this.read();
                if (this.readIf("(")) {
                    this.read(")");
                }
                r = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                break;
            }
            case 34: {
                this.read();
                r = ValueExpression.NULL;
                break;
            }
            case 5: {
                r = ValueExpression.get(this.currentValue);
                this.read();
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (this.readIf("[")) {
            Function function3 = Function.getFunction(this.database, "ARRAY_GET");
            function3.setParameter(0, r);
            r = this.readExpression();
            r = new Operation(1, r, ValueExpression.get(ValueInt.get(1)));
            function3.setParameter(1, r);
            r = function3;
            this.read("]");
        }
        if (this.readIf("::")) {
            Column col = this.parseColumn(null);
            Function function4 = Function.getFunction(this.database, "CAST");
            function4.setDataType(col);
            function4.setParameter(0, r);
            function = function4;
        }
        return function;
    }

    private Expression readWhen(Expression left) throws SQLException {
        if (this.readIf("END")) {
            this.readIf("CASE");
            return ValueExpression.NULL;
        }
        if (this.readIf("ELSE")) {
            Expression elsePart = this.readExpression();
            this.read("END");
            this.readIf("CASE");
            return elsePart;
        }
        this.readIf("WHEN");
        Expression when = this.readExpression();
        if (left != null) {
            when = new Comparison(this.session, 0, left, when);
        }
        this.read("THEN");
        Expression then = this.readExpression();
        Expression elsePart = this.readWhen(left);
        Function function = Function.getFunction(this.session.getDatabase(), "CASEWHEN");
        function.setParameter(0, when);
        function.setParameter(1, then);
        function.setParameter(2, elsePart);
        function.doneWithParameters();
        return function;
    }

    private int getPositiveInt() throws SQLException {
        int v = this.getInt();
        if (v < 0) {
            throw Message.getInvalidValueException("" + v, "positive integer");
        }
        return v;
    }

    private int getInt() throws SQLException {
        boolean minus = false;
        if (this.currentTokenType == 17) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 18) {
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        int i = this.currentValue.getInt();
        this.read();
        return minus ? -i : i;
    }

    private long readLong() throws SQLException {
        boolean minus = false;
        if (this.currentTokenType == 17) {
            minus = true;
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4 && this.currentValue.getType() != 6) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        long i = this.currentValue.getLong();
        this.read();
        return minus ? -i : i;
    }

    private boolean readBooleanSetting() throws SQLException {
        if (this.currentTokenType == 5) {
            boolean result = this.currentValue.getBoolean();
            this.read();
            return result;
        }
        if (this.readIf("TRUE") || this.readIf("ON")) {
            return true;
        }
        if (this.readIf("FALSE") || this.readIf("OFF")) {
            return false;
        }
        throw this.getSyntaxError();
    }

    private String readString() throws SQLException {
        Expression expr = this.readExpression().optimize(this.session);
        if (!(expr instanceof ValueExpression)) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        String s = expr.getValue(this.session).getString();
        return s;
    }

    private String readIdentifierWithSchema(String defaultSchemaName) throws SQLException {
        if (this.currentTokenType != 2) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        this.schemaName = defaultSchemaName;
        if (this.readIf(".")) {
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        if (".".equals(this.currentToken) && this.schemaName.equalsIgnoreCase(this.database.getShortName())) {
            this.read(".");
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        return s;
    }

    private String readIdentifierWithSchema() throws SQLException {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() throws SQLException {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() throws SQLException {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() throws SQLException {
        if (this.currentTokenType != 2) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private void read(String expected) throws SQLException {
        if (!expected.equals(this.currentToken) || this.currentTokenQuoted) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, expected);
        }
        this.read();
    }

    private boolean readIf(String token) throws SQLException {
        if (token.equals(this.currentToken) && !this.currentTokenQuoted) {
            this.read();
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private boolean isToken(String token) {
        boolean result;
        boolean bl = result = token.equals(this.currentToken) && !this.currentTokenQuoted;
        if (result) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private void addExpected(String token) {
        if (this.expected != null) {
            this.expected.add(token);
        }
    }

    private void read() throws SQLException {
        this.currentTokenQuoted = false;
        if (this.expected != null) {
            this.expected.clear();
        }
        int[] types = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.sqlCommandChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while (true) {
                    if ((type = types[i]) != 4 && type != 2) break;
                    ++i;
                }
                c = chars[i];
                this.currentToken = StringCache.getNew(this.sqlCommand.substring(start, i));
                this.currentTokenType = this.getTokenType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 3: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\"') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\"') break;
                }
                this.currentToken = StringCache.getNew(result);
                this.parseIndex = i;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    ++i;
                }
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 5: {
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 2: {
                if (c == '0' && chars[i] == 'X') {
                    long number = 0L;
                    start += 2;
                    ++i;
                    while (true) {
                        if (!((c = chars[i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)number);
                            this.currentTokenType = 5;
                            this.currentToken = "0";
                            this.parseIndex = i;
                            return;
                        }
                        if ((number = (number << 4) + (long)c - (long)(c >= 'A' ? 55 : 48)) > Integer.MAX_VALUE) {
                            this.readHexDecimal(start, i);
                            return;
                        }
                        ++i;
                    }
                }
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(start, i);
                            break;
                        }
                        if (c == 'E') {
                            this.readDecimal(start, i);
                            break;
                        }
                        this.checkLiterals(false);
                        this.currentValue = ValueInt.get((int)number);
                        this.currentTokenType = 5;
                        this.currentToken = "0";
                        this.parseIndex = i;
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i);
                return;
            }
            case 7: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\'') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(false);
                this.currentValue = ValueString.get(StringCache.getNew(result));
                this.parseIndex = i;
                this.currentTokenType = 5;
                return;
            }
            case -1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = i;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void checkLiterals(boolean text) throws SQLException {
        int allowed;
        if (!this.session.getAllowLiterals() && ((allowed = this.database.getAllowLiterals()) == 0 || text && allowed != 2)) {
            throw Message.getSQLException(90116);
        }
    }

    private void readHexDecimal(int start, int i) throws SQLException {
        char c;
        char[] chars = this.sqlCommandChars;
        while ((c = chars[++i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        BigDecimal bd = new BigDecimal(new BigInteger(sub, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    private void readDecimal(int start, int i) throws SQLException {
        BigDecimal bd;
        int t;
        char[] chars = this.sqlCommandChars;
        int[] types = this.characterTypes;
        while ((t = types[i]) == 8 || t == 2) {
            ++i;
        }
        if (chars[i] == 'E') {
            if (chars[++i] == '+' || chars[i] == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        try {
            bd = new BigDecimal(sub);
        }
        catch (NumberFormatException e) {
            throw Message.getSQLException(90021, new String[]{sub}, e);
        }
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Session getSession() {
        return this.session;
    }

    private void initialize(String sql) throws SQLException {
        if (sql == null) {
            sql = "";
        }
        this.originalSQL = sql;
        this.sqlCommand = sql;
        int len = sql.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        sql.getChars(0, --len, command, 0);
        boolean changed = false;
        command[len] = 32;
        int startLoop = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            switch (c) {
                case '/': {
                    if (command[i + 1] == '*') {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '*' || command[i + 1] != '/') {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (command[i + 1] == '/') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '-': {
                    if (command[i + 1] == '-') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '\'': {
                    types[i] = 7;
                    type = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        command[i] = 34;
                        changed = true;
                        types[i] = 3;
                        type = 3;
                        startLoop = i;
                        while (command[++i] != ']') {
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 34;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '`': {
                    command[i] = 34;
                    changed = true;
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '`') {
                        this.checkRunOver(i, len, startLoop);
                        c = command[i];
                        command[i] = Character.toUpperCase(c);
                    }
                    command[i] = 34;
                    break;
                }
                case '\"': {
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '_': {
                    type = 4;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z') {
                        command[i] = (char)(c - 32);
                        changed = true;
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    type = 4;
                    char u = Character.toUpperCase(c);
                    if (u == c) break;
                    command[i] = u;
                    changed = true;
                }
            }
            types[i] = (byte)type;
        }
        this.sqlCommandChars = command;
        types[len] = -1;
        this.characterTypes = types;
        if (changed) {
            this.sqlCommand = new String(command);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int i, int len, int startLoop) throws SQLException {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType(String s) throws SQLException {
        char c0 = s.charAt(0);
        if (s.length() == 1) {
            switch (c0) {
                case '$': 
                case '?': {
                    return 3;
                }
                case '@': {
                    return 12;
                }
                case '+': {
                    return 18;
                }
                case '-': {
                    return 17;
                }
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    return 1;
                }
                case '(': {
                    return 31;
                }
                case ')': {
                    return 32;
                }
                case '<': {
                    return 9;
                }
                case '>': {
                    return 8;
                }
                case '=': {
                    return 6;
                }
            }
        } else if (s.length() == 2) {
            switch (c0) {
                case ':': {
                    if (!"::".equals(s)) break;
                    return 1;
                }
                case '>': {
                    if (!">=".equals(s)) break;
                    return 7;
                }
                case '<': {
                    if ("<=".equals(s)) {
                        return 10;
                    }
                    if (!"<>".equals(s)) break;
                    return 11;
                }
                case '!': {
                    if ("!=".equals(s)) {
                        return 11;
                    }
                    if (!"!~".equals(s)) break;
                    return 1;
                }
                case '|': {
                    if (!"||".equals(s)) break;
                    return 22;
                }
            }
        }
        throw this.getSyntaxError();
    }

    private int getTokenType(String s) throws SQLException {
        int len = s.length();
        if (len == 0) {
            throw this.getSyntaxError();
        }
        return Parser.getSaveTokenType(s);
    }

    public static boolean isKeyword(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return Parser.getSaveTokenType(s) != 2;
    }

    private static int getSaveTokenType(String s) {
        switch (s.charAt(0)) {
            case 'C': {
                if (s.equals("CURRENT_TIMESTAMP")) {
                    return 42;
                }
                if (s.equals("CURRENT_TIME")) {
                    return 44;
                }
                if (s.equals("CURRENT_DATE")) {
                    return 43;
                }
                return Parser.getKeywordOrIdentifier(s, "CROSS", 1);
            }
            case 'D': {
                return Parser.getKeywordOrIdentifier(s, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "EXISTS", 1);
            }
            case 'F': {
                if ("FROM".equals(s)) {
                    return 1;
                }
                if ("FOR".equals(s)) {
                    return 1;
                }
                if ("FULL".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "FALSE", 41);
            }
            case 'G': {
                return Parser.getKeywordOrIdentifier(s, "GROUP", 1);
            }
            case 'H': {
                return Parser.getKeywordOrIdentifier(s, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(s)) {
                    return 1;
                }
                if ("INTERSECT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "IS", 1);
            }
            case 'J': {
                return Parser.getKeywordOrIdentifier(s, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "LIKE", 1);
            }
            case 'M': {
                return Parser.getKeywordOrIdentifier(s, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(s)) {
                    return 1;
                }
                if ("NATURAL".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "NULL", 34);
            }
            case 'O': {
                if ("ON".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "ORDER", 1);
            }
            case 'P': {
                return Parser.getKeywordOrIdentifier(s, "PRIMARY", 1);
            }
            case 'R': {
                return Parser.getKeywordOrIdentifier(s, "ROWNUM", 45);
            }
            case 'S': {
                if (s.equals("SYSTIMESTAMP")) {
                    return 42;
                }
                if (s.equals("SYSTIME")) {
                    return 44;
                }
                if (s.equals("SYSDATE")) {
                    return 42;
                }
                return Parser.getKeywordOrIdentifier(s, "SELECT", 1);
            }
            case 'T': {
                if ("TODAY".equals(s)) {
                    return 43;
                }
                return Parser.getKeywordOrIdentifier(s, "TRUE", 40);
            }
            case 'U': {
                return Parser.getKeywordOrIdentifier(s, "UNION", 1);
            }
            case 'W': {
                return Parser.getKeywordOrIdentifier(s, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String s1, String s2, int keywordType) {
        if (s1.equals(s2)) {
            return keywordType;
        }
        return 2;
    }

    private Column parseColumnForTable(String columnName) throws SQLException {
        long increment;
        long start;
        Column column;
        if (this.readIf("IDENTITY") || this.readIf("SERIAL")) {
            column = new Column(columnName, 5);
            column.setOriginalSQL("IDENTITY");
            start = 1L;
            increment = 1L;
            if (this.readIf("(")) {
                start = this.readLong();
                if (this.readIf(",")) {
                    increment = this.readLong();
                }
                this.read(")");
            }
            column.setAutoIncrement(true, start, increment);
        } else {
            column = this.parseColumn(columnName);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else {
            this.readIf("NULL");
            column.setNullable(true);
        }
        if (this.readIf("AS")) {
            Expression expr = this.readExpression();
            column.setComputed(true, expr);
        } else if (this.readIf("DEFAULT")) {
            Expression defaultExpression = this.readExpression();
            column.setDefaultExpression(this.session, defaultExpression);
        } else if (this.readIf("GENERATED")) {
            this.read("BY");
            this.read("DEFAULT");
            this.read("AS");
            this.read("IDENTITY");
            start = 1L;
            increment = 1L;
            if (this.readIf("(")) {
                this.read("START");
                this.readIf("WITH");
                start = this.readLong();
                this.readIf(",");
                if (this.readIf("INCREMENT")) {
                    this.readIf("BY");
                    increment = this.readLong();
                }
                this.read(")");
            }
            column.setAutoIncrement(true, start, increment);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else {
            this.readIf("NULL");
        }
        if (this.readIf("AUTO_INCREMENT") || this.readIf("IDENTITY")) {
            long start2 = 1L;
            increment = 1L;
            if (this.readIf("(")) {
                start2 = this.readLong();
                if (this.readIf(",")) {
                    increment = this.readLong();
                }
                this.read(")");
            }
            column.setAutoIncrement(true, start2, increment);
            if (this.readIf("NOT")) {
                this.read("NULL");
            }
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            Sequence sequence = this.readSequence();
            column.setSequence(sequence);
        }
        if (this.readIf("SELECTIVITY")) {
            int value = this.getPositiveInt();
            column.setSelectivity(value);
        }
        column.setComment(this.readCommentIf());
        return column;
    }

    private String readCommentIf() throws SQLException {
        if (this.readIf("COMMENT")) {
            this.readIf("IS");
            return this.readString();
        }
        return null;
    }

    private Column parseColumn(String columnName) throws SQLException {
        String original = this.currentToken;
        boolean regular = false;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                original = original + " RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                original = original + " PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                original = original + " VARYING";
            }
        } else {
            regular = true;
        }
        DataType dataType = DataType.getTypeByName(original);
        long precision = -1L;
        int displaySize = -1;
        int scale = -1;
        Column templateColumn = null;
        if (dataType == null) {
            UserDataType userDataType = this.database.findUserDataType(original);
            if (userDataType == null) {
                throw Message.getSQLException(50004, this.currentToken);
            }
            templateColumn = userDataType.getColumn();
            dataType = DataType.getDataType(templateColumn.getType());
            original = templateColumn.getOriginalSQL();
            precision = templateColumn.getPrecision();
            displaySize = templateColumn.getDisplaySize();
            scale = templateColumn.getScale();
        }
        if (this.database.getIgnoreCase() && dataType.type == 13 && !"VARCHAR_CASESENSITIVE".equals(original)) {
            original = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(original);
        }
        if (regular) {
            this.read();
        }
        precision = precision == -1L ? dataType.defaultPrecision : precision;
        displaySize = displaySize == -1 ? dataType.defaultDisplaySize : displaySize;
        int n = scale = scale == -1 ? dataType.defaultScale : scale;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            if (this.readIf("(")) {
                precision = this.readLong();
                if (this.readIf("K")) {
                    precision *= 1024L;
                } else if (this.readIf("M")) {
                    precision *= 0x100000L;
                } else if (this.readIf("G")) {
                    precision *= 0x40000000L;
                }
                if (precision > Long.MAX_VALUE) {
                    precision = Long.MAX_VALUE;
                }
                displaySize = MathUtils.convertLongToInt(precision);
                original = original + "(" + precision;
                this.readIf("CHAR");
                if (dataType.supportsScale) {
                    if (this.readIf(",")) {
                        scale = this.getPositiveInt();
                        original = original + ", " + scale;
                    } else {
                        scale = 0;
                    }
                }
                original = original + ")";
                this.read(")");
            }
        } else if (this.readIf("(")) {
            this.getPositiveInt();
            this.read(")");
        }
        if (this.readIf("FOR")) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY");
            }
        }
        int type = dataType.type;
        Column column = new Column(columnName, type, precision, scale, displaySize);
        if (templateColumn != null) {
            Expression checkConstraint;
            column.setNullable(templateColumn.getNullable());
            column.setDefaultExpression(this.session, templateColumn.getDefaultExpression());
            int selectivity = templateColumn.getSelectivity();
            if (selectivity != 50) {
                column.setSelectivity(selectivity);
            }
            if ((checkConstraint = templateColumn.getCheckConstraint(this.session, columnName)) != null) {
                column.addCheckConstraint(this.session, checkConstraint);
            }
        }
        column.setOriginalSQL(original);
        return column;
    }

    private Prepared parseCreate() throws SQLException {
        boolean force = this.readIf("FORCE");
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            this.read("TABLE");
            return this.parseCreateTable(true, false, false);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            this.read("TABLE");
            return this.parseCreateTable(true, true, false);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            this.read("TABLE");
            return this.parseCreateTable(true, true, false);
        }
        if (this.readIf("MEMORY")) {
            this.read("TABLE");
            return this.parseCreateTable(false, false, false);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(force);
        }
        if (this.readIf("CACHED")) {
            this.read("TABLE");
            return this.parseCreateTable(false, false, true);
        }
        if (this.readIf("TABLE")) {
            Setting setting = this.database.findSetting(SetTypes.getTypeName(7));
            int defaultMode = setting == null ? 0 : setting.getIntValue();
            return this.parseCreateTable(false, false, defaultMode == 0);
        }
        if (this.readIf("VIEW")) {
            return this.parseCreateView(force);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(force);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger();
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(force);
        }
        boolean hash = false;
        boolean primaryKey = false;
        boolean unique = false;
        String indexName = null;
        Schema oldSchema = null;
        boolean ifNotExists = false;
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                hash = true;
            }
            primaryKey = true;
        } else {
            if (this.readIf("UNIQUE")) {
                unique = true;
                if (this.readIf("HASH")) {
                    hash = true;
                }
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken("ON")) {
                    ifNotExists = this.readIfNoExists();
                    indexName = this.readIdentifierWithSchema(null);
                    oldSchema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read("ON");
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(oldSchema);
        CreateIndex command = new CreateIndex(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setHash(hash);
        command.setPrimaryKey(primaryKey);
        command.setTableName(tableName);
        command.setUnique(unique);
        command.setIndexName(indexName);
        command.setComment(this.readCommentIf());
        this.read("(");
        command.setIndexColumns(this.parseIndexColumnList());
        return command;
    }

    private boolean addRoleOrRight(GrantRevoke command) throws SQLException {
        if (this.readIf("SELECT")) {
            command.addRight(1);
            return false;
        }
        if (this.readIf("DELETE")) {
            command.addRight(2);
            return false;
        }
        if (this.readIf("INSERT")) {
            command.addRight(4);
            return false;
        }
        if (this.readIf("UPDATE")) {
            command.addRight(8);
            return false;
        }
        if (this.readIf("ALL")) {
            command.addRight(15);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return false;
        }
        if (this.readIf("RESOURCE")) {
            return false;
        }
        command.addRoleName(this.readUniqueIdentifier());
        return true;
    }

    private GrantRevoke parseGrantRevoke(int operationType) throws SQLException {
        GrantRevoke command = new GrantRevoke(this.session);
        command.setOperationType(operationType);
        boolean isRoleBased = this.addRoleOrRight(command);
        while (this.readIf(",")) {
            boolean next = this.addRoleOrRight(command);
            if (next == isRoleBased) continue;
            throw Message.getSQLException(90072);
        }
        if (!isRoleBased && this.readIf("ON")) {
            do {
                Table table = this.readTableOrView();
                command.addTable(table);
            } while (this.readIf(","));
        }
        if (operationType == 0) {
            this.read("TO");
        } else {
            this.read("FROM");
        }
        command.setGranteeName(this.readUniqueIdentifier());
        return command;
    }

    private Call parserCall() throws SQLException {
        Call command = new Call(this.session);
        this.currentPrepared = command;
        command.setValue(this.readExpression());
        return command;
    }

    private CreateRole parseCreateRole() throws SQLException {
        CreateRole command = new CreateRole(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setRoleName(this.readUniqueIdentifier());
        return command;
    }

    private CreateSchema parseCreateSchema() throws SQLException {
        CreateSchema command = new CreateSchema(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            command.setAuthorization(this.readUniqueIdentifier());
        } else {
            command.setAuthorization(this.session.getUser().getName());
        }
        return command;
    }

    private CreateSequence parseCreateSequence() throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        String sequenceName = this.readIdentifierWithSchema();
        CreateSequence command = new CreateSequence(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setSequenceName(sequenceName);
        if (this.readIf("START")) {
            this.readIf("WITH");
            long start = this.readLong();
            command.setStartWith(start);
        }
        if (this.readIf("INCREMENT")) {
            this.readIf("BY");
            long increment = this.readLong();
            command.setIncrement(increment);
        }
        if (this.readIf("CACHE")) {
            command.setCacheSize(this.readLong());
        }
        if (this.readIf("BELONGS_TO_TABLE")) {
            command.setBelongsToTable(true);
        }
        return command;
    }

    private boolean readIfNoExists() throws SQLException {
        if (this.readIf("IF")) {
            this.read("NOT");
            this.read("EXISTS");
            return true;
        }
        return false;
    }

    private CreateConstant parseCreateConstant() throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        String constantName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (Parser.isKeyword(constantName)) {
            throw Message.getSQLException(90114, constantName);
        }
        this.read("VALUE");
        Expression expr = this.readExpression();
        CreateConstant command = new CreateConstant(this.session, schema);
        command.setConstantName(constantName);
        command.setExpression(expr);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateAggregate parseCreateAggregate(boolean force) throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        CreateAggregate command = new CreateAggregate(this.session);
        command.setForce(force);
        String name = this.readUniqueIdentifier();
        if (Parser.isKeyword(name) || Function.getFunction(this.database, name) != null || Aggregate.getAggregateType(name) >= 0) {
            throw Message.getSQLException(90076, name);
        }
        command.setName(name);
        command.setIfNotExists(ifNotExists);
        this.read("FOR");
        command.setJavaClassMethod(this.readUniqueIdentifier());
        return command;
    }

    private CreateUserDataType parseCreateUserDataType() throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        CreateUserDataType command = new CreateUserDataType(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column col = this.parseColumnForTable("VALUE");
        if (this.readIf("CHECK")) {
            Expression expr = this.readExpression();
            col.addCheckConstraint(this.session, expr);
        }
        col.rename(null);
        command.setColumn(col);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateTrigger parseCreateTrigger() throws SQLException {
        boolean isBefore;
        boolean ifNotExists = this.readIfNoExists();
        String triggerName = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("BEFORE")) {
            isBefore = true;
        } else {
            this.read("AFTER");
            isBefore = false;
        }
        int typeMask = 0;
        do {
            if (this.readIf("INSERT")) {
                typeMask |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                typeMask |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                typeMask |= 4;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(","));
        this.read("ON");
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger command = new CreateTrigger(this.session, this.getSchema());
        command.setTriggerName(triggerName);
        command.setIfNotExists(ifNotExists);
        command.setBefore(isBefore);
        command.setTypeMask(typeMask);
        command.setTableName(tableName);
        if (this.readIf("FOR")) {
            this.read("EACH");
            this.read("ROW");
            command.setRowBased(true);
        } else {
            command.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            command.setQueueSize(this.getPositiveInt());
        }
        command.setNoWait(this.readIf("NOWAIT"));
        this.read("CALL");
        command.setTriggerClassName(this.readUniqueIdentifier());
        return command;
    }

    private CreateUser parseCreateUser() throws SQLException {
        CreateUser command = new CreateUser(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setUserName(this.readUniqueIdentifier());
        command.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            command.setPassword(this.readString());
        } else if (this.readIf("SALT")) {
            command.setSalt(this.readString());
            this.read("HASH");
            command.setHash(this.readString());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            command.setPassword(this.readColumnIdentifier());
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            command.setAdmin(true);
        }
        return command;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean force) throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        CreateFunctionAlias command = new CreateFunctionAlias(this.session);
        command.setForce(force);
        String name = this.readUniqueIdentifier();
        if (Parser.isKeyword(name) || Function.getFunction(this.database, name) != null || Aggregate.getAggregateType(name) >= 0) {
            throw Message.getSQLException(90076, name);
        }
        command.setAliasName(name);
        command.setIfNotExists(ifNotExists);
        this.read("FOR");
        command.setJavaClassMethod(this.readUniqueIdentifier());
        return command;
    }

    private Query parserWith() throws SQLException {
        String tempViewName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("(");
        String[] cols = this.parseColumnList();
        ObjectArray columns = new ObjectArray();
        for (int i = 0; i < cols.length; ++i) {
            columns.add(new Column(cols[i], 13));
        }
        int id = this.database.allocateObjectId(true, true);
        TableData recursiveTable = schema.createTable(tempViewName, id, columns, false, false);
        recursiveTable.setTemporary(true);
        this.session.addLocalTempTable(recursiveTable);
        String querySQL = StringCache.getNew(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        Query withQuery = this.parseSelect();
        withQuery.prepare();
        this.session.removeLocalTempTable(recursiveTable);
        id = this.database.allocateObjectId(true, true);
        TableView view = new TableView(schema, id, tempViewName, querySQL, null, cols, this.session, true);
        view.setTemporary(true);
        this.session.addLocalTempTable(view);
        Query query = this.parseSelect();
        query.prepare();
        query.setPrepareAlways(true);
        return query;
    }

    private CreateView parseCreateView(boolean force) throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        String viewName = this.readIdentifierWithSchema();
        CreateView command = new CreateView(this.session, this.getSchema());
        this.prepared = command;
        command.setViewName(viewName);
        command.setIfNotExists(ifNotExists);
        command.setComment(this.readCommentIf());
        if (this.readIf("(")) {
            String[] cols = this.parseColumnList();
            command.setColumnNames(cols);
        }
        String select = StringCache.getNew(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query = this.parseSelect();
            query.prepare();
            command.setSelect(query);
        }
        catch (SQLException e) {
            if (force) {
                command.setSelectSQL(select);
            }
            throw e;
        }
        return command;
    }

    private TransactionCommand parseCheckpoint() throws SQLException {
        TransactionCommand command = this.readIf("SYNC") ? new TransactionCommand(this.session, 8) : new TransactionCommand(this.session, 5);
        return command;
    }

    private Prepared parseAlter() throws SQLException {
        if (this.readIf("TABLE")) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema old) throws SQLException {
        if (old != null && this.getSchema() != old) {
            throw Message.getSQLException(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() throws SQLException {
        String indexName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        AlterIndexRename command = new AlterIndexRename(this.session);
        command.setOldIndex(this.getSchema().getIndex(indexName));
        this.read("RENAME");
        this.read("TO");
        String newName = this.readIdentifierWithSchema(old.getName());
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private AlterView parseAlterView() throws SQLException {
        AlterView command = new AlterView(this.session);
        String viewName = this.readIdentifierWithSchema();
        Table tableView = this.getSchema().findTableOrView(this.session, viewName);
        if (!(tableView instanceof TableView)) {
            throw Message.getSQLException(90037, viewName);
        }
        TableView view = (TableView)tableView;
        command.setView(view);
        this.read("RECOMPILE");
        return command;
    }

    private AlterSequence parseAlterSequence() throws SQLException {
        AlterSequence command = new AlterSequence(this.session);
        String sequenceName = this.readIdentifierWithSchema();
        command.setSequence(this.getSchema().getSequence(sequenceName));
        if (this.readIf("RESTART")) {
            this.read("WITH");
            long start = this.readLong();
            command.setStartWith(start);
        }
        if (this.readIf("INCREMENT")) {
            this.read("BY");
            long increment = this.readLong();
            command.setIncrement(increment);
        }
        return command;
    }

    private AlterUser parseAlterUser() throws SQLException {
        String userName = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(0);
            command.setUser(this.database.getUser(userName));
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readString());
            } else if (this.readIf("SALT")) {
                command.setSalt(this.readString());
                this.read("HASH");
                command.setHash(this.readString());
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser command = new AlterUser(this.session);
            command.setType(1);
            command.setUser(this.database.getUser(userName));
            String newName = this.readUniqueIdentifier();
            command.setNewName(newName);
            return command;
        }
        if (this.readIf("ADMIN")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(2);
            User user = this.database.getUser(userName);
            command.setUser(user);
            if (this.readIf("TRUE")) {
                command.setAdmin(true);
            } else if (this.readIf("FALSE")) {
                command.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() throws SQLException {
        if (!this.readIf("=")) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() throws SQLException {
        int type;
        if (this.readIf("@")) {
            Set command = new Set(this.session, 35);
            command.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            command.setExpression(this.readExpression());
            return command;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            int setting = value ? 1 : 2;
            return new TransactionCommand(this.session, setting);
        }
        if (this.readIf("MVCC")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 31);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 33);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 1);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(0);
            command.setUser(this.session.getUser());
            command.setPassword(this.readString());
            return command;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(0);
            command.setUser(this.session.getUser());
            command.setSalt(this.readString());
            this.read("HASH");
            command.setHash(this.readString());
            return command;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 3);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 23);
            if (this.currentTokenType == 5) {
                command.setString(this.readString());
            } else {
                command.setString(this.readUniqueIdentifier());
            }
            return command;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 13);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 15);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                command.setInt(0);
            } else if (this.readIf("ALL")) {
                command.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                command.setInt(1);
            } else {
                command.setInt(this.getPositiveInt());
            }
            return command;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                command.setInt(1);
            } else if (this.readIf("CACHED")) {
                command.setInt(0);
            } else {
                command.setInt(this.getPositiveInt());
            }
            return command;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("STORAGE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_LOG")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DATABASE_EVENT_LISTENER_OBJECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 26);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("DATESTYLE")) {
            this.readIfEqualOrTo();
            this.read("ISO");
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(28))) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 28);
            ObjectArray list = new ObjectArray();
            list.add(this.readAliasIdentifier());
            while (this.readIf(",")) {
                list.add(this.readAliasIdentifier());
            }
            Object[] schemaNames = new String[list.size()];
            list.toArray(schemaNames);
            command.setStringArray((String[])schemaNames);
            return command;
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if ((type = SetTypes.getType(this.currentToken)) >= 0) {
            this.read();
            this.readIfEqualOrTo();
            Set command = new Set(this.session, type);
            command.setExpression(this.readExpression());
            return command;
        }
        throw this.getSyntaxError();
    }

    private Set parseSetCollation() throws SQLException {
        Set command = new Set(this.session, 12);
        String name = this.readAliasIdentifier();
        command.setString(name);
        if (name.equals("OFF")) {
            return command;
        }
        Collator coll = CompareMode.getCollator(name);
        if (coll == null) {
            throw this.getSyntaxError();
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf("PRIMARY")) {
                command.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                command.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                command.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                command.setInt(3);
            }
        } else {
            command.setInt(coll.getStrength());
        }
        return command;
    }

    private RunScriptCommand parseRunScript() throws SQLException {
        RunScriptCommand command = new RunScriptCommand(this.session);
        this.read("FROM");
        command.setFileName(this.readString());
        if (this.readIf("COMPRESSION")) {
            command.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            command.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readString().toCharArray());
            }
        }
        if (this.readIf("CHARSET")) {
            command.setCharset(this.readString());
        }
        return command;
    }

    private ScriptCommand parseScript() throws SQLException {
        ScriptCommand command = new ScriptCommand(this.session);
        boolean data = true;
        boolean passwords = true;
        boolean settings = true;
        boolean dropTables = false;
        boolean simple = false;
        if (this.readIf("SIMPLE")) {
            simple = true;
        }
        if (this.readIf("NODATA")) {
            data = false;
        }
        if (this.readIf("NOPASSWORDS")) {
            passwords = false;
        }
        if (this.readIf("NOSETTINGS")) {
            settings = false;
        }
        if (this.readIf("DROP")) {
            dropTables = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long blockSize = this.readLong();
            command.setLobBlockSize(blockSize);
        }
        command.setData(data);
        command.setPasswords(passwords);
        command.setSettings(settings);
        command.setDrop(dropTables);
        command.setSimple(simple);
        if (this.readIf("TO")) {
            command.setFileName(this.readString());
            if (this.readIf("COMPRESSION")) {
                command.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                command.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    command.setPassword(this.readString().toCharArray());
                }
            }
        }
        return command;
    }

    private Table readTableOrView() throws SQLException {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String tableName) throws SQLException {
        if (this.schemaName != null) {
            return this.getSchema().getTableOrView(this.session, tableName);
        }
        Table table = this.database.getSchema(this.session.getCurrentSchemaName()).findTableOrView(this.session, tableName);
        if (table != null) {
            return table;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        for (int i = 0; schemaNames != null && i < schemaNames.length; ++i) {
            Schema s = this.database.getSchema(schemaNames[i]);
            table = s.findTableOrView(this.session, tableName);
            if (table == null) continue;
            return table;
        }
        throw Message.getSQLException(42102, tableName);
    }

    private Sequence readSequence() throws SQLException {
        String sequenceName = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(sequenceName);
        }
        Sequence sequence = this.database.getSchema(this.session.getCurrentSchemaName()).findSequence(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        for (int i = 0; schemaNames != null && i < schemaNames.length; ++i) {
            Schema s = this.database.getSchema(schemaNames[i]);
            sequence = s.findSequence(sequenceName);
            if (sequence == null) continue;
            return sequence;
        }
        throw Message.getSQLException(90036, sequenceName);
    }

    private Prepared parseAlterTable() throws SQLException {
        Table table = this.readTableOrView();
        if (this.readIf("ADD")) {
            Prepared command = this.parseAlterTableAddConstraintIf(table.getName(), table.getSchema());
            if (command != null) {
                return command;
            }
            return this.parseAlterTableAddColumn(table);
        }
        if (this.readIf("SET")) {
            int type;
            this.read("REFERENTIAL_INTEGRITY");
            if (this.readIf("TRUE")) {
                type = 4;
            } else {
                this.read("FALSE");
                type = 5;
            }
            AlterTableSet command = new AlterTableSet(this.session, table.getSchema(), type);
            command.setTableName(table.getName());
            if (this.readIf("CHECK")) {
                command.setCheckExisting(true);
            } else if (this.readIf("NOCHECK")) {
                command.setCheckExisting(false);
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String newName = this.readIdentifierWithSchema(table.getSchema().getName());
            this.checkSchema(table.getSchema());
            AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
            command.setOldTable(table);
            command.setNewTableName(newName);
            return command;
        }
        if (this.readIf("DROP")) {
            if (this.readIf("CONSTRAINT")) {
                String constraintName = this.readIdentifierWithSchema(table.getSchema().getName());
                this.checkSchema(table.getSchema());
                AlterTableDropConstraint command = new AlterTableDropConstraint(this.session, this.getSchema());
                command.setConstraintName(constraintName);
                return command;
            }
            if (this.readIf("PRIMARY")) {
                this.read("KEY");
                Index idx = table.getPrimaryKey();
                DropIndex command = new DropIndex(this.session, table.getSchema());
                command.setIndexName(idx.getName());
                return command;
            }
            this.readIf("COLUMN");
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
            command.setType(6);
            String columnName = this.readColumnIdentifier();
            command.setTable(table);
            command.setOldColumn(table.getColumn(columnName));
            return command;
        }
        if (this.readIf("ALTER")) {
            this.readIf("COLUMN");
            String columnName = this.readColumnIdentifier();
            Column column = table.getColumn(columnName);
            if (this.readIf("RENAME")) {
                this.read("TO");
                AlterTableRenameColumn command = new AlterTableRenameColumn(this.session);
                command.setTable(table);
                command.setColumn(column);
                String newName = this.readColumnIdentifier();
                command.setNewColumnName(newName);
                return command;
            }
            if (this.readIf("SET")) {
                if (this.readIf("DATA")) {
                    this.read("TYPE");
                    Column newColumn = this.parseColumnForTable(columnName);
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                    command.setTable(table);
                    command.setType(4);
                    command.setOldColumn(column);
                    command.setNewColumn(newColumn);
                    return command;
                }
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                command.setTable(table);
                command.setOldColumn(column);
                if (this.readIf("NULL")) {
                    command.setType(1);
                    return command;
                }
                if (this.readIf("NOT")) {
                    this.read("NULL");
                    command.setType(0);
                    return command;
                }
                if (this.readIf("DEFAULT")) {
                    Expression defaultExpression = this.readExpression();
                    command.setType(2);
                    command.setDefaultExpression(defaultExpression);
                    return command;
                }
            } else {
                if (this.readIf("RESTART")) {
                    this.readIf("WITH");
                    long start = this.readLong();
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                    command.setTable(table);
                    command.setType(3);
                    command.setOldColumn(column);
                    command.setStartWith(start);
                    return command;
                }
                if (this.readIf("SELECTIVITY")) {
                    int selectivity = this.getPositiveInt();
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                    command.setTable(table);
                    command.setType(7);
                    command.setOldColumn(column);
                    command.setStartWith(selectivity);
                    return command;
                }
                Column newColumn = this.parseColumnForTable(columnName);
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                command.setTable(table);
                command.setType(4);
                command.setOldColumn(column);
                command.setNewColumn(newColumn);
                return command;
            }
        }
        throw this.getSyntaxError();
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(Table table) throws SQLException {
        this.readIf("COLUMN");
        Schema schema = table.getSchema();
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setType(5);
        command.setTable(table);
        String columnName = this.readColumnIdentifier();
        Column column = this.parseColumnForTable(columnName);
        command.setNewColumn(column);
        if (this.readIf("BEFORE")) {
            command.setAddBefore(this.readColumnIdentifier());
        }
        return command;
    }

    private int parseAction() throws SQLException {
        if (this.readIf("CASCADE")) {
            return 1;
        }
        if (this.readIf("RESTRICT")) {
            return 0;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return 0;
        }
        this.read("SET");
        if (this.readIf("NULL")) {
            return 3;
        }
        this.read("DEFAULT");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private Prepared parseAlterTableAddConstraintIf(String tableName, Schema schema) throws SQLException {
        void var5_7;
        AlterTableAddConstraint command;
        String constraintName = null;
        String comment = null;
        if (this.readIf("CONSTRAINT")) {
            constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            comment = this.readCommentIf();
        }
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            AlterTableAddConstraint command2 = new AlterTableAddConstraint(this.session, schema);
            command2.setType(3);
            command2.setComment(comment);
            command2.setConstraintName(constraintName);
            command2.setTableName(tableName);
            if (this.readIf("HASH")) {
                command2.setPrimaryKeyHash(true);
            }
            this.read("(");
            command2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command2.setIndex(this.getSchema().findIndex(indexName));
            }
            return command2;
        }
        if (this.database.getMode().indexDefinitionInCreateTable && (this.readIf("INDEX") || this.readIf("KEY"))) {
            CreateIndex command3 = new CreateIndex(this.session, schema);
            command3.setComment(comment);
            command3.setTableName(tableName);
            if (!this.readIf("(")) {
                command3.setIndexName(this.readUniqueIdentifier());
                this.read("(");
            }
            command3.setIndexColumns(this.parseIndexColumnList());
            return command3;
        }
        if (this.readIf("CHECK")) {
            command = new AlterTableAddConstraint(this.session, schema);
            command.setType(0);
            command.setCheckExpression(this.readExpression());
        } else if (this.readIf("UNIQUE")) {
            this.readIf("INDEX");
            command = new AlterTableAddConstraint(this.session, schema);
            command.setType(1);
            if (!this.readIf("(")) {
                constraintName = this.readUniqueIdentifier();
                this.read("(");
            }
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(this.getSchema().findIndex(indexName));
            }
        } else if (this.readIf("FOREIGN")) {
            command = new AlterTableAddConstraint(this.session, schema);
            command.setType(2);
            this.read("KEY");
            this.read("(");
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(schema.findIndex(indexName));
            }
            this.read("REFERENCES");
            this.parseReferences(command, schema, tableName);
        } else {
            if (constraintName != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            var5_7.setCheckExisting(false);
        } else {
            this.readIf("CHECK");
            var5_7.setCheckExisting(true);
        }
        var5_7.setTableName(tableName);
        var5_7.setConstraintName(constraintName);
        var5_7.setComment(comment);
        return var5_7;
    }

    private void parseReferences(AlterTableAddConstraint command, Schema schema, String tableName) throws SQLException {
        if (this.readIf("(")) {
            command.setRefTableName(schema, tableName);
            command.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            String refTableName = this.readIdentifierWithSchema(schema.getName());
            command.setRefTableName(this.getSchema(), refTableName);
            if (this.readIf("(")) {
                command.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            String indexName = this.readIdentifierWithSchema();
            command.setRefIndex(this.getSchema().findIndex(indexName));
        }
        while (this.readIf("ON")) {
            if (this.readIf("DELETE")) {
                command.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            command.setUpdateAction(this.parseAction());
        }
        if (this.readIf("NOT")) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean force) throws SQLException {
        this.read("TABLE");
        boolean ifNotExists = this.readIfNoExists();
        String tableName = this.readIdentifierWithSchema();
        CreateLinkedTable command = new CreateLinkedTable(this.session, this.getSchema());
        command.setForce(force);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        this.read("(");
        command.setDriver(this.readString());
        this.read(",");
        command.setUrl(this.readString());
        this.read(",");
        command.setUser(this.readString());
        this.read(",");
        command.setPassword(this.readString());
        this.read(",");
        command.setOriginalTable(this.readString());
        this.read(")");
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            command.setEmitUpdates(true);
        }
        return command;
    }

    private CreateTable parseCreateTable(boolean temp, boolean globalTemp, boolean persistent) throws SQLException {
        boolean ifNotExists = this.readIfNoExists();
        String tableName = this.readIdentifierWithSchema();
        if (temp && globalTemp && "SESSION".equals(this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            globalTemp = false;
        }
        Schema schema = this.getSchema();
        CreateTable command = new CreateTable(this.session, schema);
        command.setPersistent(persistent);
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        if (this.readIf("AS")) {
            Query query = this.parseSelect();
            command.setQuery(query);
        } else {
            this.read("(");
            if (!this.readIf(")")) {
                do {
                    IndexColumn[] cols;
                    Prepared c;
                    if ((c = this.parseAlterTableAddConstraintIf(tableName, schema)) != null) {
                        command.addConstraintCommand(c);
                        continue;
                    }
                    String columnName = this.readColumnIdentifier();
                    Column column = this.parseColumnForTable(columnName);
                    if (column.getAutoIncrement()) {
                        IndexColumn[] cols2 = new IndexColumn[]{new IndexColumn()};
                        cols2[0].columnName = column.getName();
                        AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema);
                        pk.setType(3);
                        pk.setTableName(tableName);
                        pk.setIndexColumns(cols2);
                        command.addConstraintCommand(pk);
                    }
                    command.addColumn(column);
                    String constraintName = null;
                    if (this.readIf("CONSTRAINT")) {
                        constraintName = this.readColumnIdentifier();
                    }
                    if (this.readIf("PRIMARY")) {
                        this.read("KEY");
                        boolean hash = this.readIf("HASH");
                        cols = new IndexColumn[]{new IndexColumn()};
                        cols[0].columnName = column.getName();
                        AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema);
                        pk.setPrimaryKeyHash(hash);
                        pk.setType(3);
                        pk.setTableName(tableName);
                        pk.setIndexColumns(cols);
                        command.addConstraintCommand(pk);
                    } else if (this.readIf("UNIQUE")) {
                        AlterTableAddConstraint unique = new AlterTableAddConstraint(this.session, schema);
                        unique.setConstraintName(constraintName);
                        unique.setType(1);
                        cols = new IndexColumn[]{new IndexColumn()};
                        cols[0].columnName = columnName;
                        unique.setIndexColumns(cols);
                        unique.setTableName(tableName);
                        command.addConstraintCommand(unique);
                    }
                    if (this.readIf("CHECK")) {
                        Expression expr = this.readExpression();
                        column.addCheckConstraint(this.session, expr);
                    }
                    if (!this.readIf("REFERENCES")) continue;
                    AlterTableAddConstraint ref = new AlterTableAddConstraint(this.session, schema);
                    ref.setConstraintName(constraintName);
                    ref.setType(2);
                    cols = new IndexColumn[]{new IndexColumn()};
                    cols[0].columnName = columnName;
                    ref.setIndexColumns(cols);
                    ref.setTableName(tableName);
                    this.parseReferences(ref, schema, tableName);
                    command.addConstraintCommand(ref);
                } while (this.readIf(","));
                this.read(")");
            }
        }
        if (temp) {
            if (this.readIf("ON")) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    command.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    command.setOnCommitTruncate();
                }
            } else if (this.readIf("NOT")) {
                this.read("LOGGED");
            }
        }
        if (this.readIf("CLUSTERED")) {
            command.setClustered(true);
        }
        return command;
    }

    private int getCompareType(int tokenType) {
        switch (tokenType) {
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 5;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return "\"\"";
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return StringUtils.quoteIdentifier(s);
        }
        for (int i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return StringUtils.quoteIdentifier(s);
        }
        if (Parser.isKeyword(s)) {
            return StringUtils.quoteIdentifier(s);
        }
        return s;
    }

    public void setRightsChecked(boolean rightsChecked) {
        this.rightsChecked = rightsChecked;
    }

    public Expression parseExpression(String sql) throws SQLException {
        this.initialize(sql);
        this.read();
        return this.readExpression();
    }
}

