/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import java.util.Random;
import org.h2.bnf.Bnf;
import org.h2.bnf.Rule;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

public class RuleFixed
implements Rule {
    static final int YMD = 0;
    static final int HMS = 1;
    static final int NANOS = 2;
    static final int ANY_EXCEPT_SINGLE_QUOTE = 3;
    static final int ANY_EXCEPT_DOUBLE_QUOTE = 4;
    static final int ANY_UNTIL_EOL = 5;
    static final int ANY_UNTIL_END = 6;
    static final int ANY_WORD = 7;
    static final int HEX_START = 10;
    static final int CONCAT = 11;
    static final int AZ_UNDERLINE = 12;
    static final int AF = 13;
    static final int DIGIT = 14;
    private final int type;

    RuleFixed(int type) {
        this.type = type;
    }

    public String random(Bnf config, int level) {
        Random r = config.getRandom();
        switch (this.type) {
            case 0: {
                return "" + (1800 + r.nextInt(200)) + "-" + (1 + r.nextInt(12)) + "-" + (1 + r.nextInt(31));
            }
            case 1: {
                return "" + r.nextInt(24) + "-" + r.nextInt(60) + "-" + r.nextInt(60);
            }
            case 2: {
                return "" + (r.nextInt(100000) + r.nextInt(10000));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                StringBuffer buff = new StringBuffer();
                int len = r.nextInt(10);
                for (int i = 0; i < len; ++i) {
                    buff.append((char)(65 + r.nextInt(25)));
                }
                return buff.toString();
            }
            case 10: {
                return "0x";
            }
            case 11: {
                return "||";
            }
            case 12: {
                return "" + (char)(65 + r.nextInt(25));
            }
            case 13: {
                return "" + (char)(65 + r.nextInt(5));
            }
            case 14: {
                return "" + (char)(48 + r.nextInt(10));
            }
        }
        throw new Error("type=" + this.type);
    }

    public String name() {
        return "type=" + this.type;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap ruleMap) {
    }

    public String matchRemove(String query, Sentence sentence) {
        if (sentence.stop()) {
            return null;
        }
        if (query.length() == 0) {
            return null;
        }
        String s = query;
        block0 : switch (this.type) {
            case 0: {
                while (s.length() > 0 && "0123456789- ".indexOf(s.charAt(0)) >= 0) {
                    s = s.substring(1);
                }
                break;
            }
            case 1: {
                while (s.length() > 0 && "0123456789:. ".indexOf(s.charAt(0)) >= 0) {
                    s = s.substring(1);
                }
                break;
            }
            case 2: {
                while (s.length() > 0 && Character.isDigit(s.charAt(0))) {
                    s = s.substring(1);
                }
                break;
            }
            case 7: {
                while (s.length() > 0 && Character.isWhitespace(s.charAt(0))) {
                    s = s.substring(1);
                }
                break;
            }
            case 6: {
                while (s.length() > 1 && s.startsWith("*/")) {
                    s = s.substring(1);
                }
                break;
            }
            case 5: {
                while (s.length() > 0 && s.charAt(0) != '\n') {
                    s = s.substring(1);
                }
                break;
            }
            case 3: {
                while (true) {
                    if (s.length() > 0 && s.charAt(0) != '\'') {
                        s = s.substring(1);
                        continue;
                    }
                    if (!s.startsWith("''")) break block0;
                    s = s.substring(2);
                }
            }
            case 4: {
                while (true) {
                    if (s.length() > 0 && s.charAt(0) != '\"') {
                        s = s.substring(1);
                        continue;
                    }
                    if (!s.startsWith("\"\"")) break block0;
                    s = s.substring(2);
                }
            }
            case 10: {
                if (StringUtils.toUpperEnglish(s).startsWith("0X")) {
                    s = s.substring(2);
                    break;
                }
                if (!StringUtils.toUpperEnglish(s).startsWith("0")) break;
                s = s.substring(1);
                break;
            }
            case 11: {
                if (s.startsWith("||")) {
                    s = s.substring(2);
                    break;
                }
                if (!s.startsWith("|")) break;
                s = s.substring(1);
                break;
            }
            case 12: {
                if (s.length() <= 0 || !Character.isLetter(s.charAt(0)) && s.charAt(0) != '_') break;
                s = s.substring(1);
                break;
            }
            case 13: {
                char ch;
                if (s.length() <= 0 || (ch = Character.toUpperCase(s.charAt(0))) < 'A' || ch > 'F') break;
                s = s.substring(1);
                break;
            }
            case 14: {
                if (s.length() <= 0 || !Character.isDigit(s.charAt(0))) break;
                s = s.substring(1);
                break;
            }
            default: {
                throw new Error("type=" + this.type);
            }
        }
        if (s == query) {
            return null;
        }
        return s;
    }

    public void addNextTokenList(String query, Sentence sentence) {
        if (sentence.stop()) {
            return;
        }
        switch (this.type) {
            case 0: {
                if (query.length() != 0) break;
                sentence.add("2006-01-01", "2006-01-01", 1);
                break;
            }
            case 1: {
                if (query.length() != 0) break;
                sentence.add("12:00:00", "12:00:00", 1);
                break;
            }
            case 2: {
                if (query.length() != 0) break;
                sentence.add("nanoseconds", "0", 1);
                break;
            }
            case 3: {
                if (query.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("'", "'", 1);
                break;
            }
            case 4: {
                if (query.length() != 0) break;
                sentence.add("anything", "identifier", 1);
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                if (query.length() == 0) {
                    sentence.add("0x", "0x", 1);
                    break;
                }
                if (!"0".equals(query)) break;
                sentence.add("0x", "x", 1);
                break;
            }
            case 11: {
                if (query.length() == 0) {
                    sentence.add("||", "||", 1);
                    break;
                }
                if (!"|".equals(query)) break;
                sentence.add("||", "|", 1);
                break;
            }
            case 12: {
                if (query.length() != 0) break;
                sentence.add("character", "A", 1);
                break;
            }
            case 13: {
                if (query.length() != 0) break;
                sentence.add("hex character", "0A", 1);
                break;
            }
            case 14: {
                if (query.length() != 0) break;
                sentence.add("digit", "1", 1);
                break;
            }
            default: {
                throw new Error("type=" + this.type);
            }
        }
    }
}

