/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import org.h2.message.Message;
import org.h2.util.ClassUtils;
import org.h2.util.StringUtils;

public class JdbcUtils {
    public static void closeSilently(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static ResultSet getGeneratedKeys(Statement stat) throws SQLException {
        ResultSet rs = null;
        rs = stat.getGeneratedKeys();
        return rs;
    }

    public static void closeSilently(XAConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String driver, String url, String user, String password) throws SQLException {
        Properties prop = new Properties();
        prop.setProperty("user", user);
        prop.setProperty("password", password);
        return JdbcUtils.getConnection(driver, url, prop);
    }

    public static Connection getConnection(String driver, String url, Properties prop) throws SQLException {
        if (!StringUtils.isNullOrEmpty(driver)) {
            try {
                Class d = ClassUtils.loadUserClass(driver);
                if (Driver.class.isAssignableFrom(d)) {
                    return DriverManager.getConnection(url, prop);
                }
                if (Context.class.isAssignableFrom(d)) {
                    try {
                        Context context = (Context)d.newInstance();
                        DataSource ds = (DataSource)context.lookup(url);
                        String user = prop.getProperty("user");
                        String password = prop.getProperty("password");
                        return ds.getConnection(user, password);
                    }
                    catch (InstantiationException e) {
                        throw Message.convert(e);
                    }
                    catch (IllegalAccessException e) {
                        throw Message.convert(e);
                    }
                    catch (NamingException e) {
                        throw Message.convert(e);
                    }
                }
                return DriverManager.getConnection(url, prop);
            }
            catch (ClassNotFoundException e) {
                throw Message.getSQLException(90086, new String[]{driver}, e);
            }
        }
        return DriverManager.getConnection(url, prop);
    }
}

