/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.util.RandomUtils;

public class ObjectArray {
    private static final int SIZE_INIT = 4;
    private static final int SIZE_SHRINK = 256;
    private Object[] data;
    private int size;

    public ObjectArray() {
        this(4);
    }

    public ObjectArray(int size) {
        this.data = new Object[size > 1 ? size : 1];
    }

    public ObjectArray(Collection collection) {
        this.size = collection.size();
        this.data = new Object[this.size];
        Iterator it = collection.iterator();
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = it.next();
        }
    }

    private void throwException(int index) {
        throw new ArrayIndexOutOfBoundsException("i=" + index + " size=" + this.size);
    }

    public void add(Object value) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size);
        }
        this.data[this.size++] = value;
    }

    public Object get(int i) {
        if (SysProperties.CHECK && i >= this.size) {
            this.throwException(i);
        }
        return this.data[i];
    }

    public Object remove(int i) {
        if (SysProperties.CHECK && i >= this.size) {
            this.throwException(i);
        }
        Object value = this.data[i];
        System.arraycopy(this.data, i + 1, this.data, i, this.size - i - 1);
        --this.size;
        this.data[this.size] = null;
        return value;
    }

    public void removeRange(int from, int to) {
        if (SysProperties.CHECK && (to > this.size || from > to)) {
            throw new ArrayIndexOutOfBoundsException("to=" + to + " from=" + from + " size=" + this.size);
        }
        System.arraycopy(this.data, to, this.data, from, this.size - to);
        this.size -= to - from;
        for (int i = this.size + (to - from) - 1; i >= this.size; --i) {
            this.data[i] = null;
        }
    }

    public void setSize(int i) {
        this.ensureCapacity(i);
        this.size = i;
    }

    private void ensureCapacity(int i) {
        while (i >= this.data.length) {
            Object[] d = new Object[Math.max(4, this.data.length * 2)];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
        }
    }

    public void add(int i, Object value) {
        if (SysProperties.CHECK && i > this.size) {
            this.throwException(i);
        }
        this.ensureCapacity(this.size);
        if (i == this.size) {
            this.add(value);
        } else {
            System.arraycopy(this.data, i, this.data, i + 1, this.size - i);
            this.data[i] = value;
            ++this.size;
        }
    }

    public void set(int i, Object value) {
        if (SysProperties.CHECK && i >= this.size) {
            this.throwException(i);
        }
        this.data[i] = value;
    }

    public int size() {
        return this.size;
    }

    public void toArray(Object[] array) {
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.data[i];
        }
    }

    public void clear() {
        if (this.data.length > 256) {
            this.data = new Object[4];
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = null;
            }
        }
        this.size = 0;
    }

    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != o) continue;
            return i;
        }
        return -1;
    }

    public void addAll(ObjectArray list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.get(i));
        }
    }

    private void swap(int l, int r) {
        Object t = this.data[r];
        this.data[r] = this.data[l];
        this.data[l] = t;
    }

    public void sort(Comparator comp) {
        this.sort(comp, 0, this.size - 1);
    }

    private void sort(Comparator comp, int l, int r) {
        int j;
        int i;
        while (r - l > 10) {
            i = RandomUtils.nextInt(r - l - 4) + l + 2;
            if (comp.compare(this.get(l), this.get(r)) > 0) {
                this.swap(l, r);
            }
            if (comp.compare(this.get(i), this.get(l)) < 0) {
                this.swap(l, i);
            } else if (comp.compare(this.get(i), this.get(r)) > 0) {
                this.swap(i, r);
            }
            j = r - 1;
            this.swap(i, j);
            Object p = this.get(j);
            i = l;
            while (true) {
                if (comp.compare(this.get(++i), p) < 0) {
                    continue;
                }
                while (comp.compare(this.get(--j), p) > 0) {
                }
                if (i >= j) break;
                this.swap(i, j);
            }
            this.swap(i, r - 1);
            this.sort(comp, l, i - 1);
            l = i + 1;
        }
        for (i = l + 1; i <= r; ++i) {
            Object t = this.get(i);
            for (j = i - 1; j >= l && comp.compare(this.get(j), t) > 0; --j) {
                this.set(j + 1, this.get(j));
            }
            this.set(j + 1, t);
        }
    }
}

