/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.Driver;
import org.h2.server.pg.PgServer;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ObjectUtils;
import org.h2.util.ScriptReader;

public class PgServerThread
implements Runnable {
    private static final int TYPE_STRING = 12;
    private PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private String clientEncoding = "UTF-8";
    private String dateStyle = "ISO";
    private HashMap prepared = new HashMap();
    private HashMap portals = new HashMap();
    private HashSet types = new HashSet();

    PgServerThread(Socket socket, PgServer server) {
        this.server = server;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.server.log("Connect");
            InputStream ins = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(ins);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (Exception e) {
            this.error("process", e);
            this.server.logError(e);
        }
        finally {
            this.server.log("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int x;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        while ((x = this.dataIn.read()) > 0) {
            buff.write(x);
        }
        return new String(buff.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private int readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] buff) throws IOException {
        this.dataIn.readFully(buff);
    }

    private void error(String message, Exception e) {
        if (e != null) {
            this.server.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int x;
        if (this.initDone) {
            x = this.dataInRaw.read();
            if (x < 0) {
                this.stop = true;
                return;
            }
        } else {
            x = 0;
        }
        int len = this.dataInRaw.readInt();
        byte[] data = new byte[len -= 4];
        this.dataInRaw.readFully(data, 0, len);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
        switch (x) {
            case 0: {
                String param;
                this.server.log("Init");
                int version = this.readInt();
                if (version == 80877102) {
                    this.server.log("CancelRequest (not supported)");
                    this.server.log(" pid: " + this.readInt());
                    this.server.log(" key: " + this.readInt());
                    this.error("CancelRequest", null);
                    break;
                }
                if (version == 80877103) {
                    this.server.log("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.log("StartupMessage");
                this.server.log(" version " + version + " (" + (version >> 16) + "." + (version & 0xFF) + ")");
                while ((param = this.readString()).length() != 0) {
                    String value = this.readString();
                    if ("user".equals(param)) {
                        this.userName = value;
                        continue;
                    }
                    if ("database".equals(param)) {
                        this.databaseName = value;
                        continue;
                    }
                    if ("client_encoding".equals(param)) {
                        this.clientEncoding = value;
                        continue;
                    }
                    if (!"DateStyle".equals(param)) continue;
                    this.dateStyle = value;
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.log("PasswordMessage");
                String password = this.readString();
                try {
                    String baseDir = this.server.getBaseDir();
                    String db = this.databaseName;
                    if (baseDir != null) {
                        db = baseDir + "/" + db;
                    }
                    if (this.server.getIfExists()) {
                        db = db + ";IFEXISTS=TRUE";
                    }
                    String url = "jdbc:h2:" + db + ";MODE=PostgreSQL";
                    Properties prop = new Properties();
                    prop.setProperty("user", this.userName);
                    prop.setProperty("password", password);
                    this.conn = Driver.load().connect(url, prop);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.log("Parse");
                Prepared p = new Prepared();
                p.name = this.readString();
                p.sql = this.getSQL(this.readString());
                int count = this.readShort();
                p.paramType = new int[count];
                for (int i = 0; i < count; ++i) {
                    int type = this.readInt();
                    this.checkType(type);
                    p.paramType[i] = type;
                }
                try {
                    p.prep = this.conn.prepareStatement(p.sql);
                    this.prepared.put(p.name, p);
                    this.sendParseComplete();
                }
                catch (SQLException e) {
                    this.sendErrorResponse(e);
                }
                break;
            }
            case 66: {
                this.server.log("Bind");
                Portal portal = new Portal();
                portal.name = this.readString();
                String prepName = this.readString();
                Prepared prep = (Prepared)this.prepared.get(prepName);
                if (prep == null) {
                    this.sendErrorResponse("Portal not found");
                    break;
                }
                portal.sql = prep.sql;
                portal.prep = prep.prep;
                this.portals.put(portal.name, portal);
                int formatCodeCount = this.readShort();
                int[] formatCodes = new int[formatCodeCount];
                for (int i = 0; i < formatCodeCount; ++i) {
                    formatCodes[i] = this.readShort();
                }
                int paramCount = this.readShort();
                for (int i = 0; i < paramCount; ++i) {
                    int paramLen = this.readInt();
                    byte[] d2 = new byte[paramLen];
                    this.readFully(d2);
                    try {
                        this.setParameter(portal.prep, i, d2, formatCodes);
                        continue;
                    }
                    catch (SQLException e) {
                        this.sendErrorResponse(e);
                    }
                }
                int resultCodeCount = this.readShort();
                portal.resultColumnFormat = new int[resultCodeCount];
                for (int i = 0; i < resultCodeCount; ++i) {
                    portal.resultColumnFormat[i] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 68: {
                char type = (char)this.readByte();
                String name = this.readString();
                this.server.log("Describe");
                if (type == 'S') {
                    Prepared p = (Prepared)this.prepared.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Prepared not found: " + name);
                    }
                    PreparedStatement prep = p.prep;
                    this.sendParameterDescription(p);
                    break;
                }
                if (type == 'P') {
                    Portal p = (Portal)this.portals.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Portal not found: " + name);
                    }
                    PreparedStatement prep = p.prep;
                    try {
                        ResultSetMetaData meta = prep.getMetaData();
                        this.sendRowDescription(meta);
                    }
                    catch (SQLException e) {
                        this.sendErrorResponse(e);
                    }
                    break;
                }
                this.error("expected S or P, got " + type, null);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                String name = this.readString();
                this.server.log("Execute");
                Portal p = (Portal)this.portals.get(name);
                if (p == null) {
                    this.sendErrorResponse("Portal not found: " + name);
                    break;
                }
                int maxRows = this.readShort();
                PreparedStatement prep = p.prep;
                this.server.log(p.sql);
                try {
                    prep.setMaxRows(maxRows);
                    boolean result = prep.execute();
                    if (result) {
                        try {
                            ResultSet rs = prep.getResultSet();
                            ResultSetMetaData meta = rs.getMetaData();
                            this.sendRowDescription(meta);
                            while (rs.next()) {
                                this.sendDataRow(p.resultColumnFormat, rs);
                            }
                            this.sendCommandComplete(p.sql, 0);
                        }
                        catch (SQLException e) {
                            this.sendErrorResponse(e);
                        }
                        break;
                    }
                    this.sendCommandComplete(p.sql, prep.getUpdateCount());
                }
                catch (SQLException e) {
                    this.sendErrorResponse(e);
                }
                break;
            }
            case 83: {
                this.server.log("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.log("Query");
                String query = this.readString();
                ScriptReader reader = new ScriptReader(new StringReader(query));
                while (true) {
                    Statement stat = null;
                    try {
                        String s = reader.readStatement();
                        if (s == null) break;
                        s = this.getSQL(s);
                        stat = this.conn.createStatement();
                        boolean result = stat.execute(s);
                        if (result) {
                            ResultSet rs = stat.getResultSet();
                            ResultSetMetaData meta = rs.getMetaData();
                            this.sendRowDescription(meta);
                            while (rs.next()) {
                                this.sendDataRow(null, rs);
                            }
                            this.sendCommandComplete(s, 0);
                        } else {
                            this.sendCommandComplete(s, stat.getUpdateCount());
                        }
                        JdbcUtils.closeSilently(stat);
                        continue;
                    }
                    catch (SQLException e) {
                        this.sendErrorResponse(e);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeSilently(stat);
                        continue;
                    }
                    break;
                }
                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.log("Terminate");
                this.close();
                break;
            }
            default: {
                this.error("Unsupported: " + x + " (" + (char)x + ")", null);
            }
        }
    }

    private void checkType(int type) {
        if (this.types.contains(ObjectUtils.getInteger(type))) {
            this.error("Unsupported type: " + type, null);
        }
    }

    private String getSQL(String s) {
        String lower = s.toLowerCase();
        if (lower.startsWith("show max_identifier_length")) {
            s = "CALL 63";
        } else if (lower.startsWith("set client_encoding to")) {
            s = "set DATESTYLE ISO";
        }
        if (this.server.getLog()) {
            this.server.log(s + ";");
        }
        return s;
    }

    private void sendCommandComplete(String sql, int updateCount) throws IOException {
        String tag;
        this.startMessage(67);
        sql = sql.trim().toUpperCase();
        if (sql.startsWith("INSERT")) {
            tag = "INSERT 0 " + updateCount;
        } else if (sql.startsWith("DELETE")) {
            tag = "DELETE " + updateCount;
        } else if (sql.startsWith("UPDATE")) {
            tag = "UPDATE " + updateCount;
        } else if (sql.startsWith("SELECT") || sql.startsWith("CALL")) {
            tag = "SELECT";
        } else if (sql.startsWith("BEGIN")) {
            tag = "BEGIN";
        } else {
            this.error("check command tag: " + sql, null);
            tag = "UPDATE " + updateCount;
        }
        this.writeString(tag);
        this.sendMessage();
    }

    private void sendDataRow(int[] formatCodes, ResultSet rs) throws IOException {
        try {
            int i;
            int columns = rs.getMetaData().getColumnCount();
            String[] values = new String[columns];
            for (i = 0; i < columns; ++i) {
                values[i] = rs.getString(i + 1);
            }
            this.startMessage(68);
            this.writeShort(columns);
            for (i = 0; i < columns; ++i) {
                String s = values[i];
                if (s == null) {
                    this.writeInt(-1);
                    continue;
                }
                byte[] d2 = s.getBytes(this.getEncoding());
                this.writeInt(d2.length);
                this.write(d2);
            }
            this.sendMessage();
        }
        catch (SQLException e) {
            this.sendErrorResponse(e);
        }
    }

    private String getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return "UTF-8";
        }
        return this.clientEncoding;
    }

    private void setParameter(PreparedStatement prep, int i, byte[] d2, int[] formatCodes) throws SQLException {
        String s;
        boolean text = i >= formatCodes.length || formatCodes[i] == 0;
        try {
            if (text) {
                s = new String(d2, this.getEncoding());
            } else {
                this.server.logError(new SQLException("Binary format not supported"));
                s = new String(d2, this.getEncoding());
            }
        }
        catch (Exception e) {
            this.error("conversion error", e);
            s = null;
        }
        prep.setString(i + 1, s);
    }

    private void sendErrorResponse(SQLException e) throws IOException {
        this.error("SQLException", e);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(Prepared p) throws IOException {
        try {
            PreparedStatement prep = p.prep;
            ParameterMetaData meta = prep.getParameterMetaData();
            int count = meta.getParameterCount();
            this.startMessage(116);
            this.writeShort(count);
            for (int i = 0; i < count; ++i) {
                int type = p.paramType != null && p.paramType[i] != 0 ? p.paramType[i] : 12;
                this.checkType(type);
                this.writeInt(type);
            }
            this.sendMessage();
        }
        catch (SQLException e) {
            this.sendErrorResponse(e);
        }
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData meta) throws IOException {
        try {
            if (meta == null) {
                this.sendNoData();
            } else {
                int i;
                int columns = meta.getColumnCount();
                int[] types = new int[columns];
                int[] precision = new int[columns];
                String[] names = new String[columns];
                for (i = 0; i < columns; ++i) {
                    names[i] = meta.getColumnName(i + 1);
                    int type = meta.getColumnType(i + 1);
                    precision[i] = meta.getColumnDisplaySize(i + 1);
                    this.checkType(type);
                    types[i] = type;
                }
                this.startMessage(84);
                this.writeShort(columns);
                for (i = 0; i < columns; ++i) {
                    this.writeString(names[i].toLowerCase());
                    this.writeInt(0);
                    this.writeShort(0);
                    this.writeInt(types[i]);
                    this.writeShort(this.getTypeSize(types[i], precision[i]));
                    this.writeInt(this.getModifier(types[i]));
                    this.writeShort(0);
                }
                this.sendMessage();
            }
        }
        catch (SQLException e) {
            this.sendErrorResponse(e);
        }
    }

    private int getTypeSize(int type, int precision) {
        switch (type) {
            case 12: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private int getModifier(int type) {
        return -1;
    }

    private void sendErrorResponse(String message) throws IOException {
        this.error("Exception: " + message, null);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        InputStreamReader r;
        ResultSet rs;
        Statement stat;
        block5: {
            stat = null;
            rs = null;
            r = null;
            rs = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
            boolean tableFound = rs.next();
            stat = this.conn.createStatement();
            if (!tableFound || !(rs = stat.executeQuery("SELECT VERSION FROM PG_CATALOG.PG_VERSION")).next() || rs.getInt(1) != 1) break block5;
            stat.execute("set search_path = PUBLIC, pg_catalog");
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(rs);
            IOUtils.closeSilently(r);
            return;
        }
        try {
            String sql;
            r = new InputStreamReader(this.getClass().getResourceAsStream("pg_catalog.sql"));
            ScriptReader reader = new ScriptReader(new BufferedReader(r));
            while ((sql = reader.readStatement()) != null) {
                stat.execute(sql);
            }
            reader.close();
            rs = stat.executeQuery("SELECT OID FROM PG_CATALOG.PG_TYPE");
            while (rs.next()) {
                this.types.add(ObjectUtils.getInteger(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(rs);
            IOUtils.closeSilently(r);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(rs);
        IOUtils.closeSilently(r);
    }

    public void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.log("Close");
        }
        catch (Exception e) {
            this.server.logError(e);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int c;
        this.startMessage(90);
        try {
            c = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException e) {
            c = 69;
        }
        this.write((byte)c);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.processId);
        this.sendMessage();
    }

    private void writeString(String s) throws IOException {
        this.write(s.getBytes(this.getEncoding()));
        this.write(0);
    }

    private void writeInt(int i) throws IOException {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) throws IOException {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) throws IOException {
        this.dataOut.write(data);
    }

    private void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    private void startMessage(int messageType) {
        this.messageType = messageType;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] buff = this.outBuffer.toByteArray();
        int len = buff.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(len + 4);
        this.dataOut.write(buff);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String param, String value) throws IOException {
        this.startMessage(83);
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setProcessId(int id) {
        this.processId = id;
    }

    private static class Portal {
        String name;
        String sql;
        int[] resultColumnFormat;
        PreparedStatement prep;

        private Portal() {
        }
    }

    private static class Prepared {
        String name;
        String sql;
        PreparedStatement prep;
        int[] paramType;

        private Prepared() {
        }
    }
}

