/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.tools.CompressTool;

public class FileStoreOutputStream
extends OutputStream {
    private FileStore store;
    private DataPage page;
    private String compressionAlgorithm;
    private CompressTool compress;

    public FileStoreOutputStream(FileStore store, DataHandler handler, String compressionAlgorithm) {
        this.store = store;
        if (compressionAlgorithm != null) {
            this.compress = CompressTool.getInstance();
            this.compressionAlgorithm = compressionAlgorithm;
        }
        this.page = DataPage.create(handler, 16);
    }

    public void write(byte[] buff) throws IOException {
        this.write(buff, 0, buff.length);
    }

    public void write(byte[] buff, int off, int len) throws IOException {
        if (len > 0) {
            try {
                this.page.reset();
                if (this.compress != null) {
                    if (off != 0 || len != buff.length) {
                        byte[] b2 = new byte[len];
                        System.arraycopy(buff, off, b2, 0, len);
                        buff = b2;
                        off = 0;
                    }
                    int uncompressed = len;
                    buff = this.compress.compress(buff, this.compressionAlgorithm);
                    len = buff.length;
                    this.page.writeInt(len);
                    this.page.writeInt(uncompressed);
                    this.page.write(buff, off, len);
                } else {
                    this.page.writeInt(len);
                    this.page.write(buff, off, len);
                }
                this.page.fillAligned();
                this.store.write(this.page.getBytes(), 0, this.page.length());
            }
            catch (SQLException e) {
                throw Message.convertToIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }

    public void write(int b) throws IOException {
        throw new IOException("this method is not implemented");
    }
}

