/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.StringUtils;

public class WebServlet
extends HttpServlet {
    private static final long serialVersionUID = 9171446624885086692L;
    private WebServer server;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        Enumeration en = config.getInitParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = config.getInitParameter(name);
            if (!name.startsWith("-")) {
                name = "-" + name;
            }
            list.add(name);
            list.add(value);
        }
        String[] args = new String[list.size()];
        list.toArray(args);
        this.server = new WebServer();
        try {
            this.server.init(args);
        }
        catch (Exception e) {
            throw new ServletException("Init failed", (Throwable)e);
        }
    }

    public void destroy() {
    }

    private boolean allow(HttpServletRequest req) {
        InetAddress address;
        if (this.server.getAllowOthers()) {
            return true;
        }
        String addr = req.getRemoteAddr();
        try {
            address = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return address.isLoopbackAddress();
    }

    private String getAllowedFile(HttpServletRequest req, String requestedFile) {
        if (!this.allow(req)) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String value;
        String name;
        String file = req.getPathInfo();
        if (file == null) {
            resp.sendRedirect(req.getRequestURI() + "/");
            return;
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        file = this.getAllowedFile(req, file);
        byte[] bytes = null;
        Properties attributes = new Properties();
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getAttribute(name).toString();
            attributes.put(name, value);
        }
        en = req.getParameterNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getParameter(name);
            attributes.put(name, value);
        }
        WebSession session = null;
        String sessionId = attributes.getProperty("jsessionid");
        if (sessionId != null) {
            session = this.server.getSession(sessionId);
        }
        WebThread app = new WebThread(null, this.server);
        app.setSession(session, attributes);
        String ifModifiedSince = req.getHeader("if-modified-since");
        String hostname = req.getRemoteHost();
        file = app.processRequest(file, hostname);
        session = app.getSession();
        String mimeType = app.getMimeType();
        boolean cache = app.getCache();
        if (cache && this.server.getStartDateTime().equals(ifModifiedSince)) {
            resp.setStatus(304);
            return;
        }
        bytes = this.server.getFile(file);
        if (bytes == null) {
            resp.sendError(404);
            try {
                bytes = StringUtils.utf8Encode("File not found: " + file);
            }
            catch (SQLException e) {
                this.server.traceError(e);
            }
        } else {
            if (session != null && file.endsWith(".jsp")) {
                String page = StringUtils.utf8Decode(bytes);
                page = PageParser.parse(this.server, page, session.map);
                try {
                    bytes = StringUtils.utf8Encode(page);
                }
                catch (SQLException e) {
                    this.server.traceError(e);
                }
            }
            resp.setContentType(mimeType);
            if (!cache) {
                resp.setHeader("Cache-Control", "no-cache");
            } else {
                resp.setHeader("Cache-Control", "max-age=10");
                resp.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (bytes != null) {
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }
}

