/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.h2.server.ftp.FileObject;
import org.h2.server.ftp.FtpServer;

public class FtpData
extends Thread {
    private FtpServer server;
    private InetAddress address;
    private ServerSocket serverSocket;
    private volatile Socket socket;

    public FtpData(FtpServer server, InetAddress address, ServerSocket serverSocket) throws IOException {
        this.server = server;
        this.address = address;
        this.serverSocket = serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            FtpData ftpData = this;
            synchronized (ftpData) {
                Socket s = this.serverSocket.accept();
                if (s.getInetAddress().equals(this.address)) {
                    this.server.log("Data connected:" + s.getInetAddress() + " expected:" + this.address);
                    this.socket = s;
                    this.notifyAll();
                } else {
                    this.server.log("Data REJECTED:" + s.getInetAddress() + " expected:" + this.address);
                    this.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void waitUntilConnected() {
        while (this.serverSocket != null && this.socket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.server.log("connected");
    }

    public void close() {
        this.serverSocket = null;
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(FileObject file) throws IOException {
        this.waitUntilConnected();
        try {
            InputStream in = this.socket.getInputStream();
            file.write(in);
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(FileObject file, long skip) throws IOException {
        this.waitUntilConnected();
        try {
            OutputStream out = this.socket.getOutputStream();
            file.read(skip, out);
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(byte[] data) throws IOException {
        this.waitUntilConnected();
        try {
            OutputStream out = this.socket.getOutputStream();
            out.write(data);
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }
}

