/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.security.AES;
import org.h2.security.BlockCipher;
import org.h2.security.SHA256;
import org.h2.security.XTEA;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.RandomUtils;

public class SecureFileStore
extends FileStore {
    private byte[] key;
    private BlockCipher cipher;
    private BlockCipher cipherForInitVector;
    private byte[] buffer = new byte[4];
    private long pos;
    private byte[] bufferForInitVector;
    private int keyIterations;

    public SecureFileStore(DataHandler handler, String name, String mode, byte[] magic, String cipher, byte[] key, int keyIterations) throws SQLException {
        super(handler, name, mode, magic);
        this.key = key;
        if ("XTEA".equalsIgnoreCase(cipher)) {
            this.cipher = new XTEA();
            this.cipherForInitVector = new XTEA();
        } else if ("AES".equalsIgnoreCase(cipher)) {
            this.cipher = new AES();
            this.cipherForInitVector = new AES();
        } else {
            throw Message.getSQLException(90055, cipher);
        }
        this.keyIterations = keyIterations;
        this.bufferForInitVector = new byte[16];
    }

    protected byte[] generateSalt() {
        return RandomUtils.getSecureBytes(16);
    }

    protected void initKey(byte[] salt) {
        SHA256 sha = new SHA256();
        this.key = sha.getHashWithSalt(this.key, salt);
        for (int i = 0; i < this.keyIterations; ++i) {
            this.key = sha.getHash(this.key);
        }
        this.cipher.setKey(this.key);
        this.key = sha.getHash(this.key);
        this.cipherForInitVector.setKey(this.key);
    }

    protected void writeDirect(byte[] b, int off, int len) throws SQLException {
        super.write(b, off, len);
        this.pos += (long)len;
    }

    public void write(byte[] b, int off, int len) throws SQLException {
        if (this.buffer.length < b.length) {
            this.buffer = new byte[len];
        }
        System.arraycopy(b, off, this.buffer, 0, len);
        this.xorInitVector(this.buffer, 0, len, this.pos);
        this.cipher.encrypt(this.buffer, 0, len);
        super.write(this.buffer, 0, len);
        this.pos += (long)len;
    }

    protected void readFullyDirect(byte[] b, int off, int len) throws SQLException {
        super.readFully(b, off, len);
        this.pos += (long)len;
    }

    public void readFully(byte[] b, int off, int len) throws SQLException {
        super.readFully(b, off, len);
        this.cipher.decrypt(b, off, len);
        this.xorInitVector(b, off, len, this.pos);
        this.pos += (long)len;
    }

    public void seek(long x) throws SQLException {
        this.pos = x;
        super.seek(x);
    }

    public void setLength(long newLength) throws SQLException {
        long oldPos = this.pos;
        byte[] buff = new byte[16];
        long length = this.length();
        if (newLength > length) {
            this.seek(length);
            for (long i = length; i < newLength; i += 16L) {
                this.write(buff, 0, 16);
            }
            this.seek(oldPos);
        } else {
            super.setLength(newLength);
        }
    }

    private void xorInitVector(byte[] b, int off, int len, long pos) {
        byte[] iv = this.bufferForInitVector;
        while (len > 0) {
            int i;
            for (i = 0; i < 16; i += 8) {
                long block = pos + (long)i >>> 3;
                iv[i] = (byte)(block >> 56);
                iv[i + 1] = (byte)(block >> 48);
                iv[i + 2] = (byte)(block >> 40);
                iv[i + 3] = (byte)(block >> 32);
                iv[i + 4] = (byte)(block >> 24);
                iv[i + 5] = (byte)(block >> 16);
                iv[i + 6] = (byte)(block >> 8);
                iv[i + 7] = (byte)block;
            }
            this.cipherForInitVector.encrypt(iv, 0, 16);
            for (i = 0; i < 16; ++i) {
                int n = off + i;
                b[n] = (byte)(b[n] ^ iv[i]);
            }
            pos += 16L;
            off += 16;
            len -= 16;
        }
    }

    public boolean isEncrypted() {
        return true;
    }
}

