/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeHead;
import org.h2.index.BtreeLeaf;
import org.h2.index.BtreeNode;
import org.h2.index.BtreePage;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class BtreeIndex
extends BaseIndex
implements RecordReader {
    private Storage storage;
    private BtreePage root;
    private TableData tableData;
    private BtreeHead head;
    private boolean needRebuild;
    private int headPos;
    private long lastChange;

    public BtreeIndex(Session session, TableData table, int id, String indexName, Column[] columns, IndexType indexType, int headPos) throws SQLException {
        super(table, id, indexName, columns, indexType);
        this.tableData = table;
        Database db = table.getDatabase();
        this.storage = db.getStorage(this, id, false);
        this.headPos = headPos;
        if (headPos == -1 || this.database.getRecovery()) {
            this.truncate(session);
            this.needRebuild = true;
        } else {
            Record rec = this.storage.getRecordIfStored(session, headPos);
            if (rec != null && rec instanceof BtreeHead) {
                this.head = (BtreeHead)rec;
            }
            if (this.head != null && this.head.getConsistent()) {
                this.setRoot((BtreePage)this.storage.getRecord(session, this.head.getRootPosition()));
                this.needRebuild = false;
                this.rowCount = table.getRowCount(session);
            } else {
                this.truncate(session);
                this.needRebuild = true;
            }
        }
    }

    private void setRoot(BtreePage newRoot) {
        if (this.root != null) {
            this.root.setRoot(false);
        }
        newRoot.setRoot(true);
        this.root = newRoot;
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void remove(Session session) throws SQLException {
        this.storage.delete(session);
        this.storage = null;
    }

    private void setChanged(Session session) throws SQLException {
        if (this.head != null && !this.database.getLogIndexChanges()) {
            this.database.invalidateIndexSummary();
            if (this.head.getConsistent()) {
                this.deletePage(session, this.head);
                this.head.setConsistent(false);
                this.flushHead(session);
            }
            this.lastChange = System.currentTimeMillis();
        }
    }

    void updatePage(Session session, Record p) throws SQLException {
        if (this.database.getLogIndexChanges()) {
            this.storage.addRecord(session, p, p.getPos());
        } else {
            this.storage.updateRecord(session, p);
        }
    }

    void deletePage(Session session, Record p) throws SQLException {
        if (this.database.getLogIndexChanges()) {
            this.storage.removeRecord(session, p.getPos());
        }
    }

    void addPage(Session session, Record p) throws SQLException {
        this.storage.addRecord(session, p, -1);
    }

    public BtreePage getPage(Session session, int i) throws SQLException {
        return (BtreePage)this.storage.getRecord(session, i);
    }

    public void flush(Session session) throws SQLException {
        this.lastChange = 0L;
        if (this.storage != null) {
            this.storage.flushFile();
            this.deletePage(session, this.head);
            if (this.database.getLogIndexChanges() || !this.database.getLog().containsInDoubtTransactions()) {
                this.head.setConsistent(true);
            }
            this.flushHead(session);
        }
    }

    public void close(Session session) throws SQLException {
        this.flush(session);
        this.storage = null;
    }

    public void add(Session session, Row r) throws SQLException {
        this.setChanged(session);
        Row row = this.table.getTemplateRow();
        row.setPos(r.getPos());
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            int idx = col.getColumnId();
            Value v = r.getValue(idx);
            row.setValue(idx, v);
        }
        int splitPoint = this.root.add(row, session);
        if (splitPoint != 0) {
            SearchRow pivot = this.root.getData(splitPoint);
            BtreePage page1 = this.root;
            BtreePage page2 = this.root.split(session, splitPoint);
            this.setRoot(new BtreeNode(this, page1, pivot, page2));
            this.addPage(session, this.root);
            this.deletePage(session, this.head);
            this.head.setRootPosition(this.root.getPos());
            this.flushHead(session);
        }
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        this.setChanged(session);
        if (this.rowCount == 1L) {
            this.truncate(session);
        } else {
            this.root.remove(session, row, 0);
            --this.rowCount;
        }
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        if (SysProperties.CHECK && this.storage == null) {
            throw Message.getSQLException(90007);
        }
        if (first == null) {
            BtreeCursor cursor = new BtreeCursor(session, this, last);
            this.root.first(cursor);
            return cursor;
        }
        BtreeCursor cursor = new BtreeCursor(session, this, last);
        if (this.getRowCount(session) == 0L || !this.root.findFirst(cursor, first)) {
            cursor.setCurrentRow(null);
        }
        return cursor;
    }

    public int getLookupCost(int rowCount) {
        int i = 0;
        int j = 1;
        while ((j *= 8) <= rowCount) {
            ++i;
        }
        return i + 1;
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        return 10L * this.getCostRangeIndex(masks, this.tableData.getRowCount(session));
    }

    public Record read(Session session, DataPage s) throws SQLException {
        char c = (char)s.readByte();
        if (c == 'N') {
            return new BtreeNode(this, s);
        }
        if (c == 'L') {
            return new BtreeLeaf(this, session, s);
        }
        if (c == 'H') {
            return new BtreeHead(s);
        }
        throw Message.getSQLException(90030, this.getName());
    }

    ObjectArray readRowArray(DataPage s) throws SQLException {
        int len = s.readInt();
        ObjectArray rows = new ObjectArray(len);
        for (int i = 0; i < len; ++i) {
            SearchRow r;
            int pos = s.readInt();
            if (pos < 0) {
                r = null;
            } else {
                r = this.table.getTemplateSimpleRow(this.columns.length == 1);
                r.setPos(pos);
                for (int j = 0; j < this.columns.length; ++j) {
                    int idx = this.columns[j].getColumnId();
                    r.setValue(idx, s.readValue());
                }
            }
            rows.add(r);
        }
        return rows;
    }

    public Row getRow(Session session, int pos) throws SQLException {
        return this.tableData.getRow(session, pos);
    }

    private void flushHead(Session session) throws SQLException {
        this.updatePage(session, this.head);
        if (!this.database.getLogIndexChanges() && !this.database.getReadOnly()) {
            this.storage.flushRecord(this.head);
        }
        this.trace.debug("Index " + this.getSQL() + " head consistent=" + this.head.getConsistent());
    }

    public void truncate(Session session) throws SQLException {
        this.setChanged(session);
        this.storage.truncate(session);
        this.head = new BtreeHead();
        this.addPage(session, this.head);
        this.setRoot(new BtreeLeaf(this, new ObjectArray()));
        this.addPage(session, this.root);
        this.deletePage(session, this.head);
        this.head.setRootPosition(this.root.getPos());
        this.head.setConsistent(this.database.getLogIndexChanges());
        this.lastChange = System.currentTimeMillis();
        this.flushHead(session);
        this.headPos = this.head.getPos();
        this.rowCount = 0L;
    }

    public void checkRename() throws SQLException {
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public int getRecordOverhead() {
        return this.storage.getRecordOverhead();
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return true;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        if (first) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow row = cursor.getSearchRow();
                Value v = row.getValue(this.columnIndex[0]);
                if (v == ValueNull.INSTANCE) continue;
                return row;
            }
            return null;
        }
        return this.root.getLast(session);
    }
}

