/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Comparison
extends Condition {
    public static final int EQUAL = 0;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    private final Database database;
    private final int compareType;
    private Expression left;
    private Expression right;
    private int dataType = -2;

    public Comparison(Session session, int compareType, Expression left, Expression right) {
        this.database = session.getDatabase();
        this.left = left;
        this.right = right;
        this.compareType = compareType;
    }

    public String getSQL() {
        String sql;
        switch (this.compareType) {
            case 0: {
                sql = this.left.getSQL() + " = " + this.right.getSQL();
                break;
            }
            case 1: {
                sql = this.left.getSQL() + " >= " + this.right.getSQL();
                break;
            }
            case 2: {
                sql = this.left.getSQL() + " > " + this.right.getSQL();
                break;
            }
            case 3: {
                sql = this.left.getSQL() + " <= " + this.right.getSQL();
                break;
            }
            case 4: {
                sql = this.left.getSQL() + " < " + this.right.getSQL();
                break;
            }
            case 5: {
                sql = this.left.getSQL() + " <> " + this.right.getSQL();
                break;
            }
            case 6: {
                sql = this.left.getSQL() + " IS NULL";
                break;
            }
            case 7: {
                sql = this.left.getSQL() + " IS NOT NULL";
                break;
            }
            default: {
                throw Message.getInternalError("compareType=" + this.compareType);
            }
        }
        return "(" + sql + ")";
    }

    private Expression getCast(Expression expr, int dataType, long precision, int scale, Session session) throws SQLException {
        if (expr == ValueExpression.NULL) {
            return expr;
        }
        Function function = Function.getFunction(session.getDatabase(), "CAST");
        function.setParameter(0, expr);
        function.setDataType(dataType, precision, scale);
        function.doneWithParameters();
        return function.optimize(session);
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        if (this.right == null) {
            this.dataType = this.left.getType();
        } else {
            this.right = this.right.optimize(session);
            try {
                if (this.left instanceof ExpressionColumn && this.right.isConstant()) {
                    this.right = this.getCast(this.right, this.left.getType(), this.left.getPrecision(), this.left.getScale(), session);
                } else if (this.right instanceof ExpressionColumn && this.left.isConstant()) {
                    this.left = this.getCast(this.left, this.right.getType(), this.right.getPrecision(), this.right.getScale(), session);
                }
            }
            catch (SQLException e) {
                int code = e.getErrorCode();
                switch (code) {
                    case 22003: {
                        return ValueExpression.get(ValueBoolean.get(false));
                    }
                }
                throw e;
            }
            int lt = this.left.getType();
            int rt = this.right.getType();
            if (lt == rt) {
                if (lt == -1) {
                    throw Message.getSQLException(50004, this.getSQL());
                }
                this.dataType = lt;
            } else {
                this.dataType = Value.getHigherOrder(this.left.getType(), this.right.getType());
                long precision = Math.max(this.left.getPrecision(), this.right.getPrecision());
                int scale = Math.max(this.left.getScale(), this.right.getScale());
                if (this.dataType != lt) {
                    this.left = this.getCast(this.left, this.dataType, precision, scale, session);
                }
                if (this.dataType != rt) {
                    this.right = this.getCast(this.right, this.dataType, precision, scale, session);
                }
            }
        }
        if (this.compareType == 6 || this.compareType == 7) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (SysProperties.CHECK && (this.left == null || this.right == null)) {
                throw Message.getInternalError();
            }
            if (this.left == ValueExpression.NULL || this.right == ValueExpression.NULL) {
                return ValueExpression.NULL;
            }
            if (this.left.isConstant() && this.right.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        if (this.right == null) {
            boolean result;
            switch (this.compareType) {
                case 6: {
                    result = l == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    result = l != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw Message.getInternalError("type=" + this.compareType);
                }
            }
            return ValueBoolean.get(result);
        }
        l = l.convertTo(this.dataType);
        Value r = this.right.getValue(session).convertTo(this.dataType);
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        boolean result = Comparison.compareNotNull(this.database, l, r, this.compareType);
        return ValueBoolean.get(result);
    }

    public static boolean compareNotNull(Database database, Value l, Value r, int compareType) throws SQLException {
        boolean result;
        switch (compareType) {
            case 0: {
                result = database.areEqual(l, r);
                break;
            }
            case 5: {
                result = !database.areEqual(l, r);
                break;
            }
            case 1: {
                result = database.compare(l, r) >= 0;
                break;
            }
            case 2: {
                result = database.compare(l, r) > 0;
                break;
            }
            case 3: {
                result = database.compare(l, r) <= 0;
                break;
            }
            case 4: {
                result = database.compare(l, r) < 0;
                break;
            }
            default: {
                throw Message.getInternalError("type=" + compareType);
            }
        }
        return result;
    }

    private int getReversedCompareType(int type) {
        switch (this.compareType) {
            case 0: 
            case 5: {
                return type;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw Message.getInternalError("type=" + this.compareType);
    }

    private int getNotCompareType(int type) {
        switch (this.compareType) {
            case 0: {
                return 5;
            }
            case 5: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
        }
        throw Message.getInternalError("type=" + this.compareType);
    }

    public Expression getNotIfPossible(Session session) {
        int type = this.getNotCompareType(this.compareType);
        return new Comparison(session, type, this.left, this.right);
    }

    public void createIndexConditions(Session session, TableFilter filter) {
        boolean addIndex;
        if (this.right == null) {
            return;
        }
        ExpressionColumn l = null;
        if (this.left instanceof ExpressionColumn && filter != (l = (ExpressionColumn)this.left).getTableFilter()) {
            l = null;
        }
        ExpressionColumn r = null;
        if (this.right instanceof ExpressionColumn && filter != (r = (ExpressionColumn)this.right).getTableFilter()) {
            r = null;
        }
        if (l == null && r == null) {
            return;
        }
        if (l != null && r != null) {
            return;
        }
        if (l == null) {
            if (!this.left.isEverything(ExpressionVisitor.getNotFromResolver(filter))) {
                return;
            }
        } else if (r == null) {
            if (!this.right.isEverything(ExpressionVisitor.getNotFromResolver(filter))) {
                return;
            }
        } else {
            return;
        }
        switch (this.compareType) {
            case 5: {
                addIndex = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                addIndex = true;
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.compareType);
            }
        }
        if (addIndex) {
            if (l != null) {
                filter.addIndexCondition(new IndexCondition(this.compareType, l, this.right));
            } else if (r != null) {
                int compareRev = this.getReversedCompareType(this.compareType);
                filter.addIndexCondition(new IndexCondition(compareRev, r, this.left));
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (this.compareType == 6 && outerJoin) {
            return;
        }
        super.addFilterConditions(filter, outerJoin);
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.left.mapColumns(resolver, level);
        if (this.right != null) {
            this.right.mapColumns(resolver, level);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && (this.right == null || this.right.isEverything(visitor));
    }

    public int getCost() {
        return this.left.getCost() + (this.right == null ? 0 : this.right.getCost()) + 1;
    }

    public Comparison getAdditional(Session session, Comparison other) {
        if (this.compareType == other.compareType && this.compareType == 0) {
            boolean lc = this.left.isConstant();
            boolean rc = this.right.isConstant();
            boolean l2c = other.left.isConstant();
            boolean r2c = other.right.isConstant();
            String l = this.left.getSQL();
            String l2 = other.left.getSQL();
            String r = this.right.getSQL();
            String r2 = other.right.getSQL();
            if (!(rc && r2c || !l.equals(l2))) {
                return new Comparison(session, 0, this.right, other.right);
            }
            if (!(rc && l2c || !l.equals(r2))) {
                return new Comparison(session, 0, this.right, other.left);
            }
            if (!(lc && r2c || !r.equals(l2))) {
                return new Comparison(session, 0, this.left, other.right);
            }
            if (!(lc && l2c || !r.equals(r2))) {
                return new Comparison(session, 0, this.left, other.left);
            }
        }
        return null;
    }
}

