/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.TreeCursor;
import org.h2.index.TreeNode;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class TreeIndex
extends BaseIndex {
    private TreeNode root;
    private TableData tableData;

    public TreeIndex(TableData table, int id, String indexName, Column[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        this.tableData = table;
    }

    public void close(Session session) throws SQLException {
        this.root = null;
    }

    public void add(Session session, Row row) throws SQLException {
        TreeNode n;
        TreeNode i = new TreeNode(row);
        TreeNode x = n = this.root;
        boolean isLeft = true;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    ++this.rowCount;
                    return;
                }
                break;
            }
            Row r = n.row;
            int compare = this.compareRows(row, r);
            if (compare == 0) {
                if (this.indexType.isUnique() && !this.isNull(row)) {
                    throw this.getDuplicateKeyException();
                }
                compare = this.compareKeys(row, r);
            }
            isLeft = compare < 0;
            x = n;
            n = this.child(x, isLeft);
        }
        this.set(x, isLeft, i);
        this.balance(x, isLeft);
        ++this.rowCount;
    }

    private void balance(TreeNode x, boolean isLeft) {
        while (true) {
            int sign = isLeft ? 1 : -1;
            switch (x.balance * sign) {
                case 1: {
                    x.balance = 0;
                    return;
                }
                case 0: {
                    x.balance = -sign;
                    break;
                }
                case -1: {
                    TreeNode l = this.child(x, isLeft);
                    if (l.balance == -sign) {
                        this.replace(x, l);
                        this.set(x, isLeft, this.child(l, !isLeft));
                        this.set(l, !isLeft, x);
                        x.balance = 0;
                        l.balance = 0;
                    } else {
                        TreeNode r = this.child(l, !isLeft);
                        this.replace(x, r);
                        this.set(l, !isLeft, this.child(r, isLeft));
                        this.set(r, isLeft, l);
                        this.set(x, isLeft, this.child(r, !isLeft));
                        this.set(r, !isLeft, x);
                        int rb = r.balance;
                        x.balance = rb == -sign ? sign : 0;
                        l.balance = rb == sign ? -sign : 0;
                        r.balance = 0;
                    }
                    return;
                }
            }
            if (x == this.root) {
                return;
            }
            isLeft = x.isFromLeft();
            x = x.parent;
        }
    }

    private TreeNode child(TreeNode x, boolean isLeft) {
        return isLeft ? x.left : x.right;
    }

    private void replace(TreeNode x, TreeNode n) {
        if (x == this.root) {
            this.root = n;
            if (n != null) {
                n.parent = null;
            }
        } else {
            this.set(x.parent, x.isFromLeft(), n);
        }
    }

    private void set(TreeNode parent, boolean left, TreeNode n) {
        if (left) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        if (n != null) {
            n.parent = parent;
        }
    }

    public void remove(Session session, Row row) throws SQLException {
        TreeNode n;
        TreeNode x = this.findFirstNode(row, true);
        if (x == null) {
            throw Message.getInternalError("not found!");
        }
        if (x.left == null) {
            n = x.right;
        } else if (x.right == null) {
            n = x.left;
        } else {
            TreeNode d = x;
            TreeNode temp = x = x.left;
            while ((temp = temp.right) != null) {
                x = temp;
            }
            n = x.left;
            int b = x.balance;
            x.balance = d.balance;
            d.balance = b;
            TreeNode xp = x.parent;
            TreeNode dp = d.parent;
            if (d == this.root) {
                this.root = x;
            }
            x.parent = dp;
            if (dp != null) {
                if (dp.right == d) {
                    dp.right = x;
                } else {
                    dp.left = x;
                }
            }
            if (xp == d) {
                d.parent = x;
                if (d.left == x) {
                    x.left = d;
                    x.right = d.right;
                } else {
                    x.right = d;
                    x.left = d.left;
                }
            } else {
                d.parent = xp;
                xp.right = d;
                x.right = d.right;
                x.left = d.left;
            }
            if (SysProperties.CHECK && (x.right == null || x == null)) {
                throw Message.getInternalError("tree corrupted");
            }
            x.right.parent = x;
            x.left.parent = x;
            d.left = n;
            if (n != null) {
                n.parent = d;
            }
            d.right = null;
            x = d;
        }
        --this.rowCount;
        boolean isLeft = x.isFromLeft();
        this.replace(x, n);
        n = x.parent;
        while (n != null) {
            x = n;
            int sign = isLeft ? 1 : -1;
            switch (x.balance * sign) {
                case -1: {
                    x.balance = 0;
                    break;
                }
                case 0: {
                    x.balance = sign;
                    return;
                }
                case 1: {
                    TreeNode r = this.child(x, !isLeft);
                    int b = r.balance;
                    if (b * sign >= 0) {
                        this.replace(x, r);
                        this.set(x, !isLeft, this.child(r, isLeft));
                        this.set(r, isLeft, x);
                        if (b == 0) {
                            x.balance = sign;
                            r.balance = -sign;
                            return;
                        }
                        x.balance = 0;
                        r.balance = 0;
                        x = r;
                        break;
                    }
                    TreeNode l = this.child(r, isLeft);
                    this.replace(x, l);
                    b = l.balance;
                    this.set(r, isLeft, this.child(l, !isLeft));
                    this.set(l, !isLeft, r);
                    this.set(x, !isLeft, this.child(l, isLeft));
                    this.set(l, isLeft, x);
                    x.balance = b == sign ? -sign : 0;
                    r.balance = b == -sign ? sign : 0;
                    l.balance = 0;
                    x = l;
                }
            }
            isLeft = x.isFromLeft();
            n = x.parent;
        }
    }

    private TreeNode findFirstNode(SearchRow row, boolean withKey) throws SQLException {
        TreeNode x;
        TreeNode result = x = this.root;
        while (x != null) {
            result = x;
            int compare = this.compareRows(x.row, row);
            if (compare == 0 && withKey) {
                compare = this.compareKeys(x.row, row);
            }
            if (compare == 0) {
                if (withKey) {
                    return x;
                }
                x = x.left;
                continue;
            }
            if (compare > 0) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return result;
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        if (first == null) {
            TreeNode n;
            TreeNode x = this.root;
            while (x != null && (n = x.left) != null) {
                x = n;
            }
            return new TreeCursor(this, x, null, last);
        }
        TreeNode x = this.findFirstNode(first, false);
        return new TreeCursor(this, x, first, last);
    }

    public int getLookupCost(int rowCount) {
        int i = 0;
        int j = 1;
        while ((j += j) < rowCount) {
            ++i;
        }
        return i;
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        return this.getCostRangeIndex(masks, this.tableData.getRowCount(session));
    }

    public void remove(Session session) throws SQLException {
        this.truncate(session);
    }

    public void truncate(Session session) throws SQLException {
        this.root = null;
        this.rowCount = 0L;
    }

    TreeNode next(TreeNode x) {
        if (x == null) {
            return null;
        }
        TreeNode r = x.right;
        if (r != null) {
            x = r;
            TreeNode l = x.left;
            while (l != null) {
                x = l;
                l = x.left;
            }
            return x;
        }
        TreeNode ch = x;
        x = x.parent;
        while (x != null && ch == x.right) {
            ch = x;
            x = x.parent;
        }
        return x;
    }

    public void checkRename() throws SQLException {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return true;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        TreeNode n;
        if (first) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow row = cursor.getSearchRow();
                Value v = row.getValue(this.columnIndex[0]);
                if (v == ValueNull.INSTANCE) continue;
                return row;
            }
            return null;
        }
        TreeNode x = this.root;
        while (x != null && (n = x.right) != null) {
            x = n;
        }
        if (x != null) {
            return x.row;
        }
        return null;
    }
}

