/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class Engine {
    private static final Engine instance = new Engine();
    private final HashMap databases = new HashMap();

    private Engine() {
    }

    public static Engine getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession(ConnectionInfo ci, boolean ifExists, String cipher) throws SQLException {
        String name = ci.getName();
        Database database = ci.isUnnamed() ? null : (Database)this.databases.get(name);
        User user = null;
        boolean opened = false;
        if (database == null) {
            if (ifExists && !Database.exists(name)) {
                throw Message.getSQLException(90013, name);
            }
            database = new Database(name, ci, cipher);
            opened = true;
            if (database.getAllUsers().size() == 0) {
                user = new User(database, database.allocateObjectId(false, true), ci.getUserName(), false);
                user.setAdmin(true);
                user.setUserPasswordHash(ci.getUserPasswordHash());
                database.setMasterUser(user);
            }
            if (!ci.isUnnamed()) {
                this.databases.put(name, database);
            }
        }
        Database database2 = database;
        synchronized (database2) {
            if (database.isClosing()) {
                return null;
            }
            if (user == null) {
                try {
                    database.checkFilePasswordHash(cipher, ci.getFilePasswordHash());
                    user = database.getUser(ci.getUserName());
                    user.checkUserPasswordHash(ci.getUserPasswordHash());
                    if (opened && !user.getAdmin()) {
                        database.setEventListener(null);
                    }
                }
                catch (SQLException e) {
                    database.removeSession(null);
                    throw e;
                }
            }
            this.checkClustering(ci, database);
            Session session = database.createSession(user);
            return session;
        }
    }

    public synchronized Session getSession(ConnectionInfo ci) throws SQLException {
        Session session;
        boolean ifExists = ci.removeProperty("IFEXISTS", false);
        boolean ignoreUnknownSetting = ci.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String cipher = ci.removeProperty("CIPHER", null);
        while ((session = this.openSession(ci, ifExists, cipher)) == null) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {}
        }
        String[] keys = ci.getKeys();
        session.setAllowLiterals(true);
        for (int i = 0; i < keys.length; ++i) {
            String setting = keys[i];
            String value = ci.getProperty(setting);
            try {
                CommandInterface command = session.prepareCommand("SET " + Parser.quoteIdentifier(setting) + " " + value);
                command.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                if (ignoreUnknownSetting) continue;
                session.close();
                throw e;
            }
        }
        session.setAllowLiterals(false);
        session.commit(true);
        session.getDatabase().getTrace("session").info("connected #" + session.getId());
        return session;
    }

    private void checkClustering(ConnectionInfo ci, Database database) throws SQLException {
        String clusterSession = ci.getProperty(13, null);
        if ("''".equals(clusterSession)) {
            return;
        }
        String clusterDb = database.getCluster();
        if (!"''".equals(clusterDb) && !StringUtils.equals(clusterSession, clusterDb)) {
            if (clusterDb.equals("''")) {
                throw Message.getSQLException(90093);
            }
            throw Message.getSQLException(90094, clusterDb);
        }
    }

    public void close(String name) {
        this.databases.remove(name);
    }
}

