/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.ref.WeakReference;
import org.h2.engine.Database;

public class DatabaseCloser
extends Thread {
    private final boolean shutdownHook;
    private volatile WeakReference databaseRef;
    private int delayInMillis;

    DatabaseCloser(Database db, int delayInMillis, boolean shutdownHook) {
        this.databaseRef = new WeakReference<Database>(db);
        this.delayInMillis = delayInMillis;
        this.shutdownHook = shutdownHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            this.databaseRef = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.delayInMillis > 0) {
            try {
                int step = 100;
                Thread.sleep(step);
                this.delayInMillis -= step;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.databaseRef != null) continue;
            return;
        }
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            Database database;
            if (this.databaseRef != null && (database = (Database)this.databaseRef.get()) != null) {
                database.close(this.shutdownHook);
            }
        }
    }
}

