/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.message.Message;

public class CreateFunctionAlias
extends DefineCommand {
    private String aliasName;
    private String javaClassMethod;
    private boolean ifNotExists;

    public CreateFunctionAlias(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        if (db.findFunctionAlias(this.aliasName) != null) {
            if (!this.ifNotExists) {
                throw Message.getSQLException(90076, this.aliasName);
            }
        } else {
            int id = this.getObjectId(false, true);
            FunctionAlias functionAlias = new FunctionAlias(db, id, this.aliasName, this.javaClassMethod);
            db.addDatabaseObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }
}

