/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class CacheLRU
implements Cache {
    public static final String TYPE_NAME = "LRU";
    private int len;
    private int maxSize;
    private CacheObject[] values;
    private int mask;
    private CacheWriter writer;
    private int sizeRecords;
    private int sizeBlocks;
    private CacheObject head = new CacheHead();

    public CacheLRU(CacheWriter writer, int maxSize) {
        this.writer = writer;
        this.len = maxSize / 2;
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.maxSize = maxSize;
        this.clear();
    }

    public void put(CacheObject rec) throws SQLException {
        if (Constants.CHECK) {
            for (int i = 0; i < rec.getBlockCount(); ++i) {
                CacheObject old = this.find(rec.getPos() + i);
                if (old == null) continue;
                throw Message.getInternalError("try to add a record twice i=" + i);
            }
        }
        int index = rec.getPos() & this.mask;
        rec.chained = this.values[index];
        this.values[index] = rec;
        ++this.sizeRecords;
        this.sizeBlocks += rec.getBlockCount();
        this.addToFront(rec);
        this.removeOld();
    }

    public CacheObject update(int pos, CacheObject rec) throws SQLException {
        CacheObject old = this.find(pos);
        if (old == null) {
            this.put(rec);
        } else {
            if (Constants.CHECK && old != rec) {
                throw Message.getInternalError("old != record old=" + old + " new=" + rec);
            }
            this.removeFromLinkedList(rec);
            this.addToFront(rec);
        }
        return old;
    }

    private void removeOld() throws SQLException {
        if (this.sizeBlocks < this.maxSize) {
            return;
        }
        int i = 0;
        ObjectArray changed = new ObjectArray();
        while (this.sizeBlocks * 4 > this.maxSize * 3 && this.sizeRecords > 16) {
            CacheObject last = this.head.next;
            if (i++ >= this.sizeRecords) break;
            if (Constants.CHECK && last == this.head) {
                throw Message.getInternalError("try to remove head");
            }
            if (!last.canRemove()) {
                this.removeFromLinkedList(last);
                this.addToFront(last);
                continue;
            }
            this.remove(last.getPos());
            if (!last.isChanged()) continue;
            changed.add(last);
        }
        if (changed.size() > 0) {
            CacheObject.sort(changed);
            for (i = 0; i < changed.size(); ++i) {
                CacheObject rec = (CacheObject)changed.get(i);
                this.writer.writeBack(rec);
            }
        }
    }

    private void addToFront(CacheObject rec) {
        if (Constants.CHECK && rec == this.head) {
            throw Message.getInternalError("try to move head");
        }
        rec.next = this.head;
        rec.previous = this.head.previous;
        rec.previous.next = rec;
        this.head.previous = rec;
    }

    private void removeFromLinkedList(CacheObject rec) {
        if (Constants.CHECK && rec == this.head) {
            throw Message.getInternalError("try to remove head");
        }
        rec.previous.next = rec.next;
        rec.next.previous = rec.previous;
        rec.next = null;
        rec.previous = null;
    }

    public void remove(int pos) {
        int index = pos & this.mask;
        CacheObject rec = this.values[index];
        if (rec == null) {
            return;
        }
        if (rec.getPos() == pos) {
            this.values[index] = rec.chained;
        } else {
            do {
                CacheObject last = rec;
                rec = rec.chained;
                if (rec != null) continue;
                return;
            } while (rec.getPos() != pos);
            last.chained = rec.chained;
        }
        --this.sizeRecords;
        this.sizeBlocks -= rec.getBlockCount();
        this.removeFromLinkedList(rec);
        if (Constants.CHECK) {
            rec.chained = null;
            if (this.find(pos) != null) {
                throw Message.getInternalError("not removed!");
            }
        }
    }

    public CacheObject find(int pos) {
        CacheObject rec = this.values[pos & this.mask];
        while (rec != null && rec.getPos() != pos) {
            rec = rec.chained;
        }
        return rec;
    }

    public CacheObject get(int pos) {
        CacheObject rec = this.find(pos);
        if (rec != null) {
            this.removeFromLinkedList(rec);
            this.addToFront(rec);
        }
        return rec;
    }

    public ObjectArray getAllChanged() {
        ObjectArray list = new ObjectArray();
        block0: for (int i = 0; i < this.len; ++i) {
            CacheObject rec = this.values[i];
            while (rec != null) {
                if (rec.isChanged()) {
                    list.add(rec);
                    if (list.size() >= this.sizeRecords) {
                        if (!Constants.CHECK) continue block0;
                        if (list.size() > this.sizeRecords) {
                            throw Message.getInternalError("cache chain error");
                        }
                    }
                }
                rec = rec.chained;
            }
        }
        return list;
    }

    public void clear() {
        this.head.next = this.head.previous = this.head;
        this.values = new CacheObject[this.len];
        this.sizeRecords = 0;
        this.sizeBlocks = 0;
    }

    public void setMaxSize(int newSize) throws SQLException {
        this.maxSize = newSize < 0 ? 0 : newSize;
        this.removeOld();
    }

    public String getTypeName() {
        return TYPE_NAME;
    }
}

