/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.tools.RunScriptThread;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;

public class RunScript {
    private static final boolean MULTI_THREAD = false;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <file>] [-driver <driver] [-options <option> ...]");
    }

    public static void main(String[] args) throws SQLException {
        new RunScript().run(args);
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String script = "backup.sql";
        String options = null;
        boolean continueOnError = false;
        boolean showTime = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-continueOnError")) {
                continueOnError = true;
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            if (args[i].equals("-time")) {
                showTime = true;
                continue;
            }
            if (args[i].equals("-driver")) {
                String driver = args[++i];
                try {
                    ClassUtils.loadClass(driver);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw Message.convert(e);
                }
            }
            if (args[i].equals("-options")) {
                StringBuffer buff = new StringBuffer();
                ++i;
                while (i < args.length) {
                    buff.append(' ');
                    buff.append(args[i]);
                    ++i;
                }
                options = buff.toString();
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || password == null || script == null) {
            this.showUsage();
            return;
        }
        long time = System.currentTimeMillis();
        if (options != null) {
            RunScript.executeRunscript(url, user, password, script, options);
        } else {
            RunScript.execute(url, user, password, script, null, continueOnError);
        }
        time = System.currentTimeMillis() - time;
        if (showTime) {
            System.out.println("Done in " + time + " ms");
        }
    }

    public static ResultSet execute(Connection conn, Reader reader) throws SQLException {
        String sql;
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            boolean resultSet = stat.execute(sql);
            if (!resultSet) continue;
            if (rs != null) {
                rs.close();
                rs = null;
            }
            rs = stat.getResultSet();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(Connection conn, HashMap threadMap, String fileName, boolean continueOnError, String charsetName) throws SQLException, IOException {
        FileInputStream in = FileUtils.openFileInputStream(fileName);
        String path = FileUtils.getParent(fileName);
        try {
            BufferedInputStream bin = new BufferedInputStream(in, 4096);
            InputStreamReader reader = new InputStreamReader((InputStream)bin, charsetName);
            RunScript.execute(conn, threadMap, continueOnError, path, reader, charsetName);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void execute(Connection conn, HashMap threadMap, boolean continueOnError, String path, Reader reader, String charsetName) throws SQLException, IOException {
        String sql;
        Statement stat = conn.createStatement();
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            if ((sql = sql.trim()).startsWith("@") && StringUtils.toUpperEnglish(sql).startsWith("@INCLUDE")) {
                if (!FileUtils.isAbsolute(sql = sql.substring("@INCLUDE".length()).trim())) {
                    sql = path + "/" + sql;
                }
                RunScript.execute(conn, threadMap, sql, continueOnError, charsetName);
                continue;
            }
            try {
                if (sql.trim().length() <= 0) continue;
                stat.execute(sql);
            }
            catch (SQLException e) {
                if (continueOnError) {
                    e.printStackTrace();
                    continue;
                }
                throw e;
            }
        }
        Iterator it = threadMap.values().iterator();
        while (it.hasNext()) {
            RunScriptThread thread = (RunScriptThread)it.next();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRunscript(String url, String user, String password, String fileName, String options) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            stat = conn.createStatement();
            String sql = "RUNSCRIPT FROM '" + fileName + "' " + options;
            stat.execute(sql);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String url, String user, String password, String fileName, String charsetName, boolean continueOnError) throws SQLException {
        try {
            Driver.load();
            Connection conn = DriverManager.getConnection(url, user, password);
            if (charsetName == null) {
                charsetName = "UTF8";
            }
            HashMap threadMap = new HashMap();
            try {
                RunScript.execute(conn, threadMap, fileName, continueOnError, charsetName);
            }
            finally {
                conn.close();
            }
        }
        catch (IOException e) {
            throw Message.convertIOException(e, fileName);
        }
    }
}

