/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.index.BtreeIndex;
import org.h2.index.BtreePage;
import org.h2.index.BtreePosition;
import org.h2.index.Cursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class BtreeCursor
implements Cursor {
    private BtreeIndex index;
    private BtreePosition top;
    private Row current;
    private boolean first;
    private SearchRow last;

    BtreeCursor(BtreeIndex index, SearchRow last) {
        this.index = index;
        this.last = last;
        this.first = true;
    }

    void setStackPosition(int position) {
        this.top.position = position;
    }

    void push(BtreePage page, int position) {
        if (Constants.CHECK && this.top != null && this.top.page == page) {
            throw Message.getInternalError();
        }
        this.top = new BtreePosition(page, position, this.top);
    }

    BtreePosition pop() {
        BtreePosition t = this.top;
        if (t == null) {
            return null;
        }
        this.top = this.top.next;
        return t;
    }

    void setCurrentRow(int pos) throws SQLException {
        this.current = pos == -1 ? null : this.index.getRow(pos);
    }

    public Row get() throws SQLException {
        return this.current;
    }

    public int getPos() {
        return this.current.getPos();
    }

    public boolean next() throws SQLException {
        if (this.first) {
            this.first = false;
            return this.current != null;
        }
        this.top.page.next(this, this.top.position);
        if (this.current != null && this.last != null && this.index.compareRows(this.current, this.last) > 0) {
            this.current = null;
        }
        return this.current != null;
    }
}

