/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model.reflective;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.BasicMethodInfo;
import proguard.classfile.MethodDescriptor;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.Model;
import proguard.evaluation.value.object.model.reflective.ModeledConstructor;
import proguard.evaluation.value.object.model.reflective.ModeledInstanceMethod;
import proguard.evaluation.value.object.model.reflective.ModeledStaticMethod;
import proguard.evaluation.value.object.model.reflective.ReflectiveModel;
import proguard.util.PartialEvaluatorUtils;

public final class ModelHelper {
    private static final Map<Class<? extends Model>, Map<BasicMethodInfo, Method>> INSTANCE_METHOD_HANDLERS_CACHE = new HashMap<Class<? extends Model>, Map<BasicMethodInfo, Method>>();
    private static final Map<Class<? extends Model>, Map<BasicMethodInfo, Method>> CONSTRUCTOR_HANDLERS_CACHE = new HashMap<Class<? extends Model>, Map<BasicMethodInfo, Method>>();
    private static final Map<Class<? extends Model>, Map<BasicMethodInfo, Method>> STATIC_HANDLERS_CACHE = new HashMap<Class<? extends Model>, Map<BasicMethodInfo, Method>>();
    private static final Map<Class<? extends Model>, ReflectiveModel<?>> DUMMY_OBJECTS = new HashMap();

    private ModelHelper() {
    }

    public static <T extends ReflectiveModel<T>> Map<BasicMethodInfo, Method> getConstructorHandlers(Class<T> modelClass) {
        return CONSTRUCTOR_HANDLERS_CACHE.computeIfAbsent(modelClass, cls -> Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(ModeledConstructor.class)).map(ModelHelper::checkModeledMethodNotPublic).collect(Collectors.toMap(method -> ModelHelper.createConstructorSignature(method.getAnnotation(ModeledConstructor.class)), method -> method)));
    }

    private static BasicMethodInfo createConstructorSignature(ModeledConstructor annotation) {
        return new BasicMethodInfo("<init>", new MethodDescriptor(annotation.descriptor()));
    }

    public static <T extends ReflectiveModel<T>> Map<BasicMethodInfo, Method> getInstanceMethodHandlers(Class<T> modelClass) {
        return INSTANCE_METHOD_HANDLERS_CACHE.computeIfAbsent(modelClass, cls -> Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(ModeledInstanceMethod.class)).map(ModelHelper::checkModeledMethodNotPublic).collect(Collectors.toMap(method -> ModelHelper.createInstanceMethodSignature(method.getAnnotation(ModeledInstanceMethod.class)), method -> method)));
    }

    private static BasicMethodInfo createInstanceMethodSignature(ModeledInstanceMethod annotation) {
        return new BasicMethodInfo(annotation.name(), new MethodDescriptor(annotation.descriptor()));
    }

    public static <T extends ReflectiveModel<T>> Map<BasicMethodInfo, Method> getStaticMethodHandlers(Class<T> modelClass) {
        return STATIC_HANDLERS_CACHE.computeIfAbsent(modelClass, cls -> Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(ModeledStaticMethod.class)).map(ModelHelper::checkModeledMethodNotPublic).collect(Collectors.toMap(method -> ModelHelper.createStaticMethodSignature(method.getAnnotation(ModeledStaticMethod.class)), method -> method)));
    }

    private static BasicMethodInfo createStaticMethodSignature(ModeledStaticMethod annotation) {
        return new BasicMethodInfo(annotation.name(), new MethodDescriptor(annotation.descriptor()));
    }

    private static Method checkModeledMethodNotPublic(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Modeling methods should not be public, but '%s' is", method));
        }
        return method;
    }

    public static <T extends ReflectiveModel<T>> T getDummyObject(Class<T> modelClass) {
        return (T)DUMMY_OBJECTS.computeIfAbsent(modelClass, cls -> {
            try {
                Constructor constructor = modelClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ReflectiveModel)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("The model " + modelClass.getName() + " does not implement the mandatory no-argument constructor.");
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The model " + modelClass.getName() + " does not correctly implement the mandatory no-argument constructor.", e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to instantiate the " + modelClass.getName() + " using the mandatory no-argument constructor.", e);
            }
        });
    }

    public static <T extends ReflectiveModel<T>> Collection<BasicMethodInfo> getSupportedMethods(Class<T> modelClass) {
        return Stream.of(ModelHelper.getStaticMethodHandlers(modelClass), ModelHelper.getConstructorHandlers(modelClass), ModelHelper.getInstanceMethodHandlers(modelClass)).flatMap(methodInfoMethodMap -> methodInfoMethodMap.keySet().stream()).collect(Collectors.toList());
    }

    public static boolean allParticular(List<Value> values) {
        return values.stream().allMatch(Value::isParticular);
    }

    public static boolean areInstanceAndParametersParticular(MethodExecutionInfo executionInfo) {
        ArrayList<Value> allArguemnts = new ArrayList<Value>();
        if (executionInfo.isInstanceMethod()) {
            allArguemnts.add(executionInfo.getInstanceNonStatic());
        }
        allArguemnts.addAll(executionInfo.getParameters());
        return ModelHelper.allParticular(allArguemnts);
    }

    public static MethodResult executeViaHandler(MethodExecutionContext context, Map<BasicMethodInfo, Method> handlers, Model instance) {
        MethodExecutionInfo executionInfo = context.executionInfo;
        BasicMethodInfo methodInfo = new BasicMethodInfo(executionInfo.getSignature());
        if (!handlers.containsKey(methodInfo)) {
            throw new UnsupportedOperationException(String.format("Unsupported method %s", executionInfo));
        }
        try {
            ArrayList<Object> modeledMethodParameters = new ArrayList<Object>();
            modeledMethodParameters.add(context);
            modeledMethodParameters.addAll(executionInfo.getParameters());
            Method method = handlers.get(methodInfo);
            method.setAccessible(true);
            return (MethodResult)method.invoke((Object)instance, modeledMethodParameters.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Exception while trying execute method handler", e);
        }
    }

    public static MethodResult createDefaultConstructorResult(MethodExecutionContext context, Model concreteValue) {
        ValueCalculator valueCalculator = context.getValueCalculator();
        MethodExecutionInfo executionInfo = context.getExecutionInfo();
        ReferenceValue constructedValue = valueCalculator.apply(executionInfo.getTargetType(), executionInfo.getTargetClass(), true, concreteValue, false, executionInfo.getSpecificInstance().id).referenceValue();
        return new MethodResult.Builder().setUpdatedInstance(constructedValue).build();
    }

    public static MethodResult createDefaultReturnResult(MethodExecutionContext context, @Nullable Object concreteValue) {
        ValueCalculator valueCalculator = context.getValueCalculator();
        MethodExecutionInfo executionInfo = context.getExecutionInfo();
        Value returnValue = valueCalculator.apply(executionInfo.getReturnType(), executionInfo.getReturnClass(), true, concreteValue, false, null);
        return new MethodResult.Builder().setReturnValue(returnValue).build();
    }

    public static MethodResult createDefaultBuilderResult(MethodExecutionContext context, Object newInstance) {
        ValueCalculator valueCalculator = context.getValueCalculator();
        MethodExecutionInfo executionInfo = context.getExecutionInfo();
        ReferenceValue instance = executionInfo.getInstanceNonStatic();
        Object id = instance.isSpecific() ? PartialEvaluatorUtils.getIdFromSpecificReferenceValue(instance) : null;
        Value returnValue = valueCalculator.apply(executionInfo.getReturnType(), executionInfo.getReturnClass(), true, newInstance, false, id);
        return new MethodResult.Builder().setReturnValue(returnValue).setUpdatedInstance(returnValue.referenceValue()).build();
    }

    public static MethodResult createUnknownBuilderResult(MethodExecutionContext context) {
        ValueCalculator valueCalculator = context.getValueCalculator();
        MethodExecutionInfo executionInfo = context.getExecutionInfo();
        if (!executionInfo.getInstanceNonStatic().isSpecific()) {
            return MethodResult.invalidResult();
        }
        Value returnValue = valueCalculator.apply(executionInfo.getReturnType(), executionInfo.getReturnClass(), false, null, false, ((MethodExecutionContext)context).executionInfo.getSpecificInstance().id);
        return new MethodResult.Builder().setReturnValue(returnValue).setUpdatedInstance(returnValue.referenceValue()).build();
    }

    public static final class MethodExecutionContext {
        private final MethodExecutionInfo executionInfo;
        private final ValueCalculator valueCalculator;

        public MethodExecutionContext(MethodExecutionInfo executionInfo, ValueCalculator valueCalculator) {
            this.executionInfo = executionInfo;
            this.valueCalculator = valueCalculator;
        }

        public MethodExecutionInfo getExecutionInfo() {
            return this.executionInfo;
        }

        public ValueCalculator getValueCalculator() {
            return this.valueCalculator;
        }

        public String toString() {
            return "MethodExecutionContext[executionInfo=" + this.executionInfo + ", valueCalculator=" + this.valueCalculator + ']';
        }
    }
}

