/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.util.ArrayUtil;

public class MultiConstantVisitor
implements ConstantVisitor {
    private ConstantVisitor[] constantVisitors;
    private int constantVisitorCount;

    public MultiConstantVisitor() {
        this.constantVisitors = new ConstantVisitor[16];
    }

    public MultiConstantVisitor(ConstantVisitor ... constantVisitors) {
        this.constantVisitors = constantVisitors;
        this.constantVisitorCount = this.constantVisitors.length;
    }

    public void addClassVisitor(ConstantVisitor constantVisitor) {
        this.constantVisitors = ArrayUtil.add(this.constantVisitors, this.constantVisitorCount++, constantVisitor);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        for (int index = 0; index < this.constantVisitorCount; ++index) {
            constant.accept(clazz, this.constantVisitors[index]);
        }
    }
}

