/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.inject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.util.inject.CodeInjector;
import proguard.classfile.util.inject.argument.InjectedArgument;
import proguard.classfile.util.inject.argument.LocalVariable;
import proguard.classfile.util.inject.location.InjectStrategy;

public class AccumulatedCodeInjector
extends CodeInjector {
    private final List<CodeInjector> injectors = new ArrayList<CodeInjector>();
    private CodeInjector currentInjector = new CodeInjector();

    @Override
    public CodeInjector injectInvokeStatic(Clazz clazz, Method method) {
        return this.injectInvokeStatic(clazz, method, new InjectedArgument[0]);
    }

    @Override
    public CodeInjector injectInvokeStatic(Clazz clazz, Method method, InjectedArgument ... arguments) {
        this.currentInjector.injectInvokeStatic(clazz, method, arguments);
        this.commitCurrentInjector();
        return this;
    }

    @Override
    public CodeInjector into(ProgramClass programClass, ProgramMethod programMethod) {
        this.currentInjector.into(programClass, programMethod);
        this.commitCurrentInjector();
        return this;
    }

    @Override
    public CodeInjector at(InjectStrategy injectStrategy) {
        this.currentInjector.at(injectStrategy);
        this.commitCurrentInjector();
        return this;
    }

    @Override
    public LocalVariable store() {
        return this.injectors.get(this.injectors.size() - 1).store();
    }

    @Override
    public void commit() {
        HashMap<CodeInjector.ClassMethodPair, List> targetToInjectorsMap = new HashMap<CodeInjector.ClassMethodPair, List>();
        this.injectors.forEach(injector -> injector.getTargets().forEach(target -> {
            List currentInjectors = targetToInjectorsMap.computeIfAbsent((CodeInjector.ClassMethodPair)target, k -> new ArrayList());
            currentInjectors.add(injector);
        }));
        final CodeAttributeEditor editor = new CodeAttributeEditor();
        targetToInjectorsMap.forEach((target, injectors) -> {
            Instruction[] instructions;
            int offset;
            InstructionSequenceBuilder code = new InstructionSequenceBuilder((ProgramClass)target.clazz);
            HashMap beforeInstructionInsertions = new HashMap();
            HashMap afterInstructionInsertions = new HashMap();
            injectors.forEach(injector -> {
                InjectStrategy.InjectLocation[] injectLocations;
                injector.getArguments().forEach(argument -> argument.pushToStack(code));
                code.invokestatic(injector.getContent().clazz, injector.getContent().method);
                LocalVariable resultLocalIndex = injector.getResultLocalIndex();
                if (resultLocalIndex != null) {
                    code.store(resultLocalIndex.getTargetVariableIndex(), resultLocalIndex.getInternalType());
                }
                for (InjectStrategy.InjectLocation location : injectLocations = injector.getInjectStrategy().getAllSuitableInjectionLocation((ProgramClass)target.clazz, (ProgramMethod)target.method)) {
                    if (location.shouldInjectBefore()) {
                        beforeInstructionInsertions.computeIfAbsent(location.getOffset(), i_ -> new LinkedList()).add(code.instructions());
                        continue;
                    }
                    afterInstructionInsertions.computeIfAbsent(location.getOffset(), i_ -> new LinkedList()).add(code.instructions());
                }
            });
            target.method.accept(target.clazz, new AllAttributeVisitor(new AttributeNameFilter("Code", new AttributeVisitor(){

                @Override
                public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
                    editor.reset(codeAttribute.u4codeLength);
                }
            })));
            for (Map.Entry entry : beforeInstructionInsertions.entrySet()) {
                offset = (Integer)entry.getKey();
                instructions = (Instruction[])((LinkedList)entry.getValue()).stream().flatMap(Arrays::stream).toArray(Instruction[]::new);
                editor.insertBeforeInstruction(offset, instructions);
            }
            for (Map.Entry entry : afterInstructionInsertions.entrySet()) {
                offset = (Integer)entry.getKey();
                instructions = (Instruction[])((LinkedList)entry.getValue()).stream().flatMap(Arrays::stream).toArray(Instruction[]::new);
                editor.insertAfterInstruction(offset, instructions);
            }
            target.method.accept(target.clazz, new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)editor)));
        });
    }

    private void commitCurrentInjector() {
        if (this.currentInjector.readyToCommit()) {
            this.injectors.add(this.currentInjector);
            this.currentInjector = new CodeInjector();
        }
    }
}

