/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.signature.ast.signature.ClassSignatureNode;
import proguard.classfile.attribute.signature.grammars.ClassSignatureGrammar;
import proguard.classfile.attribute.signature.grammars.MethodSignatureGrammar;
import proguard.classfile.attribute.signature.grammars.TypeSignatureGrammar;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.NamedAttributeDeleter;

public class InvalidSignatureCleaner
implements AttributeVisitor {
    public static boolean isValidClassSignature(Clazz clazz, ClassSignatureNode signature) {
        Set signatureInterfaces;
        if (!signature.getSuperclassSignature().getClassType().getClassname().equals(clazz.getSuperName())) {
            return false;
        }
        if (signature.getSuperinterfaceSignatures().size() != clazz.getInterfaceCount()) {
            return false;
        }
        Set clazzInterfaces = IntStream.range(0, clazz.getInterfaceCount()).mapToObj(clazz::getInterfaceName).collect(Collectors.toSet());
        return clazzInterfaces.containsAll(signatureInterfaces = signature.getSuperinterfaceSignatures().stream().map(sig -> sig.getClassType().getClassname()).collect(Collectors.toSet())) && signatureInterfaces.containsAll(clazzInterfaces);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute attribute) {
        ClassSignatureNode signature = ClassSignatureGrammar.parse(attribute.getSignature(clazz));
        if (signature == null || !InvalidSignatureCleaner.isValidClassSignature(clazz, signature)) {
            clazz.accept(new NamedAttributeDeleter("Signature"));
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, RecordComponentInfo recordComponentInfo, SignatureAttribute attribute) {
        if (recordComponentInfo.referencedField != null && TypeSignatureGrammar.parse(attribute.getSignature(clazz)) == null) {
            recordComponentInfo.attributesAccept(clazz, new NamedAttributeDeleter("Signature"));
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Member member, SignatureAttribute attribute) {
        boolean invalid = false;
        if (member instanceof Field) {
            invalid = TypeSignatureGrammar.parse(attribute.getSignature(clazz)) == null;
        } else if (member instanceof Method) {
            boolean bl = invalid = MethodSignatureGrammar.parse(attribute.getSignature(clazz)) == null;
        }
        if (invalid) {
            member.accept(clazz, new NamedAttributeDeleter("Signature"));
        }
    }
}

