/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.defaults.MergeJoinOperator;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.defaults.StaticPrecisionAdjustment;
import proguard.analysis.cpa.defaults.StopJoinOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransferRelation;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransformer;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;

public class JvmTaintCpa
extends SimpleCpa<JvmAbstractState<SetAbstractState<JvmTaintSource>>> {
    public JvmTaintCpa(Set<? extends JvmTaintSource> sources) {
        this(JvmTaintCpa.createSourcesMap(sources), Collections.emptyMap(), Collections.emptyMap(), NeverAbortOperator.INSTANCE);
    }

    public JvmTaintCpa(Map<Signature, Set<JvmTaintSource>> signaturesToSources, Map<MethodSignature, JvmTaintTransformer> taintTransformers, Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations, AbortOperator abortOperator) {
        super(new JvmTaintTransferRelation(signaturesToSources, taintTransformers, extraTaintPropagationLocations), new MergeJoinOperator(), new StopJoinOperator(), new StaticPrecisionAdjustment(), abortOperator);
    }

    public static Map<Signature, Set<JvmTaintSource>> createSourcesMap(Set<? extends JvmTaintSource> sources) {
        HashMap<Signature, Set<JvmTaintSource>> taintSourcesMap = new HashMap<Signature, Set<JvmTaintSource>>();
        sources.forEach(s -> taintSourcesMap.computeIfAbsent(s.signature, key -> new HashSet()).add(s));
        return taintSourcesMap;
    }
}

