/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import proguard.analysis.cpa.bam.BamLocationDependent;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmMemoryLocationAbstractState<ContentT extends AbstractState<ContentT>>
implements AbstractState<JvmMemoryLocationAbstractState<ContentT>>,
ProgramLocationDependent,
BamLocationDependent<ContentT> {
    private static final JvmMemoryLocationAbstractState<?> top = new JvmMemoryLocationAbstractState();
    private final BamLocationDependentJvmMemoryLocation<ContentT> locationDependentMemoryLocation;
    private final Set<BamLocationDependentJvmMemoryLocation<ContentT>> sourceLocations;
    private final LinkedList<StackEntry<ContentT>> callStack;

    private JvmMemoryLocationAbstractState() {
        this((BamLocationDependentJvmMemoryLocation)null, null, null);
    }

    public JvmMemoryLocationAbstractState(BamLocationDependentJvmMemoryLocation<ContentT> locationDependentMemoryLocation) {
        this(locationDependentMemoryLocation, new HashSet<BamLocationDependentJvmMemoryLocation<ContentT>>(), new LinkedList<StackEntry<ContentT>>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet) {
        this(memoryLocation, programLocation, sourceReachedSet, new HashSet<BamLocationDependentJvmMemoryLocation<ContentT>>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet, Set<BamLocationDependentJvmMemoryLocation<ContentT>> sourceLocations) {
        this(memoryLocation, programLocation, sourceReachedSet, sourceLocations, new LinkedList<StackEntry<ContentT>>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet, LinkedList<StackEntry<ContentT>> callStack) {
        this(memoryLocation, programLocation, sourceReachedSet, new HashSet<BamLocationDependentJvmMemoryLocation<ContentT>>(), callStack);
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet, Set<BamLocationDependentJvmMemoryLocation<ContentT>> sourceLocations, LinkedList<StackEntry<ContentT>> callStack) {
        this(new BamLocationDependentJvmMemoryLocation<ContentT>(memoryLocation, programLocation, sourceReachedSet), sourceLocations, callStack);
    }

    private JvmMemoryLocationAbstractState(BamLocationDependentJvmMemoryLocation<ContentT> locationDependentMemoryLocation, Set<BamLocationDependentJvmMemoryLocation<ContentT>> sourceLocations, LinkedList<StackEntry<ContentT>> callStack) {
        this.locationDependentMemoryLocation = locationDependentMemoryLocation;
        this.sourceLocations = sourceLocations;
        this.callStack = callStack;
    }

    public BamLocationDependentJvmMemoryLocation<ContentT> getLocationDependentMemoryLocation() {
        return this.locationDependentMemoryLocation;
    }

    public StackEntry<ContentT> peekCallStack() {
        return this.callStack.peek();
    }

    public boolean callStackContains(MethodSignature signature) {
        return this.callStack.stream().anyMatch(e -> signature.equals(e.signature));
    }

    public LinkedList<StackEntry<ContentT>> copyStack() {
        return new LinkedList<StackEntry<ContentT>>(this.callStack);
    }

    @Override
    public JvmMemoryLocationAbstractState<ContentT> join(JvmMemoryLocationAbstractState<ContentT> abstractState) {
        if (!this.locationDependentMemoryLocation.equals(abstractState.locationDependentMemoryLocation)) {
            return JvmMemoryLocationAbstractState.top();
        }
        AbstractState result = this.copy();
        ((JvmMemoryLocationAbstractState)result).sourceLocations.addAll(abstractState.sourceLocations);
        return this.equals(result) ? this : result;
    }

    @Override
    public boolean isLessOrEqual(JvmMemoryLocationAbstractState<ContentT> abstractState) {
        return abstractState == JvmMemoryLocationAbstractState.top() || this.locationDependentMemoryLocation.equals(abstractState.locationDependentMemoryLocation) && this.callStack.equals(abstractState.callStack) && abstractState.sourceLocations.containsAll(this.sourceLocations);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.locationDependentMemoryLocation.getProgramLocation();
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.locationDependentMemoryLocation.setProgramLocation(programLocation);
    }

    @Override
    public ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> getSourceReachedSet() {
        return this.locationDependentMemoryLocation.getSourceReachedSet();
    }

    @Override
    public void setSourceReachedSet(ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet) {
        this.locationDependentMemoryLocation.setSourceReachedSet(sourceReachedSet);
    }

    public void addSourceLocation(BamLocationDependentJvmMemoryLocation<ContentT> sourceLocation) {
        this.sourceLocations.add(sourceLocation);
    }

    public Set<BamLocationDependentJvmMemoryLocation<ContentT>> getSourceLocations() {
        return this.sourceLocations;
    }

    @Override
    public JvmMemoryLocationAbstractState<ContentT> copy() {
        return new JvmMemoryLocationAbstractState<ContentT>(this.locationDependentMemoryLocation.copy(), new HashSet<BamLocationDependentJvmMemoryLocation<ContentT>>(this.sourceLocations), this.callStack);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmMemoryLocationAbstractState)) {
            return false;
        }
        JvmMemoryLocationAbstractState other = (JvmMemoryLocationAbstractState)obj;
        return Objects.equals(this.locationDependentMemoryLocation, other.locationDependentMemoryLocation) && Objects.equals(this.callStack, other.callStack) && Objects.equals(this.sourceLocations, other.sourceLocations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locationDependentMemoryLocation);
    }

    public static <ContentT extends AbstractState<ContentT>> JvmMemoryLocationAbstractState<ContentT> top() {
        JvmMemoryLocationAbstractState<?> topParametrized = top;
        return topParametrized;
    }

    public static class StackEntry<ContentT extends AbstractState<ContentT>> {
        public final MethodSignature signature;
        public final ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedSet;
        public final JvmAbstractState<ContentT> callerState;

        public StackEntry(MethodSignature signature, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedSet, JvmAbstractState<ContentT> callerState) {
            this.signature = signature;
            this.reachedSet = reachedSet;
            this.callerState = callerState;
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.reachedSet, this.callerState);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StackEntry)) {
                return false;
            }
            StackEntry other = (StackEntry)obj;
            return Objects.equals(this.reachedSet, other.reachedSet) && Objects.equals(this.signature, other.signature) && Objects.equals(this.callerState, other.callerState);
        }
    }
}

