/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.algorithms;

import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.defaults.PrecisionAdjustmentResult;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.interfaces.Waitlist;

public class CpaAlgorithm<StateT extends AbstractState<StateT>> {
    private static final Logger log = LogManager.getLogger(CpaAlgorithm.class);
    private final ConfigurableProgramAnalysis<StateT> cpa;

    public CpaAlgorithm(ConfigurableProgramAnalysis<StateT> cpa) {
        this.cpa = cpa;
    }

    public void run(ReachedSet<StateT> reachedSet, Waitlist<StateT> waitlist) {
        while (!waitlist.isEmpty()) {
            StateT currentState = waitlist.pop();
            try {
                if (this.cpa.getAbortOperator().abort((AbstractState<?>)currentState)) {
                    return;
                }
                Precision currentPrecision = currentState.getPrecision();
                PrecisionAdjustmentResult<StateT> precisionAdjustmentResult = this.cpa.getPrecisionAdjustment().prec(currentState, currentPrecision, reachedSet.getReached((AbstractState)currentState));
                currentState = precisionAdjustmentResult.getAbstractState();
                currentPrecision = currentState.getPrecision();
                for (AbstractState successorState : this.cpa.getTransferRelation().generateAbstractSuccessors(currentState, currentPrecision)) {
                    LinkedHashSet<AbstractState> gen = new LinkedHashSet<AbstractState>();
                    LinkedHashSet<AbstractState> kill = new LinkedHashSet<AbstractState>();
                    for (AbstractState reachedState : reachedSet.getReached(successorState)) {
                        AbstractState mergedState = this.cpa.getMergeOperator().merge(successorState, reachedState, successorState.getPrecision());
                        if (mergedState.equals(reachedState)) continue;
                        gen.add(mergedState);
                        kill.add(reachedState);
                    }
                    reachedSet.addAll(gen);
                    reachedSet.removeAll(kill);
                    waitlist.addAll(gen);
                    waitlist.removeAll(kill);
                    if (this.cpa.getStopOperator().stop(successorState, reachedSet.getReached(successorState), successorState.getPrecision())) continue;
                    waitlist.add(successorState);
                    reachedSet.add(successorState);
                }
            }
            catch (Exception exception) {
                log.error("CPA run stopped for the following error: ", (Throwable)exception);
                waitlist.clear();
            }
        }
    }
}

