/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableCleaner;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;

public class VariableSizeUpdater
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private VariableCleaner variableCleaner = new VariableCleaner();

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2maxLocals = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        codeAttribute.instructionsAccept(clazz, method, this);
        this.variableCleaner.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableSize = variableInstruction.variableIndex + 1;
        if (variableInstruction.stackPopCount(clazz) == 2 || variableInstruction.stackPushCount(clazz) == 2) {
            ++variableSize;
        }
        if (codeAttribute.u2maxLocals < variableSize) {
            codeAttribute.u2maxLocals = variableSize;
        }
    }
}

