/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.PackageSpecifierNode;
import proguard.classfile.attribute.signature.ast.signature.SimpleClassTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class ClassTypeSignatureNode {
    @NotNull
    private PackageSpecifierNode packageSpecifier;
    @NotNull
    private SimpleClassTypeSignatureNode name;
    @NotNull
    private List<SimpleClassTypeSignatureNode> suffix;

    public ClassTypeSignatureNode(@NotNull PackageSpecifierNode packageSpecifier, @NotNull SimpleClassTypeSignatureNode name, @NotNull List<SimpleClassTypeSignatureNode> suffix) {
        if (packageSpecifier == null || name == null || suffix == null) {
            throw new ASTStructureException("Arguments must not be null.");
        }
        this.packageSpecifier = packageSpecifier;
        this.name = name;
        this.suffix = suffix;
    }

    @NotNull
    public PackageSpecifierNode getPackageSpecifier() {
        return this.packageSpecifier;
    }

    public void setPackageSpecifier(@NotNull PackageSpecifierNode packageSpecifier) {
        if (packageSpecifier == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.packageSpecifier = packageSpecifier;
    }

    @NotNull
    public SimpleClassTypeSignatureNode getName() {
        return this.name;
    }

    public void setName(@NotNull SimpleClassTypeSignatureNode name) {
        if (name == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.name = name;
    }

    @NotNull
    public List<SimpleClassTypeSignatureNode> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(@NotNull List<SimpleClassTypeSignatureNode> suffix) {
        if (suffix == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.suffix = suffix;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String getClassname() {
        String suffixString = "";
        if (!this.suffix.isEmpty()) {
            suffixString = "$" + this.suffix.stream().map(SimpleClassTypeSignatureNode::getIdentifier).collect(Collectors.joining("$"));
        }
        return this.packageSpecifier.toString() + this.name.getIdentifier() + suffixString;
    }

    @NotNull
    public List<String> getClassNamesIncludingParentClasses() {
        ArrayList<String> result = new ArrayList<String>(this.suffix.size() + 1);
        result.add(this.packageSpecifier + this.name.getIdentifier());
        for (int index = 1; index < this.suffix.size() + 1; ++index) {
            result.add(this.packageSpecifier + this.name.getIdentifier() + "$" + this.suffix.stream().limit(index).map(SimpleClassTypeSignatureNode::getIdentifier).collect(Collectors.joining("$")));
        }
        return result;
    }

    @NotNull
    public String toString() {
        @NotNull String suffixString = "";
        if (!this.suffix.isEmpty()) {
            suffixString = "." + this.suffix.stream().map(SimpleClassTypeSignatureNode::toString).collect(Collectors.joining("."));
        }
        return "L" + this.packageSpecifier + this.name + suffixString + ";";
    }
}

