/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.Stack;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.Variables;
import proguard.evaluation.util.PartialEvaluatorStateTracker;
import proguard.evaluation.util.jsonprinter.BranchTargetRecord;
import proguard.evaluation.util.jsonprinter.CodeAttributeRecord;
import proguard.evaluation.util.jsonprinter.ErrorRecord;
import proguard.evaluation.util.jsonprinter.ExceptionHandlerRecord;
import proguard.evaluation.util.jsonprinter.InstructionBlockEvaluationRecord;
import proguard.evaluation.util.jsonprinter.InstructionEvaluationRecord;
import proguard.evaluation.util.jsonprinter.InstructionRecord;
import proguard.evaluation.util.jsonprinter.JsonSerializable;
import proguard.evaluation.util.jsonprinter.StateTracker;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;

public class JsonPrinter
implements PartialEvaluatorStateTracker {
    private final StateTracker stateTracker = new StateTracker();
    private final List<List<InstructionBlockEvaluationRecord>> subRoutineStack = new ArrayList<List<InstructionBlockEvaluationRecord>>();
    private final Clazz clazzFilter;
    private final Method methodFilter;

    public JsonPrinter() {
        this(null, null);
    }

    public JsonPrinter(Clazz clazzFilter) {
        this(clazzFilter, null);
    }

    public JsonPrinter(Clazz clazzFilter, Method methodFilter) {
        this.clazzFilter = clazzFilter;
        this.methodFilter = methodFilter;
    }

    static void writeJsonDebug(Clazz clazz, Method method, String fileName) {
        JsonPrinter.writeJsonDebug(clazz, method, fileName, PartialEvaluator.Builder.create());
    }

    static void writeJsonDebug(Clazz clazz, Method method, String fileName, PartialEvaluator.Builder builder) {
        JsonPrinter printer = new JsonPrinter();
        PartialEvaluator pe = builder.setStateTracker(printer).build();
        method.accept(clazz, new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)pe)));
        printer.writeState(fileName);
    }

    public String getJson() {
        return this.stateTracker.toJson();
    }

    public void printState() {
        System.out.println(this.getJson());
    }

    public void writeState(String fileName) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(this.getJson());
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<InstructionBlockEvaluationRecord> curBlockEvalList() {
        return this.subRoutineStack.get(this.subRoutineStack.size() - 1);
    }

    private InstructionBlockEvaluationRecord lastBlockEval() {
        List<InstructionBlockEvaluationRecord> curList = this.curBlockEvalList();
        if (this.curBlockEvalList().isEmpty()) {
            return null;
        }
        return curList.get(curList.size() - 1);
    }

    private List<String> formatValueList(Variables variables) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < variables.size(); ++i) {
            Value val = variables.getValue(i);
            res.add(val == null ? "empty" : val.toString());
        }
        return res;
    }

    private List<String> formatValueList(Stack stack) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < stack.size(); ++i) {
            Value val = stack.getBottom(i);
            res.add(val == null ? "empty" : val.toString());
        }
        return res;
    }

    private boolean shouldSkip(Clazz clazz, Method method) {
        return this.clazzFilter != null && this.clazzFilter != clazz || this.methodFilter != null && this.methodFilter != method;
    }

    static StringBuilder toJson(@NotNull String key, Function<StringBuilder, StringBuilder> callback, StringBuilder builder) {
        builder.append("\"").append(key).append("\":");
        return callback.apply(builder);
    }

    static StringBuilder toJson(@NotNull String key, @NotNull String value, StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> build.append("\"").append(value).append("\""), builder);
    }

    static StringBuilder toJson(@NotNull String key, int value, StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> build.append(value), builder);
    }

    static StringBuilder toJson(@NotNull String key, boolean value, StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> build.append(value), builder);
    }

    static <T extends JsonSerializable> void serializeJsonSerializable(@NotNull String key, T value, StringBuilder builder) {
        JsonPrinter.toJson(key, value::toJson, builder);
    }

    @NotNull
    static <T extends JsonSerializable> StringBuilder listToJson(@NotNull String key, @NotNull List<T> formattableList, @NotNull StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> {
            build.append("[");
            if (!formattableList.isEmpty()) {
                ((JsonSerializable)formattableList.get(0)).toJson((StringBuilder)build);
            }
            for (int index = 1; index < formattableList.size(); ++index) {
                build.append(",");
                ((JsonSerializable)formattableList.get(index)).toJson((StringBuilder)build);
            }
            build.append("]");
            return build;
        }, builder);
    }

    @NotNull
    static StringBuilder stringListToJson(@NotNull String key, @NotNull List<String> formattableList, @NotNull StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> {
            build.append("[");
            if (!formattableList.isEmpty()) {
                build.append("\"").append((String)formattableList.get(0)).append("\"");
            }
            for (int index = 1; index < formattableList.size(); ++index) {
                build.append(",\"");
                build.append((String)formattableList.get(index)).append("\"");
            }
            build.append("]");
            return build;
        }, builder);
    }

    @NotNull
    static StringBuilder intListToJson(@NotNull String key, @NotNull List<Integer> formattableList, @NotNull StringBuilder builder) {
        return JsonPrinter.toJson(key, (StringBuilder build) -> {
            build.append("[");
            if (!formattableList.isEmpty()) {
                build.append(formattableList.get(0));
            }
            for (int index = 1; index < formattableList.size(); ++index) {
                build.append(",");
                build.append(formattableList.get(index));
            }
            build.append("]");
            return build;
        }, builder);
    }

    @Override
    public void startCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, Variables parameters) {
        Instruction instruction;
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        ArrayList<InstructionRecord> instructions = new ArrayList<InstructionRecord>();
        byte[] code = codeAttribute.code;
        for (int offset = 0; offset < codeAttribute.u4codeLength; offset += instruction.length(offset)) {
            instruction = InstructionFactory.create(code, offset);
            instructions.add(new InstructionRecord(offset, instruction.toString()));
        }
        CodeAttributeRecord attributeRecord = new CodeAttributeRecord(clazz.getName(), method.getName(clazz) + method.getDescriptor(clazz), this.formatValueList(parameters), instructions);
        this.subRoutineStack.clear();
        this.subRoutineStack.add(attributeRecord.getBlockEvaluations());
        this.stateTracker.getCodeAttributes().add(attributeRecord);
    }

    @Override
    public void registerException(Clazz clazz, Method method, CodeAttribute codeAttribute, PartialEvaluator evaluator, Throwable cause) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        this.stateTracker.getLastCodeAttribute().setError(new ErrorRecord(this.lastBlockEval().getLastInstructionEvaluation().getInstructionOffset(), cause.getMessage()));
    }

    @Override
    public void registerExceptionHandler(Clazz clazz, Method method, int startPC, int endPC, ExceptionInfo info) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        ClassConstant constant = (ClassConstant)((ProgramClass)clazz).getConstant(info.u2catchType);
        ExceptionHandlerRecord exceptionHandlerInfo = new ExceptionHandlerRecord(startPC, endPC, info.u2handlerPC, constant == null ? "java/lang/Throwable" : constant.getName(clazz));
        this.curBlockEvalList().add(new InstructionBlockEvaluationRecord(null, null, info.u2handlerPC, exceptionHandlerInfo, new ArrayList<BranchTargetRecord>()));
    }

    @Override
    public void evaluationResults(Clazz clazz, Method method, CodeAttribute codeAttribute, PartialEvaluator evaluator) {
        Iterator<InstructionRecord> iterator = this.stateTracker.getLastCodeAttribute().getInstructions().iterator();
        while (iterator.hasNext()) {
            InstructionOffsetValue origins;
            InstructionRecord instruction;
            TracedVariables variablesBefore = evaluator.getVariablesBefore((instruction = iterator.next()).getOffset());
            instruction.setFinalVariablesBefore(variablesBefore == null ? null : this.formatValueList(variablesBefore));
            TracedStack stackBefore = evaluator.getStackBefore(instruction.getOffset());
            instruction.setFinalStackBefore(stackBefore == null ? null : this.formatValueList(stackBefore));
            InstructionOffsetValue targets = evaluator.branchTargets(instruction.getOffset());
            if (targets != null) {
                instruction.setFinalTargetInstructions(new ArrayList<Integer>());
                for (int index = 0; index < targets.instructionOffsetCount(); ++index) {
                    instruction.getFinalTargetInstructions().add(targets.instructionOffset(index));
                }
            }
            if ((origins = evaluator.branchOrigins(instruction.getOffset())) == null) continue;
            instruction.setFinalOriginInstructions(new ArrayList<Integer>());
            for (int index = 0; index < origins.instructionOffsetCount(); ++index) {
                instruction.getFinalOriginInstructions().add(origins.instructionOffset(index));
            }
        }
    }

    @Override
    public void startInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables startVariables, TracedStack startStack, int startOffset) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        InstructionBlockEvaluationRecord lastBlock = this.lastBlockEval();
        if (lastBlock != null && lastBlock.getExceptionHandlerInfo() != null && lastBlock.getEvaluations().isEmpty()) {
            lastBlock.setStartVariables(this.formatValueList(startVariables));
            lastBlock.setStartStack(this.formatValueList(startStack));
        } else {
            ExceptionHandlerRecord exceptionHandlerInfo = null;
            ArrayList<BranchTargetRecord> branchStack = new ArrayList();
            if (lastBlock != null) {
                InstructionEvaluationRecord lastInstruction = lastBlock.getLastInstructionEvaluation();
                branchStack = lastInstruction != null && lastInstruction.getUpdatedEvaluationStack() != null ? new ArrayList<BranchTargetRecord>(lastInstruction.getUpdatedEvaluationStack()) : new ArrayList<BranchTargetRecord>(lastBlock.getBranchEvaluationStack());
                exceptionHandlerInfo = lastBlock.getExceptionHandlerInfo();
            }
            if (!branchStack.isEmpty()) {
                BranchTargetRecord stackHead = (BranchTargetRecord)branchStack.remove(branchStack.size() - 1);
                assert (stackHead.getStartOffset() == startOffset);
            }
            this.curBlockEvalList().add(new InstructionBlockEvaluationRecord(this.formatValueList(startVariables), this.formatValueList(startStack), startOffset, exceptionHandlerInfo, branchStack));
        }
    }

    @Override
    public void skipInstructionBlock(Clazz clazz, Method method, int instructionOffset, Instruction instruction, TracedVariables variablesBefore, TracedStack stackBefore, int evaluationCount) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        this.lastBlockEval().getEvaluations().add(new InstructionEvaluationRecord(true, false, evaluationCount, instruction.toString(), instructionOffset, this.formatValueList(variablesBefore), this.formatValueList(stackBefore)));
    }

    @Override
    public void generalizeInstructionBlock(Clazz clazz, Method method, int instructionOffset, Instruction instruction, TracedVariables variablesBefore, TracedStack stackBefore, int evaluationCount) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        this.lastBlockEval().getEvaluations().add(new InstructionEvaluationRecord(false, true, evaluationCount, instruction.toString(), instructionOffset, this.formatValueList(variablesBefore), this.formatValueList(stackBefore)));
    }

    @Override
    public void startInstructionEvaluation(Clazz clazz, Method method, int instructionOffset, Instruction instruction, TracedVariables variablesBefore, TracedStack stackBefore, int evaluationCount) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        InstructionEvaluationRecord prevEval = this.lastBlockEval().getLastInstructionEvaluation();
        if (prevEval == null || prevEval.getInstructionOffset() != instructionOffset || prevEval.getEvaluationCount() != evaluationCount) {
            this.lastBlockEval().getEvaluations().add(new InstructionEvaluationRecord(false, false, evaluationCount, instruction.toString(), instructionOffset, this.formatValueList(variablesBefore), this.formatValueList(stackBefore)));
        }
    }

    @Override
    public void registerAlternativeBranch(Clazz clazz, Method method, int fromInstructionOffset, Instruction fromInstruction, TracedVariables variablesAfter, TracedStack stackAfter, int branchIndex, int branchTargetCount, int offset) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        InstructionBlockEvaluationRecord lastBlock = this.lastBlockEval();
        InstructionEvaluationRecord lastInstruction = lastBlock.getLastInstructionEvaluation();
        if (lastInstruction.getUpdatedEvaluationStack() == null) {
            lastInstruction.setUpdatedEvaluationStack(new ArrayList<BranchTargetRecord>(lastBlock.getBranchEvaluationStack()));
        }
        lastInstruction.getUpdatedEvaluationStack().add(new BranchTargetRecord(this.formatValueList(variablesAfter), this.formatValueList(stackAfter), offset));
    }

    @Override
    public void startSubroutine(Clazz clazz, Method method, TracedVariables startVariables, TracedStack startStack, int subroutineStart, int subroutineEnd) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        InstructionEvaluationRecord lastInstruction = this.lastBlockEval().getLastInstructionEvaluation();
        lastInstruction.setJsrBlockEvaluations(new ArrayList<InstructionBlockEvaluationRecord>());
        this.subRoutineStack.add(lastInstruction.getJsrBlockEvaluations());
    }

    @Override
    public void registerSubroutineReturn(Clazz clazz, Method method, int returnOffset, TracedVariables returnVariables, TracedStack returnStack) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        List<InstructionBlockEvaluationRecord> blockList = this.subRoutineStack.get(this.subRoutineStack.size() - 2);
        InstructionBlockEvaluationRecord lastBlock = blockList.get(blockList.size() - 1);
        InstructionEvaluationRecord instruction = lastBlock.getLastInstructionEvaluation();
        assert (instruction.getInstruction().startsWith("jsr"));
        instruction.setUpdatedEvaluationStack(new ArrayList<BranchTargetRecord>(lastBlock.getBranchEvaluationStack()));
        instruction.getUpdatedEvaluationStack().add(new BranchTargetRecord(this.formatValueList(returnVariables), this.formatValueList(returnStack), returnOffset));
    }

    @Override
    public void endSubroutine(Clazz clazz, Method method, TracedVariables variablesAfter, TracedStack stackAfter, int subroutineStart, int subroutineEnd) {
        if (this.shouldSkip(clazz, method)) {
            return;
        }
        this.subRoutineStack.remove(this.subRoutineStack.size() - 1);
    }
}

