/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Signature;

public class JvmTaintSource
extends TaintSource {
    public final Optional<Predicate<Call>> callMatcher;

    public JvmTaintSource(Signature signature, Predicate<Call> callMatcher, boolean taintsThis, boolean taintsReturn, Set<Integer> taintsArgs, Set<String> taintsGlobals) {
        this(signature, Optional.of(callMatcher), taintsThis, taintsReturn, taintsArgs, taintsGlobals);
    }

    public JvmTaintSource(Signature signature, boolean taintsThis, boolean taintsReturn, Set<Integer> taintsArgs, Set<String> taintsGlobals) {
        this(signature, Optional.empty(), taintsThis, taintsReturn, taintsArgs, taintsGlobals);
    }

    public JvmTaintSource(Signature signature, Optional<Predicate<Call>> callMatcher, boolean taintsThis, boolean taintsReturn, Set<Integer> taintsArgs, Set<String> taintsGlobals) {
        super(signature, taintsThis, taintsReturn, taintsArgs, taintsGlobals);
        this.callMatcher = callMatcher;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmTaintSource)) {
            return false;
        }
        JvmTaintSource other = (JvmTaintSource)obj;
        return Objects.equals(this.signature, other.signature) && Objects.equals(this.callMatcher, other.callMatcher) && this.taintsThis == other.taintsThis && this.taintsReturn == other.taintsReturn && Objects.equals(this.taintsArgs, other.taintsArgs) && Objects.equals(this.taintsGlobals, other.taintsGlobals);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.signature, this.callMatcher, this.taintsThis, this.taintsReturn, this.taintsArgs, this.taintsGlobals);
    }

    @Override
    public String toString() {
        return this.callMatcher.map(p -> super.toString() + " filtered by " + p).orElse(super.toString());
    }
}

