/*
 * Decompiled with CFR 0.152.
 */
package com.grookage.iosave.bundle;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.grookage.iosave.as.repository.ASRequestRepository;
import com.grookage.iosave.bundle.Inbound;
import com.grookage.iosave.core.entities.RequestEntity;
import com.grookage.iosave.core.entities.RequestHeaders;
import com.grookage.iosave.core.entities.RequestStatus;
import com.grookage.iosave.core.exception.IOSaveException;
import com.grookage.iosave.core.repository.RequestRepository;
import com.grookage.iosave.core.services.RequestReceiverService;
import com.grookage.iosave.core.utils.RequestManager;
import com.grookage.iosave.core.utils.RequestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Inbound
public class InboundMessageFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(InboundMessageFilter.class);
    private final RequestReceiverService requestReceiverService;
    private final ObjectMapper mapper;
    @Context
    private ResourceInfo resourceInfo;

    public InboundMessageFilter(ASRequestRepository messageRepository, ObjectMapper mapper) {
        this.requestReceiverService = new RequestReceiverService((RequestRepository)messageRepository);
        this.mapper = mapper;
    }

    private static String readFromRequest(ContainerRequestContext request) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = request.getEntityStream();
        byte[] requestEntity = new byte[]{};
        try {
            if (in.available() > 0) {
                ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
                requestEntity = out.toByteArray();
                request.setEntityStream((InputStream)new ByteArrayInputStream(requestEntity));
            }
            return new String(requestEntity);
        }
        catch (IOException ex) {
            throw new ContainerException((Throwable)ex);
        }
    }

    private String getTraceId(ContainerRequestContext requestContext, Inbound inbound) {
        if (null == inbound.traceId()) {
            return "TXN-" + UUID.randomUUID();
        }
        return requestContext.getHeaderString(inbound.traceId());
    }

    private String getRequestId(ContainerRequestContext requestContext, Inbound inbound) {
        if (null == inbound.requestId()) {
            return null;
        }
        return requestContext.getHeaderString(inbound.requestId());
    }

    private boolean mandateRequestId(Inbound inbound) {
        return inbound.mandateRequestId();
    }

    private boolean shouldSaveBody(Inbound inbound) {
        return inbound.saveRequestBody();
    }

    private Optional<Inbound> getInbound() {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        return null == resourceMethod ? Optional.empty() : Optional.ofNullable(resourceMethod.getAnnotation(Inbound.class));
    }

    private void handleProcessedMessage(RequestEntity message) {
        HashMap responseHeaders = new HashMap();
        if (message.getResponseHeaders() != null) {
            try {
                responseHeaders = (HashMap)this.mapper.readValue(message.getResponseHeaders(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (Exception e) {
                log.error("Unable to parse response headers with value {}.", (Object)message.getResponseHeaders());
            }
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.fromStatusCode((int)message.getResponseStatus())).entity((Object)message.getResponseBody());
        responseHeaders.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)builder).header(arg_0, arg_1));
        throw IOSaveException.error((IOSaveException.ErrorCode)IOSaveException.ErrorCode.MESSAGE_ALREADY_PROCESSED);
    }

    private String readFromResponse(ContainerResponseContext response) {
        Object entity = response.getEntity();
        try {
            return this.mapper.writeValueAsString(entity);
        }
        catch (IOSaveException e) {
            return entity.toString();
        }
    }

    private String getRequestBody(ContainerRequestContext context, RequestEntity requestEntity) {
        return Objects.isNull(requestEntity) ? InboundMessageFilter.readFromRequest(context) : requestEntity.getRequestBody();
    }

    public void filter(ContainerRequestContext requestContext) {
        Inbound inbound = this.getInbound().orElse(null);
        if (null == inbound) {
            return;
        }
        boolean saveRequestBody = this.shouldSaveBody(inbound);
        boolean mandateRequestId = this.mandateRequestId(inbound);
        String requestId = this.getRequestId(requestContext, inbound);
        if (mandateRequestId && null == requestId) {
            throw IOSaveException.error((IOSaveException.ErrorCode)IOSaveException.ErrorCode.MESSAGE_UNPROCESSED);
        }
        String traceId = this.getTraceId(requestContext, inbound);
        String loggingEnabled = requestContext.getHeaderString(RequestHeaders.LOGGING_ENABLED.getHeaderName());
        if (RequestUtils.loggingEnabled((String)loggingEnabled, (String)requestId)) {
            RequestUtils.setupTracing((String)traceId);
            try {
                RequestEntity message = RequestUtils.createInboundMessage((String)requestId, (String)traceId, (boolean)saveRequestBody, (String)this.getRequestBody(requestContext, null), null, null);
                log.info("Received message with id {} ", (Object)message.getRequestId());
                RequestManager.setCurrentMessage((RequestEntity)message);
                RequestEntity inboundMessage = this.requestReceiverService.preHandle(message);
                if (inboundMessage.getProcessed() == RequestStatus.PROCESSED) {
                    this.handleProcessedMessage(inboundMessage);
                }
            }
            catch (IOSaveException e) {
                log.error("Unable to process message. REASON: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                log.error("Unable to process message. REASON: {}", (Object)e.getMessage());
                throw IOSaveException.error((IOSaveException.ErrorCode)IOSaveException.ErrorCode.MESSAGE_UNPROCESSED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        block13: {
            Inbound inbound = this.getInbound().orElse(null);
            if (null == inbound) {
                return;
            }
            boolean saveRequestBody = this.shouldSaveBody(inbound);
            String requestId = this.getRequestId(requestContext, inbound);
            String loggingEnabled = requestContext.getHeaderString(RequestHeaders.LOGGING_ENABLED.getHeaderName());
            String traceId = this.getTraceId(requestContext, inbound);
            if (!RequestUtils.loggingEnabled((String)loggingEnabled, (String)requestId)) break block13;
            RequestEntity inboundMessage = RequestManager.getCurrentMessage();
            RequestEntity message = null;
            try {
                if (inboundMessage != null && inboundMessage.getProcessed() == RequestStatus.PROCESSED) {
                    log.info("Message with id {} already processed. Returning previous response", (Object)inboundMessage.getRequestId());
                    message = RequestUtils.createFromPreviousResponse((String)requestId, (String)traceId, (String)this.getRequestBody(requestContext, inboundMessage), (RequestEntity)inboundMessage, (Boolean)saveRequestBody);
                } else {
                    HashMap responseHeaders = new HashMap();
                    responseContext.getHeaders().forEach((key, value) -> responseHeaders.put(key, value.stream().map(String::valueOf).collect(Collectors.joining(","))));
                    message = RequestUtils.createInboundMessage((String)requestId, (String)traceId, (String)this.getRequestBody(requestContext, inboundMessage), (String)this.readFromResponse(responseContext), (Boolean)saveRequestBody, (RequestEntity)inboundMessage, (int)responseContext.getStatus(), (String)this.mapper.writeValueAsString(responseHeaders));
                    this.requestReceiverService.postHandle(message);
                }
            }
            catch (MappableException e) {
                log.warn("There is a mappable exception while trying to process the request");
            }
            catch (Exception e) {
                log.warn("Possible duplicate request can creep in.");
            }
            finally {
                if (message != null) {
                    log.info("Finished processing message with id {}. Response Code {}", (Object)message.getRequestId(), (Object)message.getResponseStatus());
                }
                RequestManager.endMessageProcessing();
                RequestUtils.endTransaction();
            }
        }
    }

    public static InboundMessageFilterBuilder builder() {
        return new InboundMessageFilterBuilder();
    }

    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    public static class InboundMessageFilterBuilder {
        private ASRequestRepository messageRepository;
        private ObjectMapper mapper;

        InboundMessageFilterBuilder() {
        }

        public InboundMessageFilterBuilder messageRepository(ASRequestRepository messageRepository) {
            this.messageRepository = messageRepository;
            return this;
        }

        public InboundMessageFilterBuilder mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public InboundMessageFilter build() {
            return new InboundMessageFilter(this.messageRepository, this.mapper);
        }

        public String toString() {
            return "InboundMessageFilter.InboundMessageFilterBuilder(messageRepository=" + this.messageRepository + ", mapper=" + this.mapper + ")";
        }
    }
}

